/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.ending;

import fxterm.module.Environment;
import fxterm.module.Pack;
import fxterm.module.PaymentEndingState;
import fxterm.module.stage.ending.BaseEndingModule;
import fxterm.msg.Messages;
import fxterm.session.Session;
import plfx.AudioPlayerFx;
import plfx.shell2.dialog.Dialog;
import plfx.util.TerminalPlatform;

public class SimpleEndingModule
extends BaseEndingModule {
    protected Environment environment;

    @Override
    public void _end(Environment environment) {
        this.environment = environment;
        Pack pack = environment.getPack();
        int paybackType = pack.getPaybackType();
        PaymentEndingState endingState = Session.getPaymentEndingState();
        this.log.info((Object)("Change type: " + Messages.getPaybackType(paybackType)));
        this.log.info((Object)("Is cancel: " + endingState.isCancel()));
        String dialogId = this.getDialogId();
        this.log.info((Object)("Select dialog: " + dialogId));
        TerminalPlatform.runLater((Runnable)new DialogRunner(dialogId));
    }

    protected String getDialogId() {
        String dialogId;
        Pack pack = this.environment.getPack();
        int paybackType = pack.getPaybackType();
        PaymentEndingState endingState = Session.getPaymentEndingState();
        if (endingState.isCancel()) {
            this.log.info((Object)"Payment was canceled by user");
            dialogId = paybackType == 1 ? (endingState.isSmsCheck() ? "module/ending/cancel_sms" : (endingState.isTimeOut() ? "module/ending/cancel_timeout" : "module/ending/cancel_pin")) : (paybackType == 5 ? "module/ending/cancel_mobile" : "module/ending/cancel_srv");
        } else {
            dialogId = paybackType == 1 ? (endingState.isSmsCheck() ? "module/ending/complete_sms" : "module/ending/complete_cbc") : (paybackType == 3 ? "module/ending/complete_srv" : (paybackType == 5 ? "module/ending/complete_mobile" : "module/ending/complete"));
        }
        return dialogId;
    }

    private class DialogRunner
    implements Runnable {
        private final String dialogId;

        public DialogRunner(String dialogId) {
            this.dialogId = dialogId;
        }

        @Override
        public void run() {
            AudioPlayerFx.getInstance().play("complete.mp3");
            SimpleEndingModule.this.log.info((Object)"Show a grateful dialog");
            Dialog.show((String)this.dialogId, actionId -> {
                SimpleEndingModule.this.log.info((Object)"Dialog closed");
                SimpleEndingModule.this.environment.getModules().getPresentModule().takePresent(SimpleEndingModule.this.environment);
            });
        }
    }
}

