/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.paytpl;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.input.BaseModule;
import fxterm.module.input.InitModuleHelper;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class BasePayTplModule
extends BaseModule {
    protected static final Logger log = LoggerId.PAY;
    protected CommonScreen current;
    protected Environment env;

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public int getInactivityTimeout() {
        return 120;
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null && intent.getType() == 3) {
            intent.process();
        } else if (!Session.getPayEnv().getKeeper().isEmpty()) {
            this.change(this.env.getPack());
        } else {
            this.exit();
        }
    }

    private void showScreen(ScreenDescription sd, Map<String, Object> data, ScreenListener sl) throws InitException, ScreenCreateException {
        log.info((Object)("------ Show screen: " + sd.getType() + ", title=" + sd.getTitle()));
        this.current = null;
        try {
            this.current = ScreenStore.getCommonScreen((String)sd.getType());
            log.debug((Object)"Process message templates");
            this.current.setListener(sl);
            log.debug((Object)"Init screen");
            Session.setScreenDescription(sd);
            this.current.init(sd, InitModuleHelper.buildScreenInit(this.env, data));
            log.debug((Object)"Show screen");
            FxEnv.showScreen((Screen)this.current);
            log.debug((Object)"Complete");
        }
        catch (InitException ex) {
            this.current = null;
            throw ex;
        }
    }

    protected void showScreenSafe(ScreenDescription sd, Map<String, Object> data, ScreenListener sl) {
        try {
            this.showScreen(sd, data, sl);
        }
        catch (ScreenCreateException | InitException ex) {
            log.error((Object)("Error on show screen " + sd.getType()), ex);
            this.exit((Exception)ex);
        }
    }

    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.exit(new IllegalArgumentException("Unknown action: " + action));
    }

    private void change(Pack pack) {
        if (pack.getSumResult() == null) {
            pack = Session.getPayEnv().getPack();
            this.env.setPack(pack);
            NewKeeper2 kpr = Session.getPayEnv().getKeeper();
            kpr.setSumOut(FinUtils.createVoidSum());
        }
        PackUtility.cancelPack(pack);
        Session.getPaymentEndingState().setCancel(true);
        this.env.getPack().setPaymentType(2);
        this.env.getPack().setPaybackType(0);
        this.env.getModules().getBeforePayoutModule().startPayout(this.env);
    }
}

