/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.uni;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.core.Sequence;
import fxterm.core.cache.CacheManager;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.Pack;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.ComplexScreenListener;
import fxterm.module.input.DataRender;
import fxterm.module.input.ExitModuleListener;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.InputModule;
import fxterm.module.input.uni.ScreenPos;
import fxterm.module.input.\u0421acheableAdapter;
import fxterm.module.stage.payment.BackIntent;
import fxterm.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.Store;
import ru.softlogic.parser.uni.FormNotFoundException;
import ru.softlogic.parser.uni.FormStore;
import ru.softlogic.reference.service.Service;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.system.util.PathUtils;

public class UniversalInputModule
extends BaseInputModule {
    private final ComplexScreenListener screenListener = new LocalScreenListener(this);
    private Environment environment;
    private Map<String, Object> data;
    private Form form;
    private Stack<Stack<ScreenPos>> states;
    private final FormStore store = new FormStore(PathUtils.getFilePath((String)"/res/module/input/universal/"), PathUtils.getFilePath((String)"/res/module/input/ds/"));
    private int currentScreen;

    public UniversalInputModule() {
        CacheManager.add(new \u0421acheableAdapter((Store)this.store));
    }

    @Override
    public void _start(Environment environment) {
        this.environment = environment;
        this.states = new Stack();
        this.screenListener.setEnvironment(environment);
        this.data = new LinkedHashMap<String, Object>();
        try {
            this.log.info((Object)"Start parce forms");
            Service srv = Session.getService();
            HashMap<String, Object> initData = new HashMap<String, Object>();
            initData.putAll(Session.getPointAttributes());
            this.form = this.store.getForm(srv.getCode(), Session.getLocale());
            ModuleHelper.prefillStore(this.form.getPrefillItem(), this.data);
            ModuleHelper.fillStore(environment.getInitData(), this.data);
            this.log.info((Object)("Form = " + this.form));
            this.currentScreen = 0;
            if (Session.getPaymentTemplateState().isSkipInput()) {
                this.log.info((Object)"Skip input module");
                this.toPayment();
            } else {
                this.showNext(this.form.getScreenSequence());
                this.log.info((Object)"Screen show");
            }
        }
        catch (InitException | FormNotFoundException ex) {
            this.exit((Exception)ex);
        }
    }

    private void showNext(ScreenSequence ss) throws InitException {
        StoreHelper.mergeData(this.data, (List)ss.getFields());
        Stack<ScreenPos> sses = new Stack<ScreenPos>();
        if (!this.states.isEmpty()) {
            sses.addAll((Collection)this.states.peek());
        }
        sses.push(new ScreenPos(ss, 0));
        this.states.push(sses);
        this.log.debug((Object)("Screen: " + ss.getScreens().get(0)));
        ++this.currentScreen;
        this.showScreenSafe((ScreenDescription)ss.getScreens().get(0));
    }

    private void showNext() {
        Stack<ScreenPos> copy = new Stack<ScreenPos>();
        copy.addAll((Collection)this.states.peek());
        while (!copy.isEmpty()) {
            ScreenPos sp = (ScreenPos)copy.pop();
            ScreenSequence ss = sp.getSequence();
            if (sp.getIndex() + 1 >= ss.getScreens().size()) continue;
            copy.push(new ScreenPos(sp.getSequence(), sp.getIndex() + 1));
            this.states.add(copy);
            ++this.currentScreen;
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex() + 1));
            return;
        }
        this.log.info((Object)"Script complete");
        if (this.form.getDemandMessage() != null && !this.form.getDemandMessage().isEmpty()) {
            this.toSendRequest();
        } else {
            this.showConfirm();
        }
    }

    private void showConfirm() {
        if (Session.getService().isFlagExist(1L)) {
            this.log.info((Object)"Show confirm screen");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            if (this.form.getConfirmScreen() != null && !this.form.getConfirmScreen().isEmpty()) {
                sd.setType(this.form.getConfirmScreen());
            }
            sd.setButtons(InitModuleHelper.createKeyMap());
            sd.setTitle(Session.getService().getName());
            this.showScreenSafe((ScreenDescription)sd, this.data, new ConfirmScreenListener());
        } else {
            this.startVerify(this.data);
        }
    }

    @Override
    protected void onSkipVerify() {
        this.log.info((Object)"onSkipVerify");
        this.toPayment();
    }

    @Override
    protected void onVerifyResult(Map<String, Object> result) {
        StoreHelper.mergeVerifyResult(this.data, result);
        if (Session.getService().isFlagExist(2048L)) {
            this.log.info((Object)"Show confirm after online verify");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            sd.setType("confirm/multiple");
            sd.setButtons(InitModuleHelper.createKeyMap());
            sd.setTitle(Session.getService().getName());
            this.showScreenSafe((ScreenDescription)sd, this.data, new VerifyConfirmScreenListener());
        } else {
            this.log.info((Object)"Skip showing confirm after online verify");
            this.toPayment();
        }
    }

    private void showPrev() {
        Stack<ScreenPos> popValue = this.states.pop();
        if (!this.states.empty()) {
            ScreenPos sp = this.states.peek().peek();
            --this.currentScreen;
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex()));
        } else {
            this.states.push(popValue);
            this.cancel(new BackIntent(this.environment.getModules().getLoadPaymentTemplateModule()));
        }
    }

    private void showScreenSafe(ScreenDescription sd) {
        this.barcodeScanner = sd.getBarcodeScanner();
        if (this.barcodeScanner != null && this.initBarcodeString != null) {
            this.processInitBarcodeString(this.initBarcodeString, this.data);
            this.initBarcodeString = null;
        }
        sd.setNavigations(this.processNavigationMap(this.createNaviMap()));
        this.showScreenSafe(sd, this.data, this.screenListener);
    }

    @Override
    public void _restore() {
        this.log.info((Object)"Restore input module");
        if (this.states.isEmpty()) {
            try {
                this.showNext(this.form.getScreenSequence());
            }
            catch (InitException ex) {
                this.exit((Exception)((Object)ex));
            }
        } else {
            ScreenPos sp = this.states.peek().peek();
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex()));
        }
    }

    @Override
    protected void mergeData(Map<String, Object> newData) {
        if (newData != null) {
            this.data.putAll(newData);
        }
    }

    @Override
    protected void showNextScreen() {
        this.showNext();
    }

    @Override
    protected void showCurrentScreen() {
        ScreenPos sp = this.states.peek().peek();
        this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex()));
    }

    private void toSendRequest() {
        this.log.info((Object)"Send demand request");
        int val = Sequence.getQuestionId();
        StringBuilder sb = new StringBuilder();
        for (InputElement ie : StoreHelper.convert(this.data)) {
            sb.append(ie.getKey()).append("=").append(ie.getValue()).append(";");
        }
        FxEnv.getConnector().putDemand(new Demand(val, Session.getService().getId(), sb.toString()));
        this.log.info((Object)"Show message");
        Dialog.show((String)"module/input/universal/demand", (DialogListener)new ExitModuleListener(this));
    }

    private void toPayment() {
        String value;
        InputElement number;
        this.log.info((Object)"Start payment");
        DataRender.dataToStr(this.data);
        Pack pack = this.environment.getPack();
        pack.setAllowReturn(this.form.getPaymentParams().isAllowReturn());
        pack.setPrintByOne(this.form.getPaymentParams().isSingleCheck());
        pack.setMinSum(this.getSum(this.data, this.form.getMinSumLimit()));
        pack.setMaxSum(this.getSum(this.data, this.form.getMaxSumLimit()));
        if (this.form.getChangeNumber() != null && (number = (InputElement)this.data.get(this.form.getChangeNumber())) != null && (value = number.getValue()) != null && !value.isEmpty()) {
            pack.setChangeNumber(number);
        }
        ScreenDescription ssd = this.form.getSumDescription();
        this._startPayment(this.environment, ssd, this.data, this.getOperationSum(this.data));
    }

    private Map<String, Object> getRedirectParams(List<String> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return map;
        }
        if (params.size() == 1 && "$all".equals(params.get(0))) {
            map.putAll(this.data);
        } else {
            for (String param : params) {
                map.put(param, this.data.get(param));
            }
        }
        return map;
    }

    private ActionMap createNaviMap() {
        ArrayList<Action> list = new ArrayList<Action>();
        for (int i = 1; i < this.currentScreen; ++i) {
            list.add(new Action("navi" + i, "\u0428\u0430\u0433 " + i, "navi" + i));
        }
        return list.isEmpty() ? null : new ActionMap(list);
    }

    private Map<String, ButtonInit> processNavigationMap(ActionMap navigation) {
        if (navigation == null) {
            return null;
        }
        LinkedHashMap<String, ButtonInit> navibuttons = new LinkedHashMap<String, ButtonInit>();
        for (Action a : navigation.getActions()) {
            ButtonInit bi = new ButtonInit(a.getTitle(), a.isCurent());
            bi.setEnable(false);
            navibuttons.put(a.getType(), bi);
        }
        return navibuttons;
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(InputModule inputModule) {
            super(inputModule);
        }

        @Override
        public void _onAction(String action, Map<String, Object> local, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("action=" + action + ", data=" + local));
            UniversalInputModule.this.cancelListener = cancelListener;
            Object redirect = local.get("#redirect");
            if (redirect != null && redirect instanceof RedirectCustomData) {
                UniversalInputModule.this.log.info((Object)"Process redirect");
                UniversalInputModule.this.data.putAll(local);
                RedirectCustomData redirectData = (RedirectCustomData)redirect;
                UniversalInputModule.this._redirect(redirectData.getService(), UniversalInputModule.this.getRedirectParams(redirectData.getParams()));
            } else {
                Object sequence = local.remove("#sequence");
                try {
                    if (sequence instanceof SequenceCustomData) {
                        UniversalInputModule.this.log.info((Object)("Process nested data: " + sequence));
                        SequenceCustomData sequenceData = (SequenceCustomData)sequence;
                        ScreenSequence ss = sequenceData.getScreenSequence();
                        List screens = ss.getScreens();
                        if (screens != null && !screens.isEmpty()) {
                            UniversalInputModule.this.data.putAll(local);
                            UniversalInputModule.this.showNext(ss);
                        } else {
                            UniversalInputModule.this.data.putAll(local);
                            StoreHelper.mergeData((Map)UniversalInputModule.this.data, (List)ss.getFields());
                            UniversalInputModule.this.showNext();
                        }
                    } else {
                        switch (action) {
                            case "next": {
                                UniversalInputModule.this.data.putAll(local);
                                DataRender.dataToStr(UniversalInputModule.this.data);
                                UniversalInputModule.this.showNext();
                                break;
                            }
                            case "prev": {
                                DataRender.dataToStr(UniversalInputModule.this.data);
                                UniversalInputModule.this.showPrev();
                                break;
                            }
                            case "exit": {
                                DataRender.dataToStr(UniversalInputModule.this.data);
                                UniversalInputModule.this.cancel(null);
                                break;
                            }
                            default: {
                                UniversalInputModule.this.data.putAll(local);
                                DataRender.dataToStr(UniversalInputModule.this.data);
                                UniversalInputModule.this.onUnknownAction(action, UniversalInputModule.this.data, cancelListener);
                            }
                        }
                    }
                }
                catch (InitException ex) {
                    GuiNotifier.notifyError((Throwable)ex);
                }
            }
        }
    }

    private class VerifyConfirmScreenListener
    extends BaseScreenListener {
        private VerifyConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            UniversalInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                UniversalInputModule.this.toPayment();
            } else if (ActionType.isExit((String)action)) {
                UniversalInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                UniversalInputModule.this._restore();
            } else {
                UniversalInputModule.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    private class ConfirmScreenListener
    extends BaseScreenListener {
        private ConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> local, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            UniversalInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                UniversalInputModule.this.startVerify(UniversalInputModule.this.data);
            } else if (ActionType.isExit((String)action)) {
                UniversalInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                UniversalInputModule.this._restore();
            } else {
                UniversalInputModule.this.onUnknownAction(action, UniversalInputModule.this.data, cancelListener);
            }
        }
    }
}

