/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.site;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.InitModuleHelper;
import fxterm.session.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.LocalSiteScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;

public class LocalSiteInputModule
extends BaseInputModule {
    private MenuItem menuItem;
    private Environment environment;
    private Map<String, Object> data;
    private final SiteListener listener = new SiteListener();
    private final SumScreenDescription sumDescription = new SumScreenDescription();

    public LocalSiteInputModule() {
        this.sumDescription.setType("sum");
    }

    @Override
    protected void _start(Environment environment) {
        this.environment = environment;
        this.menuItem = Session.getSelectedItem();
        this.data = new HashMap<String, Object>();
        try {
            LocalLoadStart task = new LocalLoadStart();
            task.process();
        }
        catch (Exception ex) {
            this.exit(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private File loadSite(String path) throws ParseException {
        File siteDir = new File(path);
        if (!siteDir.exists() || !siteDir.isDirectory()) {
            throw new ParseException("Wrong site directory: " + path);
        }
        File siteZip = new File(siteDir, "site.zip");
        if (!siteZip.exists()) {
            throw new ParseException("File 'site.zip' not found");
        }
        File temp = new File(siteDir, "temp");
        if (!(temp.exists() && siteDir.isDirectory() || temp.mkdir())) {
            throw new ParseException("Can not create temp directory");
        }
        if (new File(temp, "index.html").exists() && new File(temp, "site.crc").exists()) {
            try {
                long zipcrc = FileUtil.calculateChecksum((File)siteZip);
                long sitecrc = Long.parseLong(FileUtils.readFileToString((File)new File(temp, "site.crc")));
                if (sitecrc != zipcrc) {
                    this.unPackSute(siteZip, temp);
                }
            }
            catch (IOException | FileUtilException ex) {
                this.log.error((Object)ex);
                this.unPackSute(siteZip, temp);
            }
        } else {
            this.unPackSute(siteZip, temp);
        }
        File site = new File(temp, "index.html");
        if (!site.exists()) {
            throw new ParseException("File 'index.html' is not found");
        }
        return site;
    }

    private void unPackSute(File zip, File temp) throws ParseException {
        try (ZipFile site = new ZipFile(zip);){
            FileUtils.cleanDirectory((File)temp);
            Enumeration<? extends ZipEntry> entries = site.entries();
            LinkedList<ZipEntry> zfiles = new LinkedList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry2 = entries.nextElement();
                if (entry2.isDirectory()) {
                    new File(temp, entry2.getName()).mkdir();
                    continue;
                }
                zfiles.add(entry2);
            }
            zfiles.forEach(entry -> {
                try (InputStream in = site.getInputStream((ZipEntry)entry);
                     FileOutputStream out = new FileOutputStream(new File(temp, entry.getName()));){
                    int len;
                    this.log.info((Object)("Unzip file: " + entry.getName()));
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            File crcFile = new File(temp, "site.crc");
            if (!crcFile.exists()) {
                crcFile.createNewFile();
            }
            FileUtils.write((File)crcFile, (CharSequence)("" + FileUtil.calculateChecksum((File)zip)));
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    private Map<String, Object> parseInputElements(String data) throws ParseException {
        LinkedHashMap<String, Object> inputs = new LinkedHashMap<String, Object>();
        try {
            JSONArray in = new JSONArray(data);
            for (int i = 0; i < in.length(); ++i) {
                JSONObject elem = in.getJSONObject(i);
                InputElement ie = new InputElement();
                ie.setKey(elem.getString("key"));
                ie.setKeyTitle(elem.isNull("keytitle") ? elem.getString("key") : elem.getString("keytitle"));
                ie.setValue(elem.getString("value"));
                ie.setValueTitle(elem.isNull("valuetitle") ? elem.getString("value") : elem.getString("valuetitle"));
                ie.setFlags(elem.isNull("flags") ? 0 : elem.getInt("flags"));
                inputs.put(ie.getKey(), ie);
            }
        }
        catch (JSONException ex) {
            throw new ParseException((Throwable)ex);
        }
        return inputs;
    }

    private Map<String, Object> parsePrintingData(String data) throws ParseException {
        LinkedHashMap<String, Object> inputs = new LinkedHashMap<String, Object>();
        try {
            JSONObject in = new JSONObject(data);
            String[] names = JSONObject.getNames((JSONObject)in);
            if (names != null) {
                for (String name : names) {
                    inputs.put(name, in.getString(name));
                }
            }
        }
        catch (JSONException ex) {
            throw new ParseException((Throwable)ex);
        }
        return inputs;
    }

    private class SiteListener
    extends BaseScreenListener {
        private SiteListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            LocalSiteInputModule.this.log.info((Object)("Action on site screen: " + action));
            if ("toMain".equals(action)) {
                LocalSiteInputModule.this.log.info((Object)"Go to main menu");
                LocalSiteInputModule.this.exit();
            } else if ("toBack".equals(action)) {
                LocalSiteInputModule.this.log.info((Object)"Go to back menu");
                LocalSiteInputModule.this.back();
            } else if ("toPay".equals(action)) {
                try {
                    Object object = data.get("data");
                    if (object == null) {
                        throw new ParseException("Atribute 'data' can not be null");
                    }
                    Sum sumOper = LocalSiteInputModule.this.createSum((Integer)data.get("sum"));
                    String srcData = (String)object;
                    Map ies = LocalSiteInputModule.this.parseInputElements(srcData);
                    LocalSiteInputModule.this.log.info((Object)("Go to payment module. Data: " + ies));
                    LocalSiteInputModule.this._startPayment(LocalSiteInputModule.this.environment, (ScreenDescription)LocalSiteInputModule.this.sumDescription, ies, sumOper);
                }
                catch (ParseException ex) {
                    LocalSiteInputModule.this.exit((Exception)((Object)ex));
                }
            } else if ("toService".equals(action)) {
                try {
                    Object object = data.get("id");
                    if (object == null) {
                        throw new ParseException("Atribute 'id' can not be null");
                    }
                    short id = (Short)object;
                    LocalSiteInputModule.this.log.info((Object)("Go to service id:" + id));
                    LocalSiteInputModule.this._redirect(id, new HashMap());
                }
                catch (ParseException ex) {
                    LocalSiteInputModule.this.exit((Exception)((Object)ex));
                }
            } else if ("toPrinter".equals(action)) {
                try {
                    Object object = data.get("template");
                    if (object == null) {
                        throw new ParseException("Atribute 'template' can not be null");
                    }
                    LocalSiteInputModule.this.log.info((Object)("Printing custom template: " + (String)object));
                    Map<String, Object> printdata = new HashMap<String, Object>();
                    if (data.get("data") != null) {
                        printdata = LocalSiteInputModule.this.parsePrintingData((String)data.get("data"));
                    }
                    FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob((String)object, printdata));
                }
                catch (ParseException ex) {
                    LocalSiteInputModule.this.exit((Exception)((Object)ex));
                }
            }
            cancelListener.run();
        }
    }

    private class LocalLoadStart
    extends Task {
        private LocalLoadStart() {
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        protected Object execute() throws Exception {
            LocalSiteInputModule.this.log.info((Object)"Load site");
            File site = LocalSiteInputModule.this.loadSite(PathUtils.getPath((String)("/res/module/input/site/" + LocalSiteInputModule.this.menuItem.getService().getCode() + "/")));
            LocalSiteInputModule.this.log.info((Object)"Load site success");
            return site;
        }

        protected void onResult(Object object) {
            if (object instanceof File) {
                File site = (File)object;
                try {
                    LocalSiteInputModule.this.log.info((Object)"------ Show site screen");
                    CommonScreen cs = ScreenStore.getCommonScreen((String)"site");
                    LocalSiteScreenDescription sd = new LocalSiteScreenDescription();
                    sd.setUrl(site.toURI().toString());
                    LocalSiteInputModule.this.log.debug((Object)"Init screen");
                    Session.setScreenDescription((ScreenDescription)sd);
                    cs.init((ScreenDescription)sd, InitModuleHelper.buildScreenInit(LocalSiteInputModule.this.environment, LocalSiteInputModule.this.data));
                    cs.setListener((ScreenListener)LocalSiteInputModule.this.listener);
                    LocalSiteInputModule.this.log.debug((Object)"Show screen");
                    FxEnv.showScreen((Screen)cs);
                    LocalSiteInputModule.this.log.debug((Object)"Complete");
                }
                catch (ScreenCreateException | InitException ex) {
                    LocalSiteInputModule.this.exit((Exception)ex);
                }
            } else if (object instanceof Exception) {
                LocalSiteInputModule.this.exit((Exception)object);
            } else {
                LocalSiteInputModule.this.exit(new Exception("Unknown exception"));
            }
        }

        @Override
        protected void onError(Exception ex) {
            LocalSiteInputModule.this.exit(ex);
        }

        public String toString() {
            return "LocalLoadStart{}";
        }
    }
}

