/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.mobile;

import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.MobileSearchVisitor;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.ComplexScreenListener;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.InputModule;
import fxterm.module.stage.payment.BackIntent;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import plfx.screen.ScreenListener;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.mob.CityProfile;
import ru.softlogic.parser.mob.LocalNumberExtractor;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.Service;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.system.util.PathUtils;

public class MobileInputModule
extends BaseInputModule {
    private static final String moduleId = "input/mobile";
    private String cityCode;
    private String currentNumber;
    private boolean verifyUnknownNumbers;
    private Environment environment;
    private Map<String, Object> data;
    private ScreenDescription mobileScreenDescription;
    private final ComplexScreenListener screenListener = new LocalScreenListener(this);
    private final Properties moduleProperties = InitModuleHelper.readModuleOptions("input/mobile");
    private final LocalNumberExtractor lne = new LocalNumberExtractor(PathUtils.getFilePath((String)"/res/module/input/mobile//capacity-local.xml"));
    private CityProfile cp;

    @Override
    protected void _start(Environment environment) {
        this.environment = environment;
        this.currentNumber = null;
        this.cityCode = null;
        this.data = new HashMap<String, Object>();
        this.screenListener.setEnvironment(environment);
        ModuleHelper.fillStore(environment.getInitData(), this.data);
        if (Session.getPoint() != null) {
            this.cityCode = Session.getPoint().getCityCode();
            this.log.info((Object)("City code: " + this.cityCode));
        }
        this.cp = this.lne.getCityProfile(this.cityCode);
        this.log.info((Object)("City profile: " + this.cp));
        if (this.mobileScreenDescription == null) {
            new CapacityLoaderTask().process();
        } else {
            this.toShowNumberPanel();
        }
    }

    @Override
    protected void _restore() {
        this.cancelListener.run();
        this.toConfirm("prev");
    }

    @Override
    protected void onSkipVerify() {
        this.log.info((Object)"onSkipVerify");
        this.toPayment();
    }

    @Override
    protected void onVerifyResult(Map<String, Object> result) {
        StoreHelper.mergeVerifyResult(this.data, result);
        if (Session.getService().isFlagExist(2048L)) {
            this.log.info((Object)"Show confirm after online verify");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            String type = this.getConfirmVerifyType();
            this.log.info((Object)("Confirm type: " + type));
            sd.setType(type);
            this.showScreenSafe((ScreenDescription)sd, this.data, new VerifyConfirmScreenListener());
        } else {
            this.log.info((Object)"Skip showing confirm after online verify");
            this.toPayment();
        }
    }

    private void toShowNumberPanel() {
        this.log.debug((Object)"toShowNumberPanel");
        if (this.mobileScreenDescription != null) {
            this.mobileScreenDescription.setType(this.getNumericType());
            this.showScreenSafe(this.mobileScreenDescription, this.data, this.screenListener);
        } else {
            this.exit(new Exception("Mobile form is not found"));
        }
    }

    private void toAskAboutChange(short serviceId) {
        this.log.debug((Object)"toAskAboutChange");
        MobileSearchVisitor mbcv = new MobileSearchVisitor(serviceId);
        MenuUtils.processMenu(mbcv);
        MenuItem realItem = mbcv.getMenuItem();
        this.log.info((Object)("\u041f\u0443\u043d\u043a\u0442 \u0434\u043b\u044f \u0437\u0430\u043c\u0435\u043d\u044b: " + realItem));
        this.log.info((Object)"\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043c\u0435\u043d\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        String realCurrency = realItem.getService().getInCurrency();
        if (!realCurrency.equals(keeper.getCurrency())) {
            Dialog.show((String)"module/input/mobile/phone_invalid", (DialogListener)new CancelDialogListener(this.cancelListener));
            return;
        }
        Session.setActiveItem(realItem);
        this.toConfirm("next");
    }

    private void toConfirm(String actionType) {
        boolean flagShowConfirm = Session.getService().isFlagExist(1L);
        this.log.info((Object)("toConfirm, is-show: " + flagShowConfirm));
        LocalConfirmListener localConfirmListener = new LocalConfirmListener();
        if (flagShowConfirm) {
            this.toConfirm(localConfirmListener);
        } else if ("next".equals(actionType)) {
            localConfirmListener.onAction("next", this.data, () -> {});
        } else {
            localConfirmListener.onAction("prev", this.data, () -> {});
        }
    }

    private void toConfirm(ScreenListener sl) {
        ConfirmScreenDescription sd = new ConfirmScreenDescription();
        String type = this.getConfirmType();
        this.log.info((Object)("Confirm type: " + type));
        sd.setType(type);
        this.showScreenSafe((ScreenDescription)sd, this.data, sl);
    }

    private void toVerify() {
        this.log.debug((Object)("toVerify " + Session.getService()));
        this.startVerify(this.data);
    }

    private void toPayment() {
        SumScreenDescription ssd = InitModuleHelper.createSumScreenDescription();
        ssd.setType(this.getSumType());
        this._startPayment(this.environment, (ScreenDescription)ssd, this.data, null);
    }

    private void toAskAboutPayment() {
        this.log.debug((Object)"toAskAboutPayment");
        this.log.info((Object)"\u0421\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b");
        Dialog.show((String)"module/input/mobile/phone_unknown", actionId -> {
            this.log.info((Object)("User make choice: " + actionId));
            if (actionId == 0) {
                this.notifyUnknownNumber(this.currentNumber);
                this.toConfirm("next");
            } else {
                this.cancelListener.run();
            }
        });
    }

    public String toString() {
        return "MobileProvider";
    }

    private String getNumericType() {
        String defaultType = this.moduleProperties.getProperty("screen.numeric.default", "digital");
        return this.moduleProperties.getProperty("screen.numeric." + Session.getService().getId(), defaultType);
    }

    private String getConfirmType() {
        String defaultType = this.moduleProperties.getProperty("screen.confirm.default", "confirm");
        return this.moduleProperties.getProperty("screen.confirm." + Session.getService().getId(), defaultType);
    }

    private String getConfirmVerifyType() {
        String defaultType = this.moduleProperties.getProperty("screen.confirm.verify.default", "confirm");
        return this.moduleProperties.getProperty("screen.confirm.verify" + Session.getService().getId(), defaultType);
    }

    private String getSumType() {
        String defaultType = this.moduleProperties.getProperty("screen.sum.default", "sum");
        return this.moduleProperties.getProperty("screen.sum." + Session.getService().getId(), defaultType);
    }

    private class CapacityLoaderTask
    extends Task {
        private CapacityLoaderTask() {
        }

        @Override
        protected String getWaitId() {
            return "network.request";
        }

        protected Object execute() throws Exception {
            MobileInputModule.this.log.info((Object)"Load success, read mobile form");
            try {
                MobileInputModule.this.mobileScreenDescription = InitModuleHelper.readScreenDesc(MobileInputModule.moduleId, Session.getLocale(), 1);
            }
            catch (ParseException ex) {
                MobileInputModule.this.log.error((Object)"Erron on load form", (Throwable)ex);
            }
            MobileInputModule.this.log.info((Object)"Done");
            return null;
        }

        protected void onResult(Object object) {
            MobileInputModule.this.toShowNumberPanel();
        }

        @Override
        protected void onError(Exception ex) {
            MobileInputModule.this.log.error((Object)"Error on load capacity", (Throwable)ex);
        }

        public String toString() {
            return "CapacityLoaderTask{}";
        }
    }

    private class VerifyConfirmScreenListener
    extends BaseScreenListener {
        private VerifyConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            MobileInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            MobileInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                MobileInputModule.this.toPayment();
            } else if (ActionType.isExit((String)action)) {
                MobileInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                MobileInputModule.this._restore();
            }
        }
    }

    private class LocalConfirmListener
    extends BaseScreenListener {
        private LocalConfirmListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            MobileInputModule.this.log.info((Object)("Confirm action: " + action));
            MobileInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                MobileInputModule.this.toVerify();
            } else if (ActionType.isExit((String)action)) {
                MobileInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                Session.setActiveItem(Session.getSelectedItem());
                MobileInputModule.this.toShowNumberPanel();
            }
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(InputModule inputModule) {
            super(inputModule);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            MobileInputModule.this.cancelListener = cancelListener;
            MobileInputModule.this.log.info((Object)("User action: " + action));
            MobileInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action)) {
                MobileInputModule.this.cancel(new BackIntent(MobileInputModule.this.environment.getModules().getLoadPaymentTemplateModule()));
            } else if (ActionType.isExit((String)action)) {
                MobileInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Session.setActiveItem(Session.getSelectedItem());
                NewKeeper2 keeper = Session.getPayEnv().getKeeper();
                String keeperCurrency = keeper.getCurrency();
                String serviceCurrency = Session.getSelectedItem().getService().getInCurrency();
                if (!serviceCurrency.equals(keeperCurrency)) {
                    if (keeper.isEmpty()) {
                        keeper.reset();
                    } else {
                        Dialog.show((String)"module/input/mobile/currency_error", (DialogListener)new CancelDialogListener(cancelListener));
                        return;
                    }
                }
                MobileInputModule.this.data = data;
                InputElement ie = (InputElement)data.get("id1");
                MobileInputModule.this.log.info((Object)ie);
                Session.setItem("input_number", ie.getValueTitle());
                MobileInputModule.this.currentNumber = MobileInputModule.this.cp.convertNumber(ie.getValue());
                if (!ie.getValue().equals(MobileInputModule.this.currentNumber)) {
                    MobileInputModule.this.log.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u0437\u0430\u043c\u0435\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0430: " + MobileInputModule.this.currentNumber));
                    ie.setValue(MobileInputModule.this.currentNumber);
                }
                Short serviceId = IdentifyService.getOperator((String)MobileInputModule.this.currentNumber);
                MobileInputModule.this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c: " + serviceId));
                if (serviceId == -1) {
                    MobileInputModule.this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0444\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c, \u0441\u043c\u043e\u0442\u0440\u0438\u043c \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430");
                    serviceId = MobileInputModule.this.cp.getOperator(MobileInputModule.this.currentNumber);
                    if (serviceId == null) {
                        MobileInputModule.this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u0430\u043c");
                        MobileInputModule.this.verifyUnknownNumbers = (Session.getActiveItem().getFlags() & 2) != 0;
                        if (MobileInputModule.this.verifyUnknownNumbers) {
                            MobileInputModule.this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443");
                            MobileInputModule.this.startVerify(data, true);
                            return;
                        }
                        MobileInputModule.this.toAskAboutPayment();
                        return;
                    }
                }
                if (serviceId.shortValue() == Session.getService().getCode()) {
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443");
                    MobileInputModule.this.toConfirm("next");
                } else if (Session.getService().getChildServices() != null && Session.getService().getChildServices().contains(serviceId)) {
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e. \u041f\u043e\u0434\u043c\u0435\u043d\u044f\u044e \u0441\u0435\u0440\u0432\u0438\u0441");
                    Service srv = new Service(Session.getSelectedItem().getService());
                    srv.setId(serviceId.shortValue());
                    Session.setService(srv);
                    Session.calculatePurchaseRange();
                    MenuItem mi = new MenuItem(Session.getSelectedItem());
                    mi.setService(srv);
                    Session.setActiveItem(mi);
                    MobileInputModule.this.toConfirm("next");
                } else {
                    ButtonStatus btnStatus;
                    MobileInputModule.this.log.info((Object)"\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u0440\u0443\u0433\u043e\u043c\u0443 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443");
                    MenuItemState mis = MenuUtils.getState(serviceId);
                    ButtonStatus buttonStatus = btnStatus = mis != null ? mis.getButtonStatus() : null;
                    if (btnStatus != null && (btnStatus == ButtonStatus.Blocked || btnStatus == ButtonStatus.Hidden)) {
                        MobileInputModule.this.log.info((Object)"\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441");
                        Dialog.show((String)"module/input/mobile/pay_on_blocked", (DialogListener)new CancelDialogListener(cancelListener));
                    } else {
                        MobileInputModule.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043d\u0430 \u0444\u043e\u0440\u043c\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
                        MobileInputModule.this.toAskAboutChange(serviceId);
                    }
                }
            } else {
                MobileInputModule.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }
}

