/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.keeper;

import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.input.keeper.KeeperContext;
import fxterm.module.input.keeper.KeeperInputLauncher;
import fxterm.module.input.keeper.KeeperInputModule;
import fxterm.module.input.mobile.MobileInputModule;
import fxterm.session.Session;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import ru.slkf.atm.AtmInputListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;

public class MobileKeeperInputModule
extends MobileInputModule
implements KeeperInputModule {
    private AtmInputListener listener;
    private final KeeperContext context;

    public MobileKeeperInputModule(KeeperContext context) {
        this.context = context;
    }

    @Override
    public void setListener(AtmInputListener listener) {
        this.listener = listener;
    }

    @Override
    protected void _start(Environment environment) {
        this.context.restore();
        this.context.setLastIM(this);
        super._start(environment);
    }

    @Override
    public void restore() {
        this._restore();
        this.context.restore();
    }

    @Override
    protected void _redirect(short serviceId, Map<String, Object> params) {
        this.log.info((Object)("Requested redirect to service: " + serviceId));
        this.listener.onRedirect((int)serviceId);
        Platform.runLater(() -> KeeperInputLauncher.launch(serviceId, this.listener, params, this.context, false));
    }

    @Override
    protected void back() {
        this.listener.onBack();
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null && intent.getType() == 0) {
            this.context.cancel(intent);
        } else {
            this.listener.onExit();
        }
    }

    @Override
    public boolean canRedirect() {
        return false;
    }

    @Override
    protected void _startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data) {
        this._startPayment(environment, (ScreenDescription)ssd, data, null);
    }

    @Override
    protected void _startPayment(Environment environment, ScreenDescription ssd, Map<String, Object> data, Sum oper) {
        Short sid = null;
        if (Session.getSelectedItem().getService().getId() != Session.getService().getId()) {
            sid = Session.getService().getId();
        }
        this.listener.onPay(StoreHelper.clear(data), sid, oper != null ? Integer.valueOf(oper.getValue()) : null);
    }

    @Override
    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        Optional.ofNullable(cancelListener).ifPresent(Runnable::run);
        this.listener.onAction(action);
    }
}

