/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.keeper;

import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.DelayMenuChain;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.WarningMenuChain;
import fxterm.core.menu.GroupByMenuItemVisitor;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.Environment;
import fxterm.module.EnvironmentFactory;
import fxterm.module.input.InputModule;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.input.keeper.AdvancedKeeperInputModule;
import fxterm.module.input.keeper.KeeperContext;
import fxterm.module.input.keeper.KeeperHelper;
import fxterm.module.input.keeper.KeeperInputModule;
import fxterm.module.input.keeper.MobileKeeperInputModule;
import fxterm.module.input.keeper.UniversalKeeperInputModule;
import fxterm.session.Session;
import fxterm.utils.FormatUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.slkf.atm.AtmInputListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.reference.menu.MenuItem;

public class KeeperInputLauncher {
    private static final LaunchChain chain;
    private static final Logger log;
    private static final Map<String, KeeperInputModule> modules;
    private static boolean startWithConfirm;
    private static volatile AtmInputListener ail;

    public static void launch(short serviceId, AtmInputListener listener, Map<String, Object> data, KeeperContext keeperModule, boolean startConfirm) {
        startWithConfirm = startConfirm;
        ail = listener;
        try {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId);
            MenuUtils.processMenu(mbsiv);
            MenuItem mi = mbsiv.getMenuItem();
            if (mi == null) {
                throw new ModuleCreateException("Menu item with id " + serviceId + " not founded");
            }
            String inputType = mi.getService().getProviderType().toString();
            log.info((Object)("Found service: " + mi.getService().getName() + ". Try to get handler, provider type: " + inputType));
            log.info((Object)"-------------------------------------------------------------------------------");
            log.info((Object)"Launch menu item");
            log.info((Object)("    Service     : " + FormatUtils.srvToString(mi.getService())));
            log.info((Object)("    Commission  : " + FormatUtils.commToString(mi.getCommission())));
            log.info((Object)("    Input data  : " + data));
            GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(mi);
            MenuUtils.processMenu(gbmiv);
            Session.setServiceType(gbmiv.getServiceType());
            Session.setSelectedItem(mi);
            LocalLaucher.setIm(KeeperInputLauncher.getInputModule(inputType, listener, keeperModule));
            chain.launch(mi, data, new NewKeeper2(Session.getInCurrency()));
        }
        catch (Exception ex) {
            log.error((Object)"Can't create module", (Throwable)ex);
            Dialog.show((String)"module/menu/error_create");
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    private static InputModule getInputModule(String type, AtmInputListener listener, KeeperContext keeperModule) throws ModuleCreateException {
        KeeperInputModule im = modules.get(type);
        if (im == null) {
            if ("Mobile".equals(type)) {
                MobileKeeperInputModule mim = new MobileKeeperInputModule(keeperModule);
                im = mim;
                modules.put(type, mim);
            } else if ("UniversalProvider".equals(type)) {
                UniversalKeeperInputModule uim = new UniversalKeeperInputModule(keeperModule);
                im = uim;
                modules.put(type, uim);
            } else if ("AdvancedProvider".equals(type)) {
                AdvancedKeeperInputModule aim = new AdvancedKeeperInputModule(keeperModule);
                im = aim;
                modules.put(type, aim);
            } else {
                throw new ModuleCreateException("Incorrect type of input module");
            }
        }
        im.setListener(listener);
        return (InputModule)((Object)im);
    }

    public static boolean isStartWithConfirm() {
        return startWithConfirm;
    }

    public static void resetStartWithConfirm() {
        startWithConfirm = false;
    }

    static {
        log = LoggerId.PAY;
        modules = new HashMap<String, KeeperInputModule>();
        LocalLaucher local = new LocalLaucher();
        WarningMenuChain warning = new WarningMenuChain(local);
        chain = new DelayMenuChain(warning);
    }

    private static class LocalScreenListener
    extends BaseScreenListener {
        private final InputModule im;
        private final Environment env;
        private final AtmInputListener listener;
        private final Map<String, Object> initData;

        public LocalScreenListener(InputModule inputModule, Environment e, AtmInputListener ail, Map<String, Object> data) {
            this.im = inputModule;
            this.env = e;
            this.listener = ail;
            this.initData = data;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            log.info((Object)("Action on Confirm Screen: " + action));
            if (ActionType.isNext((String)action)) {
                log.info((Object)"User select next");
                Map<String, InputElement> init = KeeperHelper.convert(this.initData);
                init.putAll(KeeperHelper.convert(data));
                this.listener.onPay(init, null, KeeperHelper.getSumPurchase(data));
            } else if (ActionType.isEdit((String)action)) {
                log.info((Object)"User select edit");
                this.im.start(this.env);
            } else {
                log.info((Object)"User select cancel");
                if (cancelListener != null) {
                    this.listener.onBack();
                }
            }
        }
    }

    private static class LocalLaucher
    implements LaunchChain {
        private static InputModule im;

        private LocalLaucher() {
        }

        public static void setIm(InputModule im) {
            LocalLaucher.im = im;
        }

        @Override
        public void launch(MenuItem menuItem, Map<String, Object> initData, NewKeeper2 keeper) {
            try {
                Environment environment = EnvironmentFactory.getInstance().create(menuItem, Session.getLocale());
                environment.setInitData(initData);
                log.info((Object)("Need to show confirm screen: " + startWithConfirm));
                if (startWithConfirm) {
                    KeeperHelper.showScreenSafe((ScreenDescription)KeeperHelper.getConfirmScreenDescription(), initData, new LocalScreenListener(im, environment, ail, initData), environment, log);
                } else {
                    im.start(environment);
                }
            }
            catch (ModuleCreateException ex) {
                log.error((Object)"Can't create module", (Throwable)ex);
                Dialog.show((String)"module/menu/error_create");
                GuiNotifier.notifyError((Throwable)ex);
            }
            catch (Throwable ex) {
                log.error((Object)"Unknown error process request", ex);
                Dialog.show((String)"module/menu/error_create");
                GuiNotifier.notifyError((Throwable)ex);
            }
        }
    }
}

