/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.keeper;

import fxterm.app.FxEnv;
import fxterm.module.Environment;
import fxterm.module.Payment;
import fxterm.module.input.InitModuleHelper;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import plfx.util.Locator;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;

public class KeeperHelper {
    public static Integer getSumPurchase(Map<String, Object> data) {
        Object obj = data.get("#sum");
        Integer sum = null;
        if (obj != null) {
            if (obj instanceof TransactionSum) {
                sum = ((TransactionSum)obj).getSum();
            } else if (obj instanceof InputElement) {
                try {
                    InputElement ie = (InputElement)obj;
                    if (ie.getOriginalValue() != null && !ie.getOriginalValue().isEmpty()) {
                        sum = (int)Math.round(Double.parseDouble(ie.getOriginalValue()) * 100.0);
                    } else if (ie.getValue() != null && !ie.getValue().isEmpty()) {
                        sum = (int)Math.round(Double.parseDouble(ie.getValue()) * 100.0);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (obj instanceof Sum) {
                sum = ((Sum)obj).getValue();
            }
        }
        return sum;
    }

    public static CommonSumScreen getCommonSumScreen(Environment env, Payment p) throws InitException, ScreenCreateException {
        if (p == null) {
            throw new IllegalArgumentException("Payment is not set");
        }
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("sum");
        String img = Session.getService().getImage();
        if (img != null && !img.isEmpty()) {
            ssd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + img)));
        } else {
            ssd.setIcon(null);
        }
        ssd.setStyleClass(Session.getService().getStyle());
        CommonSumScreen css = ScreenStore.getCommonSumScreen((String)ssd.getType());
        css.init((ScreenDescription)ssd, InitModuleHelper.buildScreenInit(env, p.getData(), Session.getService(), Session.getCommission()));
        return css;
    }

    public static ConfirmScreenDescription getConfirmScreenDescription() throws InitException, ScreenCreateException {
        ConfirmScreenDescription sd = new ConfirmScreenDescription();
        sd.setType("confirm/edit");
        String img = Session.getService().getImage();
        if (img != null && !img.isEmpty()) {
            sd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + img)));
        } else {
            sd.setIcon(null);
        }
        sd.setStyleClass(Session.getService().getStyle());
        return sd;
    }

    public static void showScreenSafe(ScreenDescription sd, Map<String, Object> data, ScreenListener sl, Environment env, Logger log) {
        String icon = Session.getService().getImage();
        String styleClass = Session.getService().getStyle();
        if (icon != null && !icon.isEmpty()) {
            sd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + icon)));
        } else {
            sd.setIcon(null);
        }
        sd.setStyleClass(styleClass);
        try {
            KeeperHelper.showScreen(sd, data, sl, env, log);
        }
        catch (ScreenCreateException | InitException ex) {
            log.error((Object)("Error on show screen " + sd.getType()), ex);
            Dialog.show((String)"module/menu/error_create");
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    private static void showScreen(ScreenDescription sd, Map<String, Object> data, ScreenListener listener, Environment env, Logger log) throws ScreenCreateException, InitException {
        log.info((Object)("------ Show screen: " + sd.getType() + ", title=" + sd.getTitle()));
        CommonScreen current = ScreenStore.getCommonScreen((String)sd.getType());
        log.debug((Object)"Process message templates");
        current.setListener(listener);
        log.debug((Object)"Init screen");
        Session.setScreenDescription(sd);
        current.init(sd, InitModuleHelper.buildScreenInit(env, data));
        log.debug((Object)"Show screen");
        FxEnv.showScreen((Screen)current);
        log.debug((Object)"Complete");
    }

    public static Map<String, InputElement> convert(Map<String, Object> data) {
        HashMap<String, InputElement> res = new HashMap<String, InputElement>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (!(e.getValue() instanceof InputElement)) continue;
            res.put(e.getKey(), (InputElement)e.getValue());
        }
        return res;
    }
}

