/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.keeper;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.keeper.KeeperInputLauncher;
import fxterm.module.input.keeper.KeeperInputModule;
import fxterm.module.stage.payment.keeper.KeeperPaymentLauncher;
import fxterm.session.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javafx.application.Platform;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.screen.TemplateCreateException;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.skin.Skin;
import plfx.util.Locator;
import ru.slkf.KeeperCreatingException;
import ru.slkf.KeeperModule;
import ru.slkf.KeeperModuleFactory;
import ru.slkf.atm.AtmAPI;
import ru.slkf.atm.AtmInputListener;
import ru.slkf.atm.AtmPaymentListener;
import ru.slkf.atm.PointInfo;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.system.util.PathUtils;

public class KeeperContext
extends BaseInputModule
implements AtmAPI {
    private static final String prefix = "kim_";
    private static final String KEY_INPUT_DATA = "INPUT_DATA_KEY";
    private final Map<String, Object> data = new HashMap<String, Object>();
    private KeeperModule keeperModule;
    private final Map<String, ScreenDescription> descriptions = new HashMap<String, ScreenDescription>();
    private Environment environment;
    private ServiceType keeperServiceType;
    private MenuItem keeperMenuItem;
    private KeeperInputModule lastIM;
    private static final Logger logDbg = LoggerId.DEBUG;
    private static final PointInfo pointInfo = new PointInfo();

    public KeeperContext() {
        try {
            File config = PathUtils.getFilePath((String)"/res/module/keeper/keeper.properties");
            if (!config.exists()) {
                throw new KeeperCreatingException("Configuration file 'keeper.properties' does not exist");
            }
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(config);){
                properties.load(fis);
            }
            catch (IOException ex) {
                throw new KeeperCreatingException("Configuration file is not read:" + ex.getMessage(), (Throwable)ex);
            }
            this.keeperModule = KeeperModuleFactory.create((File)PathUtils.getFilePath((String)"/res/module/keeper/"), (Properties)properties, (AtmAPI)this);
        }
        catch (KeeperCreatingException ex) {
            this.exit((Exception)((Object)ex));
        }
    }

    public MenuItem getKeeperMenuItem() {
        return this.keeperMenuItem;
    }

    public static boolean isKeeperPresent() throws ClassNotFoundException {
        Class.forName("ru.slkf.KeeperModuleFactory");
        return true;
    }

    @Override
    protected void _start(Environment environment) {
        this.log.info((Object)"Starting KeeperlInputModule");
        this.environment = environment;
        this.data.clear();
        KeeperInputLauncher.resetStartWithConfirm();
        try {
            this.keeperMenuItem = Session.getSelectedItem();
            this.keeperServiceType = Session.getServiceType();
            Skin.pushWorkSkin((String)("keeper/" + Skin.getWorkSkin()));
            this.keeperModule.start();
        }
        catch (Throwable t) {
            Skin.popWorkSkin();
            throw t;
        }
    }

    public ScreenDescription getScreenDescription(String path) throws ScreenCreateException {
        logDbg.info((Object)("Request to get screen Description: " + path));
        ScreenDescription sd = this.descriptions.get(Session.getLocale().getLanguage());
        if (sd == null) {
            try {
                String formsPath = "/" + this.keeperModule.getClass().getPackage().getName().replace(".", "/") + "/";
                String formPath = formsPath + path + "_" + Session.getLocale().getLanguage() + ".xml";
                InputStream stream = this.keeperModule.getClass().getResourceAsStream(formPath);
                Form f = null;
                if (stream == null) {
                    formPath = formsPath + path + ".xml";
                    stream = this.keeperModule.getClass().getResourceAsStream(formPath);
                }
                if (stream != null) {
                    f = Parser.getForm((InputStream)stream, (short)0, (File)PathUtils.getFilePath((String)"/res/module/input/ds/0/"));
                }
                if (f == null) {
                    File fileForm = PathUtils.getFilePath((String)("/res/module/keeper/" + path + "_" + Session.getLocale().getLanguage() + ".xml"));
                    if (!fileForm.exists()) {
                        fileForm = PathUtils.getFilePath((String)("/res/module/keeper/" + path + ".xml"));
                    }
                    f = Parser.getForm((File)fileForm, (short)0, (File)PathUtils.getFilePath((String)"/res/module/input/ds/0/"));
                }
                if (f.getScreenSequence().getScreens().size() != 1) {
                    throw new ParseException("Wrong number of screens");
                }
                sd = (ScreenDescription)f.getScreenSequence().getScreens().get(0);
            }
            catch (ParseException ex) {
                logDbg.error((Object)ex, (Throwable)ex);
                throw new ScreenCreateException((Throwable)ex);
            }
        }
        return sd;
    }

    public ScreenInit getScreenInit() {
        logDbg.info((Object)"Request to get screen init");
        return InitModuleHelper.createScreenInit();
    }

    public CommonScreen getScreen(String id) throws ScreenCreateException {
        logDbg.info((Object)("Request to get keeper screen id: " + id));
        return ScreenStore.getCommonScreen((String)id);
    }

    public CommonSumScreen getSumScreen(String id) throws ScreenCreateException {
        logDbg.info((Object)("Request to get keeper sum screen id: " + id));
        return ScreenStore.getCommonSumScreen((String)id);
    }

    public MenuTemplate getMenuTemplate(String id) throws TemplateCreateException {
        logDbg.info((Object)("Request to get keeper menu template id: " + id));
        return ScreenStore.getMenuTemplate((String)id);
    }

    public void setSessionScreenDescription(ScreenDescription sd) {
        Session.setScreenDescription(sd);
    }

    public void showScreen(Screen screen) {
        logDbg.info((Object)("Request to show keeper screen id: " + screen.getTemplate().getId()));
        FxEnv.showScreen(screen);
    }

    public void showCustomScreen(CommonScreen cs, ScreenListener sl, int i) {
        logDbg.info((Object)("Request to show custom keeper screen id: " + cs.getTemplate().getId()));
        FxEnv.getCustomModule().show(cs, sl, i);
    }

    public void showMenuTemplate(MenuTemplate template) {
        logDbg.info((Object)("Request to show keeper menu template id: " + template.getId()));
        FxEnv.showScreen((FxScreenTemplate)template);
    }

    public void showDialog(String id, DialogListener listener) {
        logDbg.info((Object)("Request to show dialog id: " + id));
        Dialog.show((String)id, (DialogListener)listener);
    }

    public <T> void execute(Callable<T> task, Consumer<T> resultHandler, Consumer<Exception> exeptionHandler) {
        logDbg.info((Object)"Request to execute task ");
        new Execution<T>(task, resultHandler, exeptionHandler).process();
    }

    public void setActiveField(int i) {
        Session.setActiveField(i);
    }

    public void setFieldPage(int n, int size) {
        Session.setFieldPage(n, size);
    }

    public void setMenuTitles(Map<String, Map<String, String>> titles) {
        Session.setMenuTitles(titles);
    }

    public void addDataItem(String key, Object value) {
        logDbg.info((Object)("Adding data item : key = " + key + ", value = " + value));
        this.data.put(prefix + key, value);
    }

    public void removeDataItem(String key) {
        logDbg.info((Object)("Remove data item : key = " + key));
        this.data.remove(prefix + key);
    }

    public void clearDataItems() {
        logDbg.info((Object)"Clear data items");
        this.data.clear();
    }

    public void startPaymentSession(short serviceId, Map<String, InputElement> map, AtmInputListener listener, boolean startConfirm) {
        this.log.info((Object)("Request to start keeper payment session with service: id = " + serviceId + ", data: " + this.data));
        if (map != null) {
            this.data.put(KEY_INPUT_DATA, map);
        }
        Platform.runLater(() -> KeeperInputLauncher.launch(serviceId, listener, this.getModuleData().get(), this, startConfirm));
    }

    public void restoreInputModule(AtmInputListener listener) {
        this.log.info((Object)("Request to restore input module: " + this.lastIM));
        if (this.lastIM != null) {
            Platform.runLater(() -> {
                this.lastIM.setListener(listener);
                this.lastIM.restore();
            });
        } else if (KeeperInputLauncher.isStartWithConfirm()) {
            this.log.info((Object)"Last input module is null. Return back action");
            listener.onBack();
        } else {
            this.log.info((Object)"Last input module is null. Return exit action");
            listener.onExit();
        }
    }

    public void receiptKeeper(Short id, String keeperLogin, Integer sum, AtmPaymentListener listener) {
        Platform.runLater(() -> KeeperPaymentLauncher.launch(id, keeperLogin, sum, listener, this));
    }

    public void endPaymentSession() {
        this.log.info((Object)"Request to end keeper payment session");
        this.lastIM = null;
        Session.setServiceType(this.keeperServiceType);
        Session.setSelectedItem(this.keeperMenuItem);
        this.data.remove(KEY_INPUT_DATA);
        KeeperInputLauncher.resetStartWithConfirm();
    }

    @Override
    public void exit() {
        this.log.info((Object)"Request to close keeper input module");
        Skin.popWorkSkin();
        KeeperInputLauncher.resetStartWithConfirm();
        super.exit();
    }

    @Override
    protected void _restore() {
        KeeperInputLauncher.resetStartWithConfirm();
    }

    @Override
    public boolean canRedirect() {
        return false;
    }

    @Override
    public int getInactivityTimeout() {
        return this.keeperModule.getInactivityTimeout();
    }

    @Override
    public void cancel(Intent intent) {
        this.log.info((Object)("Notifies keeper module about timeout with intent: " + intent));
        KeeperInputLauncher.resetStartWithConfirm();
        this.keeperModule.onTimeOut();
    }

    @Override
    public Optional<Map<String, Object>> getModuleData() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.data);
        Object obj = this.data.get(KEY_INPUT_DATA);
        if (obj instanceof Map) {
            result.remove(KEY_INPUT_DATA);
            result.putAll((Map)obj);
        }
        return Optional.of(result);
    }

    public KeeperInputModule getLastIM() {
        return this.lastIM;
    }

    public void setLastIM(KeeperInputModule lastIM) {
        this.lastIM = lastIM;
    }

    public Locale getLocale() {
        return Session.getLocale();
    }

    public PointInfo getPointInfo() {
        if (Session.getPoint() != null) {
            pointInfo.setPointId(Session.getPoint().getId());
            pointInfo.setPointName(Session.getPoint().getName());
            pointInfo.setPointAddress(Session.getPoint().getAddress());
            pointInfo.setPointCity(Session.getPoint().getCity());
            pointInfo.setPointAttributes(Session.getPoint().getAttributes());
        } else {
            pointInfo.setPointId(-1);
            pointInfo.setPointName(null);
            pointInfo.setPointAddress(null);
            pointInfo.setPointCity(null);
            pointInfo.setPointAttributes(null);
        }
        if (Session.getDealer() != null) {
            pointInfo.setDealerId(Session.getDealer().getId());
            pointInfo.setDealerName(Session.getDealer().getName());
            pointInfo.setDealerInn(Session.getDealer().getInn());
        } else {
            pointInfo.setDealerId(null);
            pointInfo.setDealerName(null);
            pointInfo.setDealerInn(null);
        }
        return pointInfo;
    }

    public KeeperModule getKeeperModule() {
        return this.keeperModule;
    }

    public void notifyUpdate() {
        Session.notifyUpdate();
    }

    public void preFillScreenDescription(ScreenDescription sd) {
        if (sd != null) {
            String img = Session.getService().getImage();
            if (img != null && !img.isEmpty()) {
                sd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + img)));
            } else {
                sd.setIcon(null);
            }
            sd.setStyleClass(Session.getService().getStyle());
        }
    }

    private class Execution<T>
    extends Task {
        private final Callable<T> task;
        private final Consumer<T> resultHandler;
        private final Consumer<Exception> exeptionHandler;

        public Execution(Callable<T> task, Consumer<T> resultHandler, Consumer<Exception> exeptionHandler) {
            this.task = Objects.requireNonNull(task, "task");
            this.resultHandler = Objects.requireNonNull(resultHandler, "resultHandler");
            this.exeptionHandler = Objects.requireNonNull(exeptionHandler, "exeptionHandler");
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        @Override
        protected T execute() throws Exception {
            return this.task.call();
        }

        protected void onResult(Object object) {
            this.resultHandler.accept(object);
        }

        @Override
        protected void onError(Exception ex) {
            this.exeptionHandler.accept(ex);
        }
    }
}

