/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.keeper;

import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.input.adv.AdvancedInputModule;
import fxterm.module.input.keeper.KeeperContext;
import fxterm.module.input.keeper.KeeperInputLauncher;
import fxterm.module.input.keeper.KeeperInputModule;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.slkf.atm.AtmInputListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;

public class AdvancedKeeperInputModule
extends AdvancedInputModule
implements KeeperInputModule {
    private AtmInputListener listener;
    private final KeeperContext context;

    public AdvancedKeeperInputModule(KeeperContext context) {
        this.context = context;
    }

    @Override
    public void setListener(AtmInputListener listener) {
        this.listener = listener;
    }

    @Override
    protected void _start(Environment environment) {
        this.context.restore();
        this.context.setLastIM(this);
        super._start(environment);
    }

    @Override
    public void restore() {
        this._restore();
        this.context.restore();
    }

    @Override
    protected void _redirect(short serviceId, Map<String, Object> params) {
        this.log.info((Object)("Requested redirect to service: " + serviceId));
        this.listener.onRedirect((int)serviceId);
        Platform.runLater(() -> KeeperInputLauncher.launch(serviceId, this.listener, params, this.context, false));
    }

    @Override
    protected void back() {
        this.listener.onBack();
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null && intent.getType() == 0) {
            this.context.cancel(intent);
        } else {
            this.listener.onExit();
        }
    }

    @Override
    public boolean canRedirect() {
        return false;
    }

    @Override
    protected void _startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data) {
        this._startPayment(environment, (ScreenDescription)ssd, data, null);
    }

    @Override
    protected void _startPayment(Environment environment, ScreenDescription ssd, Map<String, Object> data, Sum oper) {
        this.listener.onPay(StoreHelper.clear(data), null, oper != null ? Integer.valueOf(oper.getValue()) : null);
    }

    @Override
    protected void startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data, Sum operationSum, Service srv, Commission comm, Object pCart) throws InitException {
        this.log.error((Object)"Group operations are not supported by this module");
        Dialog.show((String)"module/input/error_exit");
        GuiNotifier.notifyError((String)"Group operations are not supported by this module");
    }

    @Override
    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        Optional.ofNullable(cancelListener).ifPresent(Runnable::run);
        this.listener.onAction(action);
    }

    @Override
    protected void exit(Exception ex) {
        this.log.info((Object)"Finish module with error: ", (Throwable)ex);
        this.beforeClose();
        Dialog.show((String)"module/input/error_exit");
        GuiNotifier.notifyErrorOnce((String)ex.getMessage());
        this.listener.onExit();
    }
}

