/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.card;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.input.card.BaseCardInputModule;
import fxterm.module.stage.processing.BankCardProcessingModule;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;

public class CashToCardInputModule
extends BaseCardInputModule {
    private Map<String, Object> data;
    private AccountInfo ai;

    @Override
    protected void _startOperation() {
        try {
            this.log.info((Object)"Start card operation");
            this.env.getModules().setProcessingModule(new BankCardProcessingModule());
            FxEnv.getCardModuleHandler().setOperationDepositResultListener(new DepositOperationListener());
            this.cm.deposit(FxEnv.getCardModuleHandler().getOperationDepositResultListener());
            this.log.info((Object)"Done");
        }
        catch (Exception ex) {
            this.exit(ex);
        }
    }

    @Override
    protected void onClosed() {
        this.log.info((Object)"Cash to card operation closed. Exit from module");
        this.exit();
    }

    @Override
    public void onCashRequire(boolean b, AccountInfo ai, CashRequireListener cl) {
        Platform.runLater(() -> {
            this.log.info((Object)("On cash require " + ai));
            this.ai = ai;
            this.hideWait();
            FxEnv.getCardModuleHandler().setCashRequireListener(cl);
            FxEnv.getCardModuleHandler().setBankCashRequireListener(null);
            this.log.info((Object)"Show commission dialog ");
            this.data = new HashMap<String, Object>();
            String number = Optional.ofNullable(ai).map(AccountInfo::getNumber).orElse("");
            this.data.put("id1", new InputElement("id1", CardModuleHandler.getMessage("title_number"), number));
            this.cancelListener = () -> ((CashRequireListener)cl).onCancel();
            this.startVerify(this.data);
        });
    }

    @Override
    protected void onSkipVerify() {
        this.log.info((Object)"onSkipVerify");
        this.toPayment();
    }

    @Override
    protected void onVerifyResult(Map<String, Object> result) {
        StoreHelper.mergeVerifyResult(this.data, result);
        if (Session.getService().isFlagExist(2048L)) {
            this.log.info((Object)"Show confirm after online verify");
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            sd.setType("confirm/multiple");
            this.showScreenSafe((ScreenDescription)sd, this.data, new BaseScreenListener(){

                public void onAction(String action, Map<String, Object> data, Runnable cl) {
                    if (ActionType.isNext((String)action)) {
                        CashToCardInputModule.this.toPayment();
                    } else {
                        CashToCardInputModule.this.cancel(null);
                    }
                }
            });
        } else {
            this.log.info((Object)"Skip showing confirm after online verify");
            this.toPayment();
        }
    }

    private void toPayment() {
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("sum");
        if (this.ai != null) {
            this.data.put("id1", new InputElement("id1", CardModuleHandler.getMessage("title_number"), this.ai.getNumber()));
            this.data.put("id2", new InputElement("id2", CardModuleHandler.getMessage("title_currency"), this.ai.getCurrency().getAlphaCode()));
            this.data.put("type", new InputElement("type", CardModuleHandler.getMessage("title_type"), this.ai.getType().getStringCode(), String.valueOf(this.ai.getType()), 0));
        }
        this._startPayment(this.env, ssd, this.data);
    }

    private class DepositOperationListener
    implements CardModuleResultListener<OperationDepositResult> {
        private DepositOperationListener() {
        }

        public void onError(CardModuleError cme, String message) {
            Platform.runLater(() -> {
                CashToCardInputModule.this.log.info((Object)("Deposit operation error: " + cme + ", " + message));
                CashToCardInputModule.this.hideWait();
                CashToCardInputModule.this.exit(cme, message);
            });
        }

        public void onResult(OperationDepositResult t, CardInfo ci) {
            CashToCardInputModule.this.exit(new IllegalAccessException("Can not invoke method in CashToCardInputModule"));
        }

        public void onCardData(CardData cd) {
        }
    }
}

