/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.card;

import fxterm.app.FxEnv;
import fxterm.core.hdw.prt.CustomPrinterJob;
import fxterm.module.input.card.BaseCardInputModule;
import fxterm.session.Session;
import java.util.HashMap;
import javafx.application.Platform;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationStatementResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public class CardReportInputModule
extends BaseCardInputModule {
    @Override
    protected void _startOperation() {
        try {
            this.log.info((Object)"Start card operation");
            this.cm.statement((CardModuleResultListener)new StatementOperationListener());
            this.log.info((Object)"Done");
        }
        catch (Exception ex) {
            this.exit(ex);
        }
    }

    @Override
    protected void onClosed() {
        this.log.info((Object)"Card operation closed. Exit from module");
        this.exit();
    }

    private class StatementOperationListener
    implements CardModuleResultListener<OperationStatementResult> {
        private StatementOperationListener() {
        }

        public void onError(CardModuleError cme, String message) {
            Platform.runLater(() -> {
                CardReportInputModule.this.log.info((Object)("Card statement operation error: " + cme + ", " + message));
                CardReportInputModule.this.hideWait();
                CardReportInputModule.this.exit(cme, message);
            });
        }

        public void onResult(OperationStatementResult r, CardInfo ci) {
            Platform.runLater(() -> {
                CardReportInputModule.this.log.info((Object)("Card operation statement result: " + r));
                CardReportInputModule.this.log.info((Object)"Printing statement result");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("operations", r.getOperations());
                data.put("pan", "" + ci.getPan());
                data.put("auth", "" + r.getAuthIdentResponse());
                data.put("merchant", "" + r.getMerchant());
                data.put("terminal", "" + r.getTerminal());
                data.put("rrn", "" + r.getRrn());
                data.put("stan", "" + r.getStan());
                AccountInfo ai = ci.getAccountInfo();
                if (ai != null) {
                    data.put("account", ai.getNumber());
                }
                FxEnv.getPrintSpooler().print((PrinterJob)new CustomPrinterJob(data, Session.getLocale(), "card_report.tpl"));
                Dialog.show((String)"module/card/report/report_print", (DialogListener)new BaseCardInputModule.SessionClose(null));
            });
        }

        public void onCardData(CardData cd) {
        }
    }
}

