/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.card;

import fxterm.app.FxEnv;
import fxterm.core.hdw.prt.CustomPrinterJob;
import fxterm.module.input.card.BaseCardInputModule;
import fxterm.session.Session;
import java.util.HashMap;
import javafx.application.Platform;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.AmountType;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationBalanceResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public class CardBalanceInputModule
extends BaseCardInputModule {
    @Override
    protected void _startOperation() {
        try {
            this.log.info((Object)"Start card operation");
            this.cm.balance((CardModuleResultListener)new CardBalanceOperationListener());
            this.log.info((Object)"Done");
        }
        catch (Exception ex) {
            this.exit(ex);
        }
    }

    @Override
    protected void onClosed() {
        this.log.info((Object)"Card operation closed. Exit from module");
        this.exit();
    }

    private class CardBalanceOperationListener
    implements CardModuleResultListener<OperationBalanceResult> {
        private CardBalanceOperationListener() {
        }

        public void onError(CardModuleError cme, String message) {
            Platform.runLater(() -> {
                CardBalanceInputModule.this.log.info((Object)("Card balance operation error: " + cme + ", " + message));
                CardBalanceInputModule.this.hideWait();
                CardBalanceInputModule.this.exit(cme, message);
            });
        }

        public void onResult(OperationBalanceResult r, CardInfo ci) {
            CardBalanceInputModule.this.log.info((Object)("Card balance operation result: " + r));
            Sum balance = new Sum((int)r.getBalance(), r.getCurrency().getAlphaCode());
            int lim = 0;
            if (r.getAdditionalAmounts() != null) {
                for (Amount a : r.getAdditionalAmounts()) {
                    if (a.getAmountType() != AmountType.ExceedLimit) continue;
                    lim = (int)a.getValue();
                }
            }
            Sum overdraft = new Sum(lim, r.getCurrency().getAlphaCode());
            Sum total = new Sum(balance.getValue() + lim, r.getCurrency().getAlphaCode());
            Platform.runLater(() -> {
                CardBalanceInputModule.this.hideWait();
                if (Session.isPrinterError()) {
                    CardBalanceInputModule.this.log.info((Object)"Printer in error state");
                    this.showBalance(balance, overdraft, total);
                } else {
                    CardBalanceInputModule.this.log.info((Object)"Show question dialog");
                    Dialog.show((String)"module/card/balance/balance_type", act -> {
                        CardBalanceInputModule.this.log.info((Object)("Action on card balance type dialog: " + act));
                        if (act == 1) {
                            this.showBalance(balance, overdraft, total);
                        } else {
                            this.printBalance(balance, overdraft, total);
                        }
                    });
                }
            });
        }

        private void showBalance(Sum balance, Sum overdraft, Sum total) {
            CardBalanceInputModule.this.log.info((Object)"Show dialog with balance");
            Session.setItem("card_balance", balance);
            Session.setItem("card_overdraft", overdraft);
            Session.setItem("card_total", total);
            Dialog.show((String)"module/card/balance/balance", (DialogListener)new BaseCardInputModule.SessionClose(null));
        }

        private void printBalance(Sum balance, Sum overdraft, Sum total) {
            CardBalanceInputModule.this.log.info((Object)"Print balance");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.putAll(Session.getData());
            data.put("balance", balance);
            data.put("overdraft", overdraft);
            data.put("total", total);
            FxEnv.getPrintSpooler().print((PrinterJob)new CustomPrinterJob(data, Session.getLocale(), "card_balance.tpl"));
            Dialog.show((String)"module/card/balance/balance_print", (DialogListener)new BaseCardInputModule.SessionClose(null));
        }

        public void onCardData(CardData cd) {
        }
    }
}

