/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.card;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.prt.CustomPrinterJob;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.InitModuleHelper;
import fxterm.session.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenStore;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.wait.WaitControl;
import plfx.shell2.wait.WaitModule;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.AmountType;
import ru.softlogic.cards.v2.connector.model.OperationBalanceResult;
import ru.softlogic.cards.v2.model.BankModuleError;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.BankModule;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cards.v2.module.DialogListener;
import ru.softlogic.cards.v2.module.InputFormListener;
import ru.softlogic.cards.v2.module.SelectItemListener;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.cards.v2.module.UserInterfaceEventListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.system.util.PathUtils;

public abstract class BaseCardInputModule
extends BaseInputModule
implements UserInterfaceEventListener {
    private static final String SELECTOR_ITEMS = "items";
    private static final String SELECTOR_DATA = "data";
    protected Environment env;
    protected CardModule cm;
    protected BankModule bm;
    protected WaitModule waitModule = FxEnv.getCardModuleHandler().getWaitModule();
    protected WaitControl waitControl;
    protected InfoScreenDescription infoDesc = new InfoScreenDescription("card/info");
    protected InfoScreenDescription balanceDesc = new InfoScreenDescription("card/balance");
    protected InfoScreenDescription pinReqDesc;
    protected InfoScreenDescription cardReqDesc = new InfoScreenDescription("card/wait");
    protected InfoScreenDescription cardDepositDesc;

    public BaseCardInputModule() {
        this.pinReqDesc = new InfoScreenDescription("card/pin");
        this.cardDepositDesc = new InfoScreenDescription("card/deposit");
    }

    @Override
    protected void _start(Environment environment) {
        this.env = environment;
        this.log.info((Object)"* STEP 1. Creating card module session ");
        new CreateSession().process();
    }

    protected void _confirm() {
        this.log.info((Object)"* STEP 2. Show confirm ");
        try {
            this.infoDesc.setInfo("<img src=\"" + PathUtils.getUrlPath((String)"/res/module/input/card/res/cardreader.png") + "\"/>");
            this.showScreen((ScreenDescription)this.infoDesc, Collections.emptyMap(), new ConfirmListener());
        }
        catch (ScreenCreateException | InitException ex) {
            this.exit((Exception)ex);
        }
    }

    protected abstract void _startOperation();

    @Override
    public void exit(Exception ex) {
        this.log.info((Object)"Finish module with error: ", (Throwable)ex);
        Platform.runLater(() -> {
            if (this.cancelListener != null) {
                this.cancelListener.run();
                this.cancelListener = null;
            }
            Dialog.show((String)"module/input/error_exit", (plfx.shell2.dialog.DialogListener)new SessionClose(this::exit));
        });
    }

    public void exit(CardModuleError cme, String message) {
        Platform.runLater(() -> {
            if (cme == CardModuleError.ERROR_USER_CANCEL) {
                this.log.info((Object)"Operation canceled by user, show dialog");
                Dialog.show((String)"module/card/error_cancel_user", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
            } else {
                this.log.info((Object)("Show dialog with message = " + message));
                if (message != null && !message.trim().isEmpty()) {
                    Session.setItem("card_error_msg", CardModuleHandler.getMessage(message));
                } else {
                    Session.setItem("card_error_msg", null);
                }
                Dialog.show((String)"module/card/error", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
            }
        });
    }

    public void exit(BankModuleError cme, String message) {
        Platform.runLater(() -> {
            if (cme == BankModuleError.ERROR_USER_CANCEL) {
                this.log.info((Object)"Operation canceled by user, show dialog");
                Dialog.show((String)"module/card/error_cancel_user", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
            } else {
                this.log.info((Object)("Show dialog with message = " + message));
                if (message != null && !message.trim().isEmpty()) {
                    Session.setItem("card_error_msg", CardModuleHandler.getMessage(message));
                } else {
                    Session.setItem("card_error_msg", null);
                }
                Dialog.show((String)"module/card/error", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
            }
        });
    }

    @Override
    public void cancel(Intent intent) {
        block4: {
            try {
                if (this.cancelListener != null) {
                    this.cancelListener.run();
                    this.cancelListener = null;
                }
                if (FxEnv.getCardModuleHandler().getCurrentSession() != null) {
                    FxEnv.getCardModuleHandler().closeOperation();
                }
            }
            catch (Exception e) {
                if (FxEnv.getCardModuleHandler().getCurrentSession() == null) break block4;
                FxEnv.getCardModuleHandler().closeSession(true);
            }
        }
    }

    @Override
    protected void _restore() {
        this.cancel(null);
    }

    public void showWait(String id) {
        this.waitControl = this.waitModule.show(id);
    }

    public void hideWait() {
        if (this.waitControl != null) {
            this.log.info((Object)"Hide wait screen");
            this.waitControl.close();
            this.waitControl = null;
        }
    }

    public void onEvent(UserInterfaceEvent uie, Runnable callback) {
        this.log.info((Object)("Event: " + uie));
        Platform.runLater(() -> {
            this.cancelListener = callback;
            FxEnv.getCardModuleHandler().onAction();
            try {
                switch (uie) {
                    case CARD_REQUIRE: {
                        this.log.info((Object)"Show card require screen");
                        this.hideWait();
                        callback.run();
                        this.showScreen((ScreenDescription)this.cardReqDesc, Collections.emptyMap(), new WaitListener(this.cardReqDesc.getType()));
                        break;
                    }
                    case CARD_INSERT_TRY: {
                        this.log.info((Object)"Card insert try");
                        callback.run();
                        break;
                    }
                    case PIN_TRY_LEFT_1: {
                        this.log.info((Object)"Show warning dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/pin_try_left1", (plfx.shell2.dialog.DialogListener)new CancelDialogListener(callback));
                        break;
                    }
                    case PIN_TRY_LEFT_2: {
                        this.log.info((Object)"Show warning dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/pin_try_left2", (plfx.shell2.dialog.DialogListener)new CancelDialogListener(callback));
                        break;
                    }
                    case PIN_REQUIRE: {
                        this.log.info((Object)"Show pin require screen");
                        this.hideWait();
                        this.pinReqDesc.setInfo("");
                        callback.run();
                        this.showScreen((ScreenDescription)this.pinReqDesc, Collections.emptyMap(), new WaitListener(this.pinReqDesc.getType()));
                        break;
                    }
                    case ONLINE_REQUEST: {
                        this.log.info((Object)"Show wait screen");
                        callback.run();
                        this.showWait("network.request");
                        break;
                    }
                    case TAKE_CARD: {
                        this.log.info((Object)"Show take card dialog");
                        callback.run();
                        this.showWait("take.card");
                        break;
                    }
                    case CARD_CAPTURED_BY_HOST: {
                        this.log.info((Object)"Show error dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/captured_by_host", (plfx.shell2.dialog.DialogListener)new SessionClose(callback));
                        break;
                    }
                    case CARD_CAPTURED_BY_TIMEOUT: {
                        this.log.info((Object)"Show error dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/captured_by_timeout", (plfx.shell2.dialog.DialogListener)new SessionClose(callback));
                        break;
                    }
                    case CARD_CAPTURE_FAIL: {
                        this.log.info((Object)"Show error dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/capture_fail", (plfx.shell2.dialog.DialogListener)new SessionClose(callback));
                        break;
                    }
                    case CARD_RETURNED: {
                        this.hideWait();
                        callback.run();
                        break;
                    }
                    case SESSION_CLOSED: {
                        this.hideWait();
                        this.onClosed();
                        break;
                    }
                    case CARD_WRONG: {
                        this.log.info((Object)"Show error dialog");
                        this.hideWait();
                        Dialog.show((String)"module/card/wrong", (plfx.shell2.dialog.DialogListener)new CancelDialogListener(callback));
                    }
                }
            }
            catch (Exception ex) {
                this.exit(ex);
            }
        });
    }

    public void onPinEdit(String string) {
        Platform.runLater(() -> {
            try {
                this.log.info((Object)("Pin edit: " + string));
                this.pinReqDesc.setInfo(string);
                ScreenStore.getCommonScreen((String)this.pinReqDesc.getType()).init((ScreenDescription)this.pinReqDesc, InitModuleHelper.buildScreenInit(null, Collections.emptyMap()));
            }
            catch (ScreenCreateException | InitException ex) {
                this.exit((Exception)ex);
            }
        });
    }

    public void onSelectItem(String title, Map<String, Object> data, SelectItemListener sl) {
        Platform.runLater(() -> {
            this.hideWait();
            FxEnv.getCardModuleHandler().onAction();
            this.log.info((Object)("Show selector screen: title =  " + title + ", data" + data));
            this.cancelListener = () -> ((SelectItemListener)sl).onCancel();
            UniScreenDescription sd = new UniScreenDescription("selector");
            SelectorField sf = new SelectorField();
            sf.setTitleId(title);
            sf.setId(SELECTOR_ITEMS);
            ArrayList<SelectorItem> items = new ArrayList<SelectorItem>();
            for (String key : data.keySet()) {
                SelectorItem si = new SelectorItem(CardModuleHandler.getMessage(key), key);
                si.setCustomData(Collections.singletonMap(SELECTOR_DATA, data.get(key)));
                items.add(si);
            }
            sf.setStore((ItemsStore)new StaticStore(items));
            sd.setSequence(new FieldSequence(Arrays.asList(sf)));
            this.showScreenSafe((ScreenDescription)sd, Collections.emptyMap(), new SelectorListener(sl));
        });
    }

    public void onInputForm(String id, Map<String, String> initData, InputFormListener il) {
        Platform.runLater(() -> {
            this.cancelListener = () -> ((InputFormListener)il).onCancel();
            this.hideWait();
            FxEnv.getCardModuleHandler().onAction();
            this.log.info((Object)("Show form: id =  " + id));
            try {
                Form f;
                File fileForm = PathUtils.getFilePath((String)("/res/module/input/card/forms/" + id + "_" + Session.getLocale().getLanguage() + ".xml"));
                if (!fileForm.exists()) {
                    fileForm = PathUtils.getFilePath((String)("/res/module/input/card/forms/" + id + ".xml"));
                }
                if ((f = Parser.getForm((File)fileForm, (short)0, (File)PathUtils.getFilePath((String)"/res/module/input/ds/0/"))).getScreenSequence().getScreens().size() != 1) {
                    throw new ParseException("Wrong number of screens");
                }
                this.showScreenSafe((ScreenDescription)f.getScreenSequence().getScreens().get(0), Collections.emptyMap(), new FormListener(il));
            }
            catch (ParseException ex) {
                this.exit((Exception)((Object)new ScreenCreateException((Throwable)ex)));
            }
        });
    }

    public void onCashRequire(boolean b, AccountInfo ai, CashRequireListener cl) {
    }

    public void onBalance(OperationBalanceResult obr, CardInfo ci, Runnable r) {
        Platform.runLater(() -> {
            this.hideWait();
            FxEnv.getCardModuleHandler().onAction();
            this.log.info((Object)"Show deposit balance screen");
            this.showScreenSafe((ScreenDescription)this.balanceDesc, Collections.emptyMap(), new BalanceListener(r, obr));
        });
    }

    public void onDialog(String id, String string, Map<String, Object> map, DialogListener dl) {
        Platform.runLater(() -> {
            this.log.info((Object)("Show dialog: id = " + id + ", params = " + map));
            if (map != null) {
                map.forEach(Session::setItem);
            }
            this.hideWait();
            Dialog.show((String)("module/card/dialog/" + id.toLowerCase()), arg_0 -> ((DialogListener)dl).onResult(arg_0));
        });
    }

    protected abstract void onClosed();

    protected class SessionClose
    implements plfx.shell2.dialog.DialogListener {
        private Runnable callback;

        public SessionClose(Runnable callback) {
            this.callback = callback;
        }

        public void onAction(int actionId) {
            if (this.callback != null) {
                this.callback.run();
            }
            FxEnv.getCardModuleHandler().closeSession(true);
        }
    }

    protected class BalanceListener
    extends BaseScreenListener {
        private Runnable callback;
        private OperationBalanceResult obr;

        public BalanceListener(Runnable callback, OperationBalanceResult obr) {
            this.callback = callback;
            this.obr = obr;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BaseCardInputModule.this.log.info((Object)("Action on balance screen: " + action));
            if (ActionType.isNext((String)action)) {
                this.callback.run();
            } else if ("balance".equals(action)) {
                this.showQuestion();
                cancelListener.run();
            } else {
                BaseCardInputModule.this.cancel(null);
            }
        }

        private void showQuestion() {
            BaseCardInputModule.this.log.info((Object)("Card balance operation result: " + this.obr));
            Sum balance = new Sum((int)this.obr.getBalance(), Session.getInCurrency());
            int lim = 0;
            if (this.obr.getAdditionalAmounts() != null) {
                for (Amount a : this.obr.getAdditionalAmounts()) {
                    if (a.getAmountType() != AmountType.ExceedLimit) continue;
                    lim = (int)a.getValue();
                }
            }
            Sum overdraft = new Sum(lim, Session.getInCurrency());
            Sum total = new Sum(balance.getValue() + lim, Session.getInCurrency());
            Platform.runLater(() -> {
                if (Session.isPrinterError()) {
                    BaseCardInputModule.this.log.info((Object)"Printer in error state");
                    this.showBalance(balance, overdraft, total);
                } else {
                    BaseCardInputModule.this.log.info((Object)"Show question dialog");
                    Dialog.show((String)"module/card/balance/balance_type", act -> {
                        BaseCardInputModule.this.log.info((Object)("Action on card balance type dialog: " + act));
                        if (act == 1) {
                            this.showBalance(balance, overdraft, total);
                        } else {
                            this.printBalance(balance, overdraft, total);
                        }
                    });
                }
            });
        }

        private void showBalance(Sum balance, Sum overdraft, Sum total) {
            BaseCardInputModule.this.log.info((Object)"Show dialog with balance");
            Session.setItem("card_balance", balance);
            Session.setItem("card_overdraft", overdraft);
            Session.setItem("card_total", total);
            Dialog.show((String)"module/card/balance/balance", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
        }

        private void printBalance(Sum balance, Sum overdraft, Sum total) {
            BaseCardInputModule.this.log.info((Object)"Print balance");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.putAll(Session.getData());
            data.put("balance", balance);
            data.put("overdraft", overdraft);
            data.put("total", total);
            FxEnv.getPrintSpooler().print((PrinterJob)new CustomPrinterJob(data, Session.getLocale(), "card_balance.tpl"));
            Dialog.show((String)"module/card/balance/balance_print", (plfx.shell2.dialog.DialogListener)new SessionClose(null));
        }
    }

    protected class FormListener
    extends BaseScreenListener {
        private final InputFormListener ifl;

        public FormListener(InputFormListener ifl) {
            this.ifl = ifl;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cl) {
            BaseCardInputModule.this.log.info((Object)("Action on form screen: " + action + ", data = " + data));
            if (ActionType.isNext((String)action)) {
                try {
                    this.ifl.onData(StoreHelper.convertDep(data));
                    BaseCardInputModule.this.cancelListener = null;
                }
                catch (Exception e) {
                    BaseCardInputModule.this.exit(e);
                }
            } else {
                this.ifl.onCancel();
                BaseCardInputModule.this.cancelListener = null;
            }
        }
    }

    protected class SelectorListener
    extends BaseScreenListener {
        private final SelectItemListener sl;

        public SelectorListener(SelectItemListener sl) {
            this.sl = sl;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cl) {
            BaseCardInputModule.this.log.info((Object)("Action on selector screen: " + action));
            if (ActionType.isNext((String)action)) {
                try {
                    this.sl.onSelect(data.get(BaseCardInputModule.SELECTOR_DATA));
                    BaseCardInputModule.this.cancelListener = null;
                }
                catch (Exception e) {
                    BaseCardInputModule.this.exit(e);
                }
            } else {
                this.sl.onCancel();
                BaseCardInputModule.this.cancelListener = null;
            }
        }
    }

    protected class WaitListener
    extends BaseScreenListener {
        private String type;

        public WaitListener(String type) {
            this.type = type;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BaseCardInputModule.this.log.info((Object)("Action on " + this.type + " screen: " + action));
            if (!ActionType.isNext((String)action)) {
                BaseCardInputModule.this.cancel(null);
            } else {
                cancelListener.run();
            }
        }
    }

    protected class ConfirmListener
    extends BaseScreenListener {
        protected ConfirmListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BaseCardInputModule.this.log.info((Object)("Action on confirm screen: " + action));
            BaseCardInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                BaseCardInputModule.this._startOperation();
            } else {
                BaseCardInputModule.this.cancel(null);
                BaseCardInputModule.this.exit();
            }
        }
    }

    protected class CreateSession
    extends Task {
        protected CreateSession() {
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        protected Object execute() throws Exception {
            if (!FxEnv.getCardModuleHandler().isReady()) {
                throw new IllegalStateException("Card module is not ready");
            }
            BaseCardInputModule.this.cm = Objects.requireNonNull(FxEnv.getCardModuleHandler().openSession(BaseCardInputModule.this), "Opening session failed. Card module is not ready");
            BaseCardInputModule.this.bm = Objects.requireNonNull(BaseCardInputModule.this.cm.getBankModule(), "Opening session failed. Bank Module is not present");
            return null;
        }

        protected void onResult(Object object) {
            Platform.runLater(() -> BaseCardInputModule.this._confirm());
        }

        @Override
        protected void onError(Exception ex) {
            BaseCardInputModule.this.exit(ex);
        }
    }
}

