/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv.hdw;

import fxterm.app.FxEnv;
import fxterm.module.input.adv.AdvancedInputModule;
import fxterm.module.input.adv.hdw.CardReaderHandlerImpl;
import fxterm.module.input.adv.hdw.CvdHandlerImpl;
import fxterm.module.input.adv.hdw.PrinterAdapter;
import fxterm.module.input.adv.hdw.SmartCardHandlerImpl;
import fxterm.module.input.adv.hdw.WebcamHandlerImpl;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.cvd.CardDispenser;
import ru.softlogic.hdw.dev.webcam.Webcam;
import ru.softlogic.hdw.dev.webcam.WebcamListener;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.Printer;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserHandler;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderHandler;
import ru.softlogic.input.model.advanced.actions.hdw.SmartCardHandler;
import ru.softlogic.input.model.advanced.actions.hdw.WebcamHandler;

public class HardwareApi
implements AdvancedHardwareApi {
    private final Printer printer = new PrinterAdapter(FxEnv.getPrintSpooler());
    private SmartCardHandler smartCardHandler;
    private CardReaderHandler cardReaderHandler;
    private CardDispenserHandler cardDispandler;
    private WebcamHandler webcamHandler;

    public HardwareApi(AdvancedInputModule aim) {
        Webcam webcam;
        CardDispenser cDispenser;
        CardReader cReader = FxEnv.getCardReader();
        if (cReader != null) {
            this.smartCardHandler = new SmartCardHandlerImpl(cReader);
            this.cardReaderHandler = new CardReaderHandlerImpl(cReader, aim);
        }
        if ((cDispenser = FxEnv.getCardDispenser()) != null) {
            this.cardDispandler = new CvdHandlerImpl(cDispenser);
        }
        if ((webcam = FxEnv.getWebcam()) != null) {
            webcam.setWebcamListener((WebcamListener)aim);
            this.webcamHandler = new WebcamHandlerImpl(webcam, aim);
        }
    }

    public SmartCardHandler getSmartCardHandler() {
        return this.smartCardHandler;
    }

    public CardReaderHandler getCardReaderHandler() {
        return this.cardReaderHandler;
    }

    public CardDispenserHandler getCardDispenserHandler() {
        return this.cardDispandler;
    }

    public WebcamHandler getWebcamHandler() {
        return this.webcamHandler;
    }

    public Printer getPrinter() {
        return this.printer;
    }
}

