/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv.hdw;

import fxterm.app.id.LoggerId;
import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.cvd.BarcodeOperation;
import ru.softlogic.hdw.dev.cvd.BaseDispenseOperation;
import ru.softlogic.hdw.dev.cvd.CardDispenser;
import ru.softlogic.hdw.dev.cvd.DispenseException;
import ru.softlogic.hdw.dev.cvd.DispenseOperation;
import ru.softlogic.hdw.dev.cvd.OnlyDispenseOperation;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserHandler;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;

class CvdHandlerImpl
implements CardDispenserHandler {
    private final CardDispenser dispenser;
    private final Logger log = LoggerId.PAY;

    public CvdHandlerImpl(CardDispenser cardDispenser) {
        this.dispenser = Objects.requireNonNull(cardDispenser, "CardDispenserHandler is not set");
    }

    public void dispense() throws HardwareException {
        this.log.info((Object)"Try to dispense card");
        OnlyDispenseOperation bdo = new OnlyDispenseOperation();
        this.dispense((BaseDispenseOperation)bdo);
    }

    public String dispenseBarcode(String regex) throws HardwareException {
        this.log.info((Object)("Try to read barcode & dispense card. Validation regex: " + regex));
        BarcodeOperation bdo = new BarcodeOperation(regex);
        this.dispense((BaseDispenseOperation)bdo);
        this.log.info((Object)("Barcode: " + bdo.getBarcode()));
        return bdo.getBarcode();
    }

    private void dispense(BaseDispenseOperation bdo) throws HardwareException {
        try {
            this.log.info((Object)"Try to add operation");
            this.dispenser.dispense((DispenseOperation)bdo);
            this.log.info((Object)"Wait for issue card");
            DispenseOperation.State state = bdo.waitForIssue();
            this.log.info((Object)("Result: " + state));
            if (state != DispenseOperation.State.CardIssued) {
                throw new HardwareException("Dispense operation finished with error");
            }
            this.log.info((Object)"Success");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new HardwareException((Throwable)ex);
        }
        catch (DispenseException ex) {
            this.log.error((Object)"Erron on dispense", (Throwable)ex);
            throw new HardwareException((Throwable)ex);
        }
    }
}

