/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv.attribute;

import fxterm.module.input.adv.attribute.B;
import fxterm.session.Session;
import fxterm.session.TemplateProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.References;

public final class EnvAttributeProcessor {
    private static final String POINT = "point";
    private static final String SERVICE = "service";
    private static final String DEALER = "dealer";
    private static Map<String, String> aliasMap;
    private static Map<String, Object> data;

    public static InputElement getValue(String code) {
        if (code != null) {
            String alias = EnvAttributeProcessor.getAliasMap().getOrDefault(code, code);
            return EnvAttributeProcessor.getValue(code, alias, EnvAttributeProcessor.buildDataMap());
        }
        return null;
    }

    private static InputElement getValue(String code, String alias, Map<String, Object> data) {
        String value;
        String velocityCode;
        String title = B.get(alias, code);
        if (title != null && !(velocityCode = "$" + alias).equals(value = TemplateProcessor.processText(velocityCode, data, null))) {
            return new InputElement(code, title, value);
        }
        return null;
    }

    private static Map<String, Object> buildDataMap() {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put(SERVICE, Session.getService());
        data.put(POINT, References.getPoint());
        data.put(DEALER, References.getDealer());
        return data;
    }

    private static Map<String, String> getAliasMap() {
        if (aliasMap == null) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            try {
                Properties prop = new Properties();
                prop.load(EnvAttributeProcessor.class.getResourceAsStream("alias.properties"));
                prop.entrySet().stream().forEach(entry -> tmpMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            aliasMap = tmpMap;
        }
        return aliasMap;
    }
}

