/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;

class Helper {
    Helper() {
    }

    public static ScreenDescription processButtons(ScreenDescription sd, ActionMap map, ActionMap navigation) {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        for (Action a : map.getActions()) {
            buttons.put(a.getType(), new ButtonInit(a.getTitle()));
        }
        sd.setButtons(buttons);
        LinkedHashMap<String, ButtonInit> navibuttons = new LinkedHashMap<String, ButtonInit>();
        if (navigation != null) {
            for (Action a : navigation.getActions()) {
                navibuttons.put(a.getType(), new ButtonInit(a.getTitle(), a.isCurent()));
            }
        }
        sd.setNavigations(navibuttons);
        return sd;
    }

    public static ScreenDescription processScreenTitle(ScreenDescription sd, Map<String, Object> data) {
        ScreenDescription res = sd;
        String name = sd.getTitleAttr();
        if (name != null && !name.trim().isEmpty()) {
            Object obj = data.get(name);
            String title = null;
            if (obj != null && obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                if (ie.getValueTitle() != null) {
                    title = ie.getValueTitle();
                } else if (ie.getValue() != null) {
                    title = ie.getValue();
                } else if (ie.getOriginalValue() != null) {
                    title = ie.getOriginalValue();
                }
            }
            if (title != null && !title.trim().isEmpty()) {
                res = new ScreenDescription(sd.getType());
                res.setBarcodeScanner(sd.getBarcodeScanner());
                res.setButtons(sd.getButtons());
                res.setDecor(sd.getDecor());
                res.setEventRules(sd.getEventRules());
                res.setExtraButton(sd.getExtraButton());
                res.setIcon(sd.getIcon());
                res.setId(sd.getId());
                res.setNavigations(sd.getNavigations());
                res.setSequence(sd.getSequence());
                res.setSound(sd.getSound());
                res.setStyleClass(sd.getStyleClass());
                res.setSubtitle(sd.getSubtitle());
                res.setTitle(title);
                res.setTitleAttr(sd.getTitleAttr());
                res.setTitleId(sd.getTitleId());
            }
        }
        return res;
    }
}

