/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv;

import fxterm.app.FxEnv;
import fxterm.app.FxEnvInit;
import fxterm.core.cache.CacheManager;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.Pack;
import fxterm.module.Payment;
import fxterm.module.input.BaseInputModule;
import fxterm.module.input.ComplexScreenListener;
import fxterm.module.input.DataRender;
import fxterm.module.input.ExitModuleListener;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.InputModule;
import fxterm.module.input.adv.AdvCommissionCalculatorImpl;
import fxterm.module.input.adv.ConnectorAdapter;
import fxterm.module.input.adv.Helper;
import fxterm.module.input.adv.TaskAdapter;
import fxterm.module.input.adv.attribute.EnvAttributeProcessor;
import fxterm.module.input.adv.hdw.CvdPropertyLoader;
import fxterm.module.input.adv.hdw.HardwareApi;
import fxterm.module.input.adv.hdw.PropertyLoader;
import fxterm.module.input.adv.hdw.StdPropertyLoader;
import fxterm.module.input.\u0421acheableAdapter;
import fxterm.module.stage.payment.BackIntent;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenStore;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.popup.dialog.DialogButton;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.util.Locator;
import plfx.util.TimeMeter;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.cvd.CardDispenser;
import ru.softlogic.hdw.dev.webcam.Webcam;
import ru.softlogic.hdwbridge.sc.SmartCardProcessor;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.MethodType;
import ru.softlogic.input.model.advanced.OpenUrlTarget;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleRequestListener;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperation;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.request.CardRequestListener;
import ru.softlogic.input.model.advanced.actions.request.ServerConnector;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.io.utils.BU;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.Store;
import ru.softlogic.parser.adv.ScenarioStore;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.system.util.PathUtils;

public class AdvancedInputModule
extends BaseInputModule {
    private MenuItem menuItem;
    private Scenario scenario;
    private Map<String, Object> data;
    private final TerminalEnvironment te;
    private String currentId;
    private ActionMap currentMap;
    private ActionMap currentNavigationMap;
    private Environment environment;
    private final ComplexScreenListener screenListener = new LocalScreenListener(this);
    private final ScenarioStore scenarioStore;
    private SumScreenDescription sumDescription;

    public AdvancedInputModule() {
        this.te = new TerminalEnvironment();
        this.scenarioStore = new ScenarioStore(PathUtils.getFilePath((String)"/res/module/input/advanced/"), PathUtils.getFilePath((String)"/res/module/input/encode/"));
        CacheManager.add(new \u0421acheableAdapter((Store)this.scenarioStore));
    }

    @Override
    protected void _start(Environment environment) {
        this.environment = environment;
        this.menuItem = Session.getSelectedItem();
        this.screenListener.setEnvironment(environment);
        this.data = new HashMap<String, Object>();
        TimeMeter tm = new TimeMeter();
        try {
            long interval;
            this.log.info((Object)"Load scenario");
            HashMap<String, Object> initData = new HashMap<String, Object>();
            initData.putAll(Session.getPointAttributes());
            this.scenario = this.scenarioStore.getScenario((int)this.menuItem.getService().getCode(), Session.getLocale());
            LinkedList<PropertyLoader> loaders = new LinkedList<PropertyLoader>();
            if (!this.checkFeatures(this.scenario, loaders)) {
                this.log.info((Object)"Scenario features not supported");
                Dialog.show((String)"module/input/hdw_error", (DialogListener)new ExitModuleListener(this));
                return;
            }
            FxEnv.getThreadPool().submit(() -> this.scenario.loadSlave());
            this.log.info((Object)"Success, enrich data store");
            ModuleHelper.prefillStore(this.scenario.getPrefillItem(), this.data);
            for (PropertyLoader pl : loaders) {
                pl.load(this.data);
            }
            if (!this.data.isEmpty()) {
                DataRender.dataToStr(this.data);
            }
            this.log.info((Object)"Done");
            String cardHandler = this.scenario.getCardHandler();
            if (cardHandler != null) {
                String path = "ru.softlogic.smartcard." + cardHandler.toLowerCase() + ".CardProcessor";
                SmartCardProcessor scProcessor = (SmartCardProcessor)Class.forName(path).newInstance();
                FxEnvInit.setSmartCardProcessor(scProcessor);
            }
            if ((interval = tm.getIntervalMs()) > 100L) {
                GuiNotifier.notifyProblem((String)("Parsing form is too slow. Timeout=" + interval + " ms, service=" + this.menuItem.getService().getName() + "," + this.menuItem.getService().getId()));
            } else if (interval > 5L) {
                this.log.debug((Object)("Parsing timeout: " + interval + " ms"));
            }
            AdvancedScreenDescription sumDesc = (AdvancedScreenDescription)this.scenario.getScreens().get("sum-screen");
            if (sumDesc != null) {
                this.sumDescription = (SumScreenDescription)sumDesc.getDescription();
            } else {
                this.sumDescription = new SumScreenDescription();
                this.sumDescription.setType("sum");
            }
            boolean isProcess = false;
            Map<String, Object> envInitData = environment.getInitData();
            if (envInitData != null && !envInitData.isEmpty()) {
                Object anvCard = envInitData.get("card");
                if (anvCard instanceof String) {
                    String card = (String)anvCard;
                    this.data.put("card", new InputElement("card", "\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b", card));
                }
                ModuleHelper.fillStore(envInitData, this.data);
                isProcess = true;
            }
            String beginProcess = this.scenario.getBeginProcess();
            String beginTemplate = this.scenario.getBeginTemplate();
            String beginTemplateEdit = this.scenario.getBeginTemplateEdit();
            boolean usingPT = Session.getPaymentTemplateState().isUsingPT();
            boolean skipInput = Session.getPaymentTemplateState().isSkipInput();
            if (skipInput && beginTemplate != null && !beginTemplate.isEmpty()) {
                this.showScreen(beginTemplate);
            } else if (usingPT && !skipInput && beginTemplateEdit != null && !beginTemplateEdit.isEmpty()) {
                this.showScreen(beginTemplateEdit);
            } else if (isProcess && beginProcess != null && !beginProcess.isEmpty()) {
                this.showScreen(beginProcess);
            } else {
                this.showScreen(this.scenario.getBegin());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InitException ex) {
            this.exit((Exception)ex);
        }
        catch (ParseException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.exit((Exception)((Object)ex));
        }
    }

    @Override
    protected void _onCardState(int cardState) {
        String cardStateValue;
        switch (cardState) {
            case 0: {
                cardStateValue = "NO_CARD";
                break;
            }
            case 1: {
                cardStateValue = "IN_GATE";
                break;
            }
            case 2: {
                cardStateValue = "INSIDE";
                break;
            }
            case 3: {
                cardStateValue = "CAPTURE";
                break;
            }
            case 5: {
                cardStateValue = "RETURNED";
                break;
            }
            case 4: {
                cardStateValue = "RETURNING";
                break;
            }
            default: {
                cardStateValue = "N/D";
            }
        }
        String title = "#card_state";
        this.data.put(title, new InputElement(title, CRMsg.getCardState((int)cardState), cardStateValue));
    }

    @Override
    protected void _restore() {
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
        try {
            this.showScreen(this.currentId);
        }
        catch (InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            this.showError((Exception)((Object)ex));
        }
    }

    private void showScreen(String screenId) throws InitException {
        Pack pack = this.environment.getPack();
        this.log.info((Object)("Go to screen: " + screenId));
        if (ActionType.isExit((String)screenId)) {
            this.cancel(null);
        } else if (ActionType.isPrevious((String)screenId)) {
            this.cancel(new BackIntent(this.environment.getModules().getLoadPaymentTemplateModule()));
        } else if (ActionType.isPay((String)screenId)) {
            PaymentParams pp;
            String value;
            InputElement number;
            Sum operationSum = this.getOperationSum(this.data);
            pack.setMinSum(this.getSum(this.data, "#sum-min"));
            pack.setMaxSum(this.getSum(this.data, "#sum-max"));
            pack.setMinSumWithNoteLimit(this.getSum(this.data, "#sum-min-limit"));
            pack.setMaxDepositSum(this.getSum(this.data, "#sum-deposit-max"));
            pack.setDonateSum(this.getSum(this.data, "#sum-donate"));
            pack.setProviderFee(this.getFeeSum(this.data, "#fee-sum"));
            if (this.scenario.getChangeNumber() != null && (number = (InputElement)this.data.get(this.scenario.getChangeNumber())) != null && (value = number.getValue()) != null && !value.isEmpty()) {
                pack.setChangeNumber(number);
            }
            if ((pp = this.scenario.getPaymentParams()) == null || pp.getKey() == null || pp.getKey().trim().isEmpty()) {
                this.log.info((Object)"Start payment: TODO");
                pack.setAllowReturn(pp == null ? false : pp.isAllowReturn());
                pack.setPrintByOne(pp == null ? false : pp.isSingleCheck());
                this._startPayment(this.environment, (ScreenDescription)this.sumDescription, this.data, operationSum);
            } else {
                Object cart = this.data.get(this.scenario.getPaymentParams().getKey());
                if (cart == null) {
                    throw new InitException("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441 \u0438\u043c\u0435\u043d\u0435\u043c " + this.scenario.getPaymentParams().getKey() + "\u043d\u0430 \u0437\u0430\u0434\u0430\u043d\u0430");
                }
                pack.setSumDistributionType(this.scenario.getPaymentParams().getDistributionType());
                this.startPayment(this.environment, this.sumDescription, this.data, operationSum, null, null, cart);
            }
        } else {
            this.currentId = screenId;
            AdvancedScreenDescription screen = this.scenario.getScreenById(screenId);
            this.log.debug((Object)("Needs to show screen description: " + screen));
            if (screen == null) {
                this.onUnknownAction(screenId, this.data, this.cancelListener);
            } else if (screen.getDescription() != null) {
                this.barcodeScanner = screen.getDescription().getBarcodeScanner();
                this.currentMap = screen.getActionMap();
                this.currentNavigationMap = screen.getNavigationMap();
                ScreenDescription description = screen.getDescription();
                if (this.barcodeScanner != null && this.initBarcodeString != null) {
                    this.processInitBarcodeString(this.initBarcodeString, this.data);
                    this.initBarcodeString = null;
                    if (ActionType.isNext((String)this.barcodeScanner.getOnSuccess()) && "info".equals(description.getType())) {
                        this.showNextScreen();
                        return;
                    }
                }
                if ("void".equals(description.getType())) {
                    LocalVoidScreenCancelListener voidCancelListener = new LocalVoidScreenCancelListener(this.cancelListener, this.currentMap);
                    this.screenListener.onAction("next", this.data, voidCancelListener);
                } else {
                    this.showScreenSafe(Helper.processButtons(Helper.processScreenTitle(description, this.data), this.currentMap, this.currentNavigationMap), this.data, this.screenListener);
                }
            }
        }
    }

    protected void startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data, Sum operationSum, Service srv, Commission comm, Object pCart) throws InitException {
        if (pCart instanceof List) {
            List cart = (List)pCart;
            LinkedList<Payment> payments = new LinkedList<Payment>();
            Service s = srv == null ? Session.getService() : srv;
            Commission personal = this.getPersonalCommission(data);
            if (personal != null) {
                this.log.info((Object)("Set personal commission: " + personal));
                GuiNotifier.notifyProblem((String)("Set personal commission: id=" + personal.getId() + ", name=" + personal.getName() + "->" + StoreHelper.getMainValue(data)));
                Session.setCommission(personal);
            } else {
                Session.setCommission(Session.getActiveItem().getCommission());
            }
            Session.calculatePurchaseRange();
            Pack pack = environment.getPack();
            pack.setCommission(Session.getCommission());
            pack.setPrintByOne(this.scenario.getPaymentParams().isSingleCheck());
            pack.setAllowReturn(this.scenario.getPaymentParams().isAllowReturn());
            pack.setService(Session.getService());
            for (Data dt : cart) {
                InputElement ie;
                Map elems = StoreHelper.convert((List)dt.getElements());
                if (!"1".equals(StoreHelper.getElement2((String)"selected", (Map)elems).getValue()) || (ie = StoreHelper.getElement2((String)"summ", (Map)elems)).getValue().isEmpty()) continue;
                try {
                    Sum sum = this.createSum(Double.parseDouble(ie.getValue().replace(',', '.')));
                    if (sum.isEmpty()) continue;
                    Payment p = new Payment();
                    p.setOperationSum(sum);
                    HashMap<String, Object> data1 = new HashMap<String, Object>();
                    if (this.scenario.getPaymentParams() != null && this.scenario.getPaymentParams().isFirstParamsContext()) {
                        data1.putAll(data);
                        data1.putAll(elems);
                    } else {
                        data1.putAll(elems);
                        data1.putAll(data);
                    }
                    p.setData(StoreHelper.clearMulti(data1));
                    payments.add(p);
                }
                catch (NumberFormatException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    throw new InitException("Incorrect value of the sum");
                }
            }
            if (payments.isEmpty()) {
                throw new InitException("Services are not selected");
            }
            pack.setPayments(payments);
            pack.setOperationSum(operationSum);
            String img = Session.getService().getImage();
            if (img != null && !img.isEmpty()) {
                ssd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + img)));
            } else {
                ssd.setIcon(null);
            }
            ssd.setStyleClass(Session.getService().getStyle());
            try {
                CommonSumScreen css = ScreenStore.getCommonSumScreen((String)ssd.getType());
                css.init((ScreenDescription)ssd, InitModuleHelper.buildScreenInit(environment, data, Session.getService(), Session.getCommission()));
                this.log.info((Object)"Start save pament template");
                environment.getModules().getSavePamentTemplateModule().start(environment, css, this);
            }
            catch (ScreenCreateException | InitException ex) {
                this.exit((Exception)ex);
            }
        } else {
            throw new InitException("" + pCart + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f nested data");
        }
    }

    @Override
    protected void onSkipVerify() {
    }

    @Override
    protected void onVerifyResult(Map<String, Object> result) {
    }

    @Override
    protected void mergeData(Map<String, Object> newData) {
        this.data = ContextHelper.mergeData(this.data, newData);
    }

    @Override
    protected void showNextScreen() {
        this.screenListener.onAction("next", new HashMap<String, Object>(), () -> this.unlockBarcodeScannerListener());
    }

    @Override
    protected void showCurrentScreen() {
        try {
            this.showScreen(this.currentId);
        }
        catch (InitException ex) {
            this.showError((Exception)((Object)ex));
        }
    }

    private void showError(Exception ex) {
        this.log.error((Object)ex, (Throwable)ex);
        this.log.info((Object)("Show error: " + ex.getMessage()));
        Dialog.show((String)"module/input/error_exit", (DialogListener)new ExitModuleListener(this));
    }

    private void showData() {
        this.log.debug((Object)("Data: " + this.data));
    }

    private void showLocalData(Map<String, Object> localData) {
        this.log.debug((Object)("Local data: " + localData));
    }

    private boolean checkFeatures(Scenario scenario, List<PropertyLoader> loaders) {
        int f = scenario.getFeatures();
        int c = scenario.getCheckFeatures();
        if (f != 0) {
            this.log.info((Object)("Check scenario features, mask=" + BU.toHex((int)f) + ", check=" + BU.toHex((int)c)));
            CardDispenser cardDispenser = FxEnv.getCardDispenser();
            if (this.checkFeature(f, c, 2)) {
                if (cardDispenser == null || !cardDispenser.isOperable()) {
                    this.log.info((Object)"Card dispenser is defective or missing");
                    return false;
                }
                loaders.add(new CvdPropertyLoader(cardDispenser));
            }
            CardReader cardReader = FxEnv.getCardReader();
            if (this.checkFeature(f, c, 1)) {
                if (cardReader == null || !cardReader.isOperable()) {
                    this.log.info((Object)"Card reader is defective or missing");
                    return false;
                }
                loaders.add(new StdPropertyLoader((Device)cardReader));
            }
            Webcam webcam = FxEnv.getWebcam();
            if (this.checkFeature(f, c, 8)) {
                if (webcam == null || !webcam.isOperable()) {
                    this.log.info((Object)("Webcam is defective or missing " + webcam));
                } else {
                    loaders.add(new StdPropertyLoader((Device)webcam));
                }
            }
            if (!(!this.checkFeature(f, c, 4) || cardReader != null && cardReader.isOperable() && cardReader.getDescription().isFeatureSupport(4))) {
                this.log.info((Object)"Smart-card reader is defective or missing");
                return false;
            }
        }
        return true;
    }

    private boolean checkFeature(int f, int c, int feat) {
        return (f & feat) != 0 && (c & feat) != 0;
    }

    private class DialogAdapter
    implements DialogListener {
        private final Map<Integer, String> actionMap;
        private final DialogAction dialogAction;

        public DialogAdapter(Map<Integer, String> actionMap, DialogAction dialogAction) {
            this.actionMap = actionMap;
            this.dialogAction = dialogAction;
        }

        public void onAction(int actionId) {
            AdvancedInputModule.this.log.info((Object)("User case: " + actionId));
            String action = this.actionMap.get(actionId);
            AdvancedInputModule.this.log.info((Object)("Mapped action: " + action));
            this.dialogAction.onSelectAction(action);
        }
    }

    private class LocalVoidScreenCancelListener
    implements Runnable {
        private final Runnable prevCancel;
        private final ActionMap prevMap;

        public LocalVoidScreenCancelListener(Runnable prevCancel, ActionMap prevMap) {
            this.prevCancel = prevCancel;
            this.prevMap = prevMap;
        }

        @Override
        public void run() {
            AdvancedInputModule.this.currentMap = this.prevMap;
            AdvancedInputModule.this.unlockBarcodeScannerListener();
            if (this.prevCancel != null) {
                this.prevCancel.run();
            }
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(InputModule inputModule) {
            super(inputModule);
        }

        @Override
        public void _onAction(String action, Map<String, Object> localData, Runnable cancelListener) {
            Action act;
            AdvancedInputModule.this.log.info((Object)("Action: " + action));
            AdvancedInputModule.this.cancelListener = cancelListener;
            AdvancedInputModule.this.showLocalData(localData);
            Map mergeData = AdvancedInputModule.this.data;
            if (!ActionType.isPrev((String)action) && !ActionType.isExit((String)action)) {
                mergeData = ContextHelper.mergeData((Map)AdvancedInputModule.this.data, localData);
            }
            if ((act = AdvancedInputModule.this.currentMap.getActionByType(action)) == null && AdvancedInputModule.this.currentNavigationMap != null) {
                act = AdvancedInputModule.this.currentNavigationMap.getActionByType(action);
            }
            if (act != null) {
                ActionContext context = new ActionContext((ru.softlogic.input.model.advanced.Environment)AdvancedInputModule.this.te, cancelListener, act.getSequence(), mergeData, AdvancedInputModule.this.menuItem.getService().getId());
                context.execute();
            } else {
                AdvancedInputModule.this.onUnknownAction(action, mergeData, cancelListener);
            }
        }
    }

    private class TerminalEnvironment
    implements ru.softlogic.input.model.advanced.Environment {
        private static final long serialVersionUID = 1L;
        private final HardwareApi hardwareApi;

        public TerminalEnvironment() {
            this.hardwareApi = new HardwareApi(AdvancedInputModule.this);
        }

        public void showDialog(DialogAction dialog) {
            AdvancedInputModule.this.log.info((Object)("Needs to show dialog: type=" + dialog.getType() + ", timeout=" + dialog.getTimeout() + ", defaultAction=" + dialog.getDefaultAction()));
            HashMap<Integer, String> am = new HashMap<Integer, String>();
            int defaultAction = 0;
            LinkedList<DialogButton> buttons = new LinkedList<DialogButton>();
            if (dialog.getActionMap() != null && dialog.getActionMap().getActions() != null) {
                int i = 0;
                for (Action action : dialog.getActionMap().getActions()) {
                    am.put(i, action.getType());
                    buttons.add(new DialogButton(action.getTitle(), "", null, i));
                    if (dialog.getDefaultAction().equals(action.getType())) {
                        defaultAction = i;
                    }
                    ++i;
                }
            }
            DialogDescriptor dd = new DialogDescriptor(dialog.getTitle(), "nn", dialog.getMessage(), "default_" + buttons.size() + "x", "", dialog.getTimeout(), buttons.toArray(new DialogButton[buttons.size()]), defaultAction, null);
            Dialog.show((DialogDescriptor)dd, (DialogListener)new DialogAdapter(am, dialog));
        }

        public void showScreen(String nextScreen, Map<String, Object> localData) {
            AdvancedInputModule.this.log.info((Object)("Needs to show screen: " + nextScreen));
            AdvancedInputModule.this.data.putAll(localData);
            LinkedHashMap result = new LinkedHashMap();
            for (String key : AdvancedInputModule.this.data.keySet()) {
                if (AdvancedInputModule.this.data.get(key) == null) continue;
                result.put(key, AdvancedInputModule.this.data.get(key));
            }
            AdvancedInputModule.this.data = result;
            AdvancedInputModule.this.showData();
            try {
                AdvancedInputModule.this.showScreen(nextScreen);
            }
            catch (InitException ex) {
                this.showError((Exception)((Object)ex));
            }
        }

        public void showError(Exception ex) {
            AdvancedInputModule.this.log.info((Object)("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430: " + ex.getMessage()));
            GuiNotifier.notifyError((String)("Advanced: " + ex.getMessage()), (int)900);
            AdvancedInputModule.this.showError(ex);
        }

        public void execute(AsyncTask task) {
            AdvancedInputModule.this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438: " + task));
            new TaskAdapter(task).process();
        }

        public ServerConnector getConnector() {
            return new ConnectorAdapter(FxEnv.getConnector());
        }

        public void openService(short serviceId, Map<String, Object> params) {
            AdvancedInputModule.this._redirect(serviceId, params);
        }

        public String getOffer(String fileName) {
            AdvancedInputModule.this.log.info((Object)("Try to load offer: " + fileName));
            return "";
        }

        public Map<String, String> getPointParams() {
            AdvancedInputModule.this.log.info((Object)"Try to get poin params");
            return new HashMap<String, String>();
        }

        public Short getOperator(String number) {
            short operator = IdentifyService.getOperator((String)number);
            return operator == -1 ? null : Short.valueOf(operator);
        }

        public void handleError(Exception ex) {
            AdvancedInputModule.this.log.error((Object)ex, (Throwable)ex);
        }

        public HardwareApi getHardwareApi() {
            return this.hardwareApi;
        }

        public InputElement getValue(String code) {
            return EnvAttributeProcessor.getValue(code);
        }

        public AdvancedCommissionCalculator getCommissionCalculator() {
            return new AdvCommissionCalculatorImpl();
        }

        public void openUrl(String url, OpenUrlTarget target, MethodType method, String encoding, Map<String, String> params) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void getCardTrack(int track, CardRequestListener cardRequestListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void play(String file) {
            AudioPlayerFx.getInstance().play(file);
        }

        public void executeCardModuleTask(CardOperation operation, boolean needReject, CardModuleRequestListener cardRequestListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

