/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input.adv;

import fxterm.core.BaseCommissionCalculator;
import fxterm.session.Session;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.Rounding;
import ru.softlogic.service.comission.Commission;

public class AdvCommissionCalculatorImpl
implements AdvancedCommissionCalculator {
    public Double calculateIncomeSum(Double outcome, Rounding rounding) {
        CashUnit minUnits;
        int calc;
        Sum sum = new Sum((int)(outcome * 100.0), Session.getInCurrency());
        Commission commission = Session.getCommission();
        Commission commMin = Session.getService().getMinComm();
        Commission commMax = Session.getService().getMaxComm();
        boolean immc = Session.getSelectedItem().isIgnoreMinMaxCommission();
        int calcValue = calc = BaseCommissionCalculator.calculate(sum, commission, commMin, commMax, immc, null).getValue();
        double result = calcValue;
        if (rounding == Rounding.INTEGER) {
            result = AdvCommissionCalculatorImpl.roundUp(calcValue, 100);
        } else if (rounding == Rounding.NOMINAL && (minUnits = (CashUnit)Session.getData().get("mincash")) != null) {
            int minNomValue = minUnits.getNominal().getValue();
            result = AdvCommissionCalculatorImpl.roundUp(calcValue, minNomValue);
        }
        return result / 100.0;
    }

    private static int roundUp(int sum, int roundValue) {
        if (sum % roundValue != 0) {
            return sum + roundValue - sum % roundValue;
        }
        return sum;
    }
}

