/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input;

import fxterm.module.input.InputModule;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.input.adv.AdvancedInputModule;
import fxterm.module.input.card.CardBalanceInputModule;
import fxterm.module.input.card.CardReportInputModule;
import fxterm.module.input.card.CashToCardInputModule;
import fxterm.module.input.card.CashToNoCardInputModule;
import fxterm.module.input.cvd.CvdInputModule;
import fxterm.module.input.keeper.KeeperContext;
import fxterm.module.input.mobile.MobileInputModule;
import fxterm.module.input.site.LocalSiteInputModule;
import fxterm.module.input.uni.UniversalInputModule;
import fxterm.module.utility.chcopy.DocCopyAdapter;
import fxterm.module.utility.console.ConsoleAdapter;
import fxterm.module.utility.paystat.PayStatusAdapter;
import fxterm.module.utility.search.SearchServiceAdapter;
import java.util.EnumMap;
import java.util.Map;
import ru.softlogic.provider.ProviderType;

public class InputModuleFactory {
    private static final String M_PATH_EXCHANGE = "fxterm.module.input.exchange.ExchangeInputModule";
    private static final String M_PATH_EXCHANGE_V2 = "fxterm.module.input.exchange.v2.ExchangeInputModule";
    private static Map<ProviderType, InputModule> modules = new EnumMap<ProviderType, InputModule>(ProviderType.class);

    private InputModuleFactory() {
    }

    public static InputModule getModule(ProviderType type) throws ModuleCreateException {
        if (type == null) {
            throw new ModuleCreateException("Provider type is not set");
        }
        InputModule im = modules.get(type);
        if (im != null) {
            return im;
        }
        switch (type) {
            case Mobile: {
                im = new MobileInputModule();
                break;
            }
            case UniversalProvider: {
                im = new UniversalInputModule();
                break;
            }
            case AdvancedProvider: {
                im = new AdvancedInputModule();
                break;
            }
            case Cvd: {
                im = new CvdInputModule();
                break;
            }
            case SiteProvider: {
                im = new LocalSiteInputModule();
                break;
            }
            case Exchange: {
                im = InputModuleFactory.createModule(M_PATH_EXCHANGE_V2);
                break;
            }
            case Keeper: {
                im = new KeeperContext();
                break;
            }
            case CardBalance: {
                im = new CardBalanceInputModule();
                break;
            }
            case CardReport: {
                im = new CardReportInputModule();
                break;
            }
            case CashToCard: {
                im = new CashToCardInputModule();
                break;
            }
            case CashToNoCard: {
                im = new CashToNoCardInputModule();
                break;
            }
            case SearchService: {
                im = new SearchServiceAdapter();
                break;
            }
            case PaymentStatusProvider: {
                im = new PayStatusAdapter();
                break;
            }
            case ChCopyProvider: {
                im = new DocCopyAdapter();
                break;
            }
            case AdminProvider: {
                im = new ConsoleAdapter();
                break;
            }
            default: {
                throw new ModuleCreateException("Can't create module: " + type);
            }
        }
        modules.put(type, im);
        return im;
    }

    private static InputModule createModule(String className) throws ModuleCreateException {
        try {
            return (InputModule)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new ModuleCreateException(ex);
        }
    }
}

