/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input;

import fxterm.module.Environment;
import fxterm.module.Restorable;
import fxterm.module.input.ModuleInitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import plfx.screen.ScreenInit;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.system.util.PathUtils;

public class InitModuleHelper {
    private InitModuleHelper() {
    }

    public static void check(Environment environment, Restorable parent) throws ModuleInitException {
        if (environment == null) {
            throw new ModuleInitException("Enviroment is not set");
        }
        if (parent == null) {
            throw new ModuleInitException("Parent is not set");
        }
    }

    public static ScreenInit createScreenInit() {
        return new ScreenInit(new ModelEnvironment(new HashMap(), "CUR", 1.0, null));
    }

    public static ScreenInit buildScreenInit(Environment environment, Map<String, Object> data) {
        ScreenInit si = new ScreenInit(new ModelEnvironment(data, null, 1.0, null));
        return si;
    }

    public static ScreenInit buildScreenInit(Environment environment, Map<String, Object> data, Service service, Commission commission) {
        ScreenInit si = new ScreenInit(new ModelEnvironment(data, null, 1.0, null));
        return si;
    }

    public static SumScreenDescription createSumScreenDescription() {
        SumScreenDescription sd = new SumScreenDescription();
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("prev", new ButtonInit(null));
        buttons.put("exit", new ButtonInit(null));
        buttons.put("next", new ButtonInit(null));
        buttons.put("cbc", new ButtonInit(null));
        sd.setButtons(buttons);
        return sd;
    }

    public static Map<String, ButtonInit> createKeyMap() {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("prev", new ButtonInit(null));
        buttons.put("exit", new ButtonInit(null));
        buttons.put("next", new ButtonInit(null));
        return buttons;
    }

    public static Map<String, ButtonInit> createBarcodeKeyMap() {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("prev", new ButtonInit(null));
        buttons.put("exit", new ButtonInit(null));
        buttons.put("next", new ButtonInit(null));
        buttons.put("skip", new ButtonInit(null));
        return buttons;
    }

    public static Map<String, ButtonInit> createEditKeyMap() {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("prev", new ButtonInit(null));
        buttons.put("exit", new ButtonInit(null));
        buttons.put("next", new ButtonInit(null));
        buttons.put("edit", new ButtonInit(null));
        return buttons;
    }

    public static Properties readModuleOptions(String moduleId) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(PathUtils.getFilePath((String)("/res/module/" + moduleId + "/module.properties")));){
            props.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public static Form readForm(String moduleId, Locale locale, int screenCount) throws ParseException {
        Form form = Parser.getForm((File)PathUtils.getFilePath((String)("/res/module/" + moduleId + "/form.xml")), (short)0, (File)PathUtils.getFilePath((String)"/res/module/input/ds/"));
        if (form.getScreenSequence().getScreens().size() != screenCount) {
            throw new ParseException("Wrong number of screens");
        }
        return form;
    }

    public static ScreenDescription readScreenDesc(String moduleId, Locale locale, int fieldCount) throws ParseException {
        Form form = InitModuleHelper.readForm(moduleId, locale, 1);
        ScreenDescription sd = (ScreenDescription)form.getScreenSequence().getScreens().get(0);
        if (sd.getSequence().getFields().size() != fieldCount) {
            throw new ParseException("Wrong number of fields");
        }
        return sd;
    }
}

