/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.module.CancelDialogListener;
import fxterm.module.Environment;
import fxterm.module.input.InputModule;
import fxterm.module.utility.UtilityModuleFactory;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.skin.Skin;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.reference.References;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public abstract class ComplexScreenListener
extends BaseScreenListener {
    private InputModule inputModule;
    private Environment environment;
    private final Logger log = LoggerId.PAY;

    public ComplexScreenListener(InputModule inputModule) {
        if (inputModule == null) {
            throw new NullPointerException("InputModule");
        }
        this.inputModule = inputModule;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public final void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.log.info((Object)("Process action: " + action));
        if (ActionType.isNext((String)action)) {
            if (ComplexScreenListener.isUnwantedClient(data)) {
                GuiNotifier.notifyProblem((String)("Unwanted client: " + StoreHelper.getMainValue(data)));
                Dialog.show((String)"module/listener_unwanted", (DialogListener)new CancelDialogListener(cancelListener));
                return;
            }
            if (Session.getPoint().getSecretPhone() != null && data != null && Session.getPayEnv().getKeeper().isEmpty() && Skin.getAllSkins().size() == 1) {
                String phone = Session.getPoint().getSecretPhone();
                this.log.info((Object)("Secret phone: " + phone));
                InputElement num = null;
                for (Object obj : data.values()) {
                    if (!(obj instanceof InputElement)) continue;
                    InputElement ie = (InputElement)obj;
                    if (num == null) {
                        num = ie;
                    }
                    if (!phone.equals(ie.getValue())) continue;
                    this.log.info((Object)("User input secret number: " + phone + ", show dialog"));
                    Dialog.show((String)"module/listener_console", actionId -> {
                        if (actionId == 0) {
                            this.log.info((Object)"Go to admin module");
                            UtilityModuleFactory.runQuietly(2);
                        } else {
                            this.log.info((Object)"Skip admin module");
                            this._checkInvalide(action, data, cancelListener);
                        }
                    });
                    return;
                }
            }
            this._checkInvalide(action, data, cancelListener);
            return;
        }
        this._onAction(action, data, cancelListener);
    }

    private void _checkInvalide(String action, Map<String, Object> data, Runnable cancelListener) {
        this.log.info((Object)"Check invalid data");
        if (data.containsKey("#invalid")) {
            data.remove("#invalid");
            this.log.info((Object)"Invalid input data. Ask about payment");
            Dialog.show((String)"module/listener_invalide", actionId -> {
                if (actionId == 0) {
                    this.log.info((Object)"User confirm wrong data");
                    FxEnv.getConnector().sendEvent(new Event[]{new Event(EventType.NumberFault, Session.getService().getName() + ": " + data.values())});
                    this._onAction(action, data, cancelListener);
                } else {
                    this.log.info((Object)"Stayed here");
                    cancelListener.run();
                }
            });
        } else {
            this._onAction(action, data, cancelListener);
        }
    }

    public static boolean isUnwantedClient(Map<String, Object> form) {
        if (form == null) {
            return false;
        }
        PersonalNumber[] numbers = References.getPersonalNumbers();
        if (numbers != null) {
            for (PersonalNumber pn : numbers) {
                if (pn.getType() != PersonalNumberType.Black) continue;
                for (Map.Entry<String, Object> e : form.entrySet()) {
                    if (!(e.getValue() instanceof InputElement)) continue;
                    InputElement ie = (InputElement)e.getValue();
                    if (!pn.getNumber().equals(ie.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public abstract void _onAction(String var1, Map<String, Object> var2, Runnable var3);
}

