/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input;

import fxterm.app.id.LoggerId;
import fxterm.app.plt2.EntryPoint;
import fxterm.module.ExitDialogListener;
import fxterm.module.Module;
import fxterm.session.Session;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;

public abstract class BaseModule
implements Module {
    private static EntryPoint entryPoint;
    private Logger log;

    public BaseModule() {
        this(LoggerId.PAY);
    }

    public BaseModule(Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.log = log;
    }

    public static void init(EntryPoint entryPoint) {
        if (entryPoint == null) {
            throw new NullPointerException("EntryPoint is not set");
        }
        if (BaseModule.entryPoint != null) {
            throw new IllegalStateException("Entry point already set");
        }
        BaseModule.entryPoint = entryPoint;
    }

    public void exit() {
        this.beforeClose();
        entryPoint.toInitialState(1);
    }

    protected void beforeClose() {
        this.log.info((Object)"Close module");
    }

    protected void exit(Exception ex) {
        this.log.info((Object)"Finish module with error: ", (Throwable)ex);
        this.beforeClose();
        Dialog.show((String)"module/input/error_exit", (DialogListener)new ExitDialogListener(entryPoint, 1));
        GuiNotifier.notifyErrorOnce((String)ex.getMessage());
    }

    protected void back() {
        this.beforeClose();
        Session.resetSession();
        entryPoint.toPreviosState();
    }

    @Override
    public BarcodeListener getBarcodeScannerListener() {
        return null;
    }
}

