/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.input;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.task.Task;
import fxterm.module.CancelDialogListener;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.ModuleStore;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.input.BaseModule;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.input.InputModule;
import fxterm.msg.Messages;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import fxterm.utils.FormatUtils;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.util.Locator;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.CardStateListener;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeParser;
import ru.softlogic.hdw.dev.webcam.WebcamListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeScanner;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.References;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemSchedule;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.VerifyType;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.verify.ArgumentType;
import ru.softlogic.srv.api.verify.VerifyDataItem;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.api.verify.VerifyResultType;
import ru.softlogic.srv.connector.ConnectorException;

public abstract class BaseInputModule
extends BaseModule
implements InputModule,
CardStateListener,
WebcamListener {
    protected Runnable cancelListener;
    protected Logger log = LoggerId.PAY;
    private Environment env;
    private CommonScreen current;
    protected BarcodeScanner barcodeScanner;
    private final LocalBarcodeScannerListener barcodeListener = new LocalBarcodeScannerListener();
    protected String initBarcodeString;

    public BaseInputModule() {
        super(LoggerId.PAY);
    }

    @Override
    public int getInactivityTimeout() {
        return 120;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void cancel(Intent intent) {
        Pack pack = this.env.getPack();
        PackUtility.printPack("On cancel input module", pack);
        if (!Session.getPayEnv().getKeeper().isEmpty()) {
            this.log.info((Object)"Keeper is not empty.");
            this.change(pack);
        } else {
            this._cancel(intent);
        }
    }

    private void cancelPack() {
        Pack pack = this.env.getPack();
        this.log.info((Object)"Cancel operation to cbc");
        PackUtility.cancelPackToPin(pack);
        PackUtility.printPack("Canceled pack:", pack);
        Operation operation = PackUtility.convert(pack);
        this.log.info((Object)("Operation: " + operation));
        FxEnv.getConnector().putOperation(operation);
        this.log.info((Object)"Done");
    }

    @Override
    protected void back() {
        if (!Session.getPayEnv().getKeeper().getSum().isEmpty()) {
            this.log.info((Object)"Keeper is not empty.");
            this.log.info((Object)"Show manual dialog");
            this.change(this.env.getPack());
        } else {
            super.back();
        }
    }

    private void _cancel(Intent intent) {
        if (intent != null) {
            intent.process();
        } else {
            this.exit();
        }
    }

    @Override
    public final void start(Environment environment) {
        Object envBarcode;
        this.env = environment;
        this.log.info((Object)"\n");
        this.log.info((Object)"***** SELECT INPUT MODULE *****************************************************");
        this.log.info((Object)PackUtility.changeAsStr());
        NewKeeper2 k = Session.getPayEnv().getKeeper();
        this.log.info((Object)"Service info");
        this.log.info((Object)("    Service   : " + FormatUtils.srvToString(Session.getService())));
        this.log.info((Object)("    Commission: " + FormatUtils.commToString(Session.getCommission())));
        this.log.info((Object)("    Modules   : " + Session.getService().getModules()));
        this.log.info((Object)("    Locale    : " + Session.getLocale()));
        this.log.info((Object)("    Keeper    : " + (k != null && !k.isEmpty() ? k : "-")));
        this.log.info((Object)("    Flags     : " + String.format("0x%02x", Session.getActiveItem().getFlags())));
        this.log.info((Object)("    Prn error : " + Session.isPrinterError()));
        this.log.info((Object)"Allowed notes and coins:");
        Session.getAllowedNotes().stream().forEach(cu -> this.log.info((Object)("    id=" + cu.getId() + ", " + (cu.getType() == 3 ? "NOTE" : "VIRTUAL") + ", " + cu.getNominal())));
        Session.getAllowedCoins().stream().forEach(cu -> this.log.info((Object)("    id=" + cu.getId() + ", " + (cu.getType() == 4 ? "COIN" : "VIRTUAL") + ", " + cu.getNominal())));
        if (Session.getActiveItem().getSchedules() != null) {
            this.log.info((Object)"Menu item schedule:");
            for (MenuItemSchedule schedules : Session.getActiveItem().getSchedules()) {
                this.log.info((Object)("    " + schedules));
            }
        }
        this.log.info((Object)("    Changes   : " + Messages.getChangeFlags(Session.getService().getChangeType())));
        ModuleStore.setModule(this);
        Map<String, Object> envInitData = environment.getInitData();
        if (envInitData != null && (envBarcode = envInitData.get("barcode")) instanceof String) {
            this.initBarcodeString = (String)envBarcode;
        }
        this._start(environment);
    }

    @Override
    public void restore() {
        this._restore();
        ModuleStore.setModule(this);
    }

    protected void _redirect(short serviceId, Map<String, Object> params) {
        this.log.info((Object)("Requested redirect to service: " + serviceId));
        MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId);
        MenuUtils.processMenu(mbsiv);
        MenuItem mi = mbsiv.getMenuItem();
        if (mi != null && !mi.isDisableOnSchedule()) {
            this.log.info((Object)("Found service: " + mi.getService().getName()));
            NewKeeper2 k = Session.getPayEnv().getKeeper();
            this.log.info((Object)("Redirect with keeper: " + k));
            String curCurrency = Session.getService().getInCurrency();
            if (curCurrency.equals(mi.getService().getInCurrency())) {
                Platform.runLater(() -> Launcher.open(mi, params, k));
            } else {
                if (!k.isEmpty()) {
                    this.cancelPack();
                }
                this.log.error((Object)"Redirect is impossible. Currencies of services do not match");
                GuiNotifier.notifyProblemOnce((String)("Redirect is impossible. Currencies of services do not match. Service 'source': " + Session.getService().getId() + "-> service 'destination': " + serviceId));
                Dialog.show((String)"module/input/redirect_not_found");
                this.exit();
            }
        } else {
            this.log.error((Object)"Menu item is not found");
            GuiNotifier.notifyProblemOnce((String)("Redirect is not found to srv-id: " + serviceId + ", from " + Session.getService().getId()));
            Dialog.show((String)"module/input/redirect_not_found");
            this.exit();
        }
    }

    protected void _startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data) {
        this._startPayment(environment, (ScreenDescription)ssd, data, null);
    }

    protected void _startPayment(Environment environment, ScreenDescription ssd, Map<String, Object> data, Sum oper) {
        this.log.info((Object)"Pre-payment actions");
        Payment payment = new Payment();
        payment.setData(data);
        Commission personal = this.getPersonalCommission(data);
        if (personal != null) {
            this.log.info((Object)("Set personal commission: " + personal));
            GuiNotifier.notifyProblem((String)("Set personal commission: id=" + personal.getId() + ", name=" + personal.getName() + "->" + StoreHelper.getMainValue(data)));
            Session.setCommission(personal);
        } else {
            Session.setCommission(Session.getActiveItem().getCommission());
        }
        Pack pack = this.env.getPack();
        pack.getPayments().clear();
        pack.setOperationSum(oper);
        pack.getPayments().add(payment);
        pack.setCommission(Session.getCommission());
        pack.setService(Session.getService());
        pack.setServiceType(Session.getServiceType());
        String img = Session.getService().getImage();
        if (img != null && !img.isEmpty()) {
            ssd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + img)));
        } else {
            ssd.setIcon(null);
        }
        ssd.setStyleClass(Session.getService().getStyle());
        Session.setScreenDescription(ssd);
        try {
            CommonSumScreen css = ScreenStore.getCommonSumScreen((String)ssd.getType());
            ScreenInit si = InitModuleHelper.buildScreenInit(environment, data, Session.getService(), Session.getCommission());
            css.init(ssd, si);
            this.saveAttributeInSession(ssd, si);
            this.log.info((Object)"Start save pament template");
            environment.getModules().getSavePamentTemplateModule().start(environment, css, this);
        }
        catch (IllegalArgumentException | ScreenCreateException | InitException ex) {
            if (!Session.getPayEnv().getKeeper().isEmpty()) {
                this.cancelPack();
            }
            this.exit((Exception)ex);
        }
    }

    protected void prefillStore(Map<String, String> items, Map<String, Object> store) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (store == null) {
            return;
        }
        for (Map.Entry<String, String> entry : items.entrySet()) {
            try {
                String value = PropertyUtils.getProperty((Object)this.env, (String)entry.getValue()).toString();
                this.log.info((Object)("Add value: " + entry.getValue() + "->" + entry.getKey() + ", result: " + value));
                store.put(entry.getKey(), new InputElement(entry.getKey(), "", value));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                GuiNotifier.notifyProblem((String)("Prefill error: " + entry.getValue() + "->" + entry.getKey() + ", result: " + ex.getMessage()));
                this.log.error((Object)"Prefill error", (Throwable)ex);
            }
        }
    }

    public void showScreen(ScreenDescription sd, Map<String, Object> data, ScreenListener listener) throws ScreenCreateException, InitException {
        this.log.info((Object)("------ Show screen: " + sd.getType() + ", title=" + sd.getTitle()));
        this.current = null;
        try {
            this.current = ScreenStore.getCommonScreen((String)sd.getType());
            this.log.debug((Object)"Process message templates");
            this.current.setListener(listener);
            this.log.debug((Object)"Init screen");
            Session.setScreenDescription(sd);
            this.unlockBarcodeScannerListener();
            this.current.init(sd, InitModuleHelper.buildScreenInit(this.env, data));
            this.log.debug((Object)"Show screen");
            FxEnv.showScreen((Screen)this.current);
            if (sd.getSound() != null) {
                AudioPlayerFx.getInstance().play(sd.getSound());
            }
            this.log.debug((Object)"Complete");
        }
        catch (InitException ex) {
            this.current = null;
            throw ex;
        }
    }

    public void showScreenSafe(ScreenDescription sd, ScreenListener sl) {
        this.showScreenSafe(sd, new HashMap<String, Object>(), sl);
    }

    public void showScreenSafe(ScreenDescription sd, Map<String, Object> data, ScreenListener sl) {
        String icon = Session.getService().getImage();
        String styleClass = Session.getService().getStyle();
        if (icon != null && !icon.isEmpty()) {
            sd.setIcon(Locator.getPath((String)("/gui/skin/{name}/img/" + icon)));
        } else {
            sd.setIcon(null);
        }
        sd.setStyleClass(styleClass);
        try {
            this.showScreen(sd, data, sl);
        }
        catch (ScreenCreateException | InitException ex) {
            this.log.error((Object)("Error on show screen " + sd.getType()), ex);
            this.exit((Exception)ex);
        }
    }

    public Commission getPersonalCommission(Map<String, Object> form) {
        if (form == null) {
            return null;
        }
        Service s = Session.getService();
        Short sid = s != null ? Short.valueOf(s.getId()) : null;
        PersonalNumber[] numbers = References.getPersonalNumbers();
        if (numbers != null) {
            for (PersonalNumber pn : numbers) {
                if (pn.getType() != PersonalNumberType.White || sid != null && sid.shortValue() != pn.getService()) continue;
                for (Map.Entry<String, Object> entry : form.entrySet()) {
                    if (!(entry.getValue() instanceof InputElement)) continue;
                    InputElement ie = (InputElement)entry.getValue();
                    if (!pn.getNumber().equals(ie.getValue())) continue;
                    return pn.getCommission();
                }
            }
        }
        return null;
    }

    public void notifyUnknownNumber(String number) {
        FxEnv.getConnector().sendEvent(new ru.softlogic.srv.api.event.Event[]{new ru.softlogic.srv.api.event.Event(EventType.NumberFault, Session.getService().getName() + ": " + number)});
    }

    protected void startVerify(Map<String, Object> data, boolean force) {
        this.log.info((Object)"Start verify");
        Service s = Session.getService();
        VerifyType verifyType = s.getVerifyType();
        MenuItem mi = Session.getActiveItem();
        Commission comm = this.getPersonalCommission(data);
        if (comm == null) {
            comm = Session.getCommission();
        }
        this.log.info((Object)("Verify type: " + verifyType));
        if (force || verifyType == VerifyType.Verify || verifyType == VerifyType.HalfOnline || verifyType == VerifyType.Optional && mi.hasFlag(4)) {
            new VerifyTask(s, comm, data, s.getVerifyType()).process();
        } else {
            this.onSkipVerify();
        }
    }

    protected void startVerify(Map<String, Object> data) {
        this.startVerify(data, false);
    }

    protected void onSkipVerify() {
        this.log.error((Object)"Skip verify");
    }

    protected void onVerifyResult(Map<String, Object> result) {
        this.log.error((Object)("Verify result: " + result));
    }

    protected void processInitBarcodeString(String initString, Map<String, Object> data) {
        try {
            BarcodeData parse = this.barcodeScanner.getParser().parse(initString);
            Map convert = ContextHelper.convert((List)parse.getElements());
            data.putAll(convert);
        }
        catch (BarcodeException ex) {
            this.log.warn((Object)ex, (Throwable)ex);
        }
    }

    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.exit(new IllegalArgumentException("Unknown action: " + action));
    }

    protected abstract void _start(Environment var1);

    protected abstract void _restore();

    private void change(Pack pack) {
        if (pack.getSumResult() == null) {
            Pack nPack = new Pack(Session.getPayEnv().getPack());
            nPack.setChangeDate(pack.getChangeDate());
            pack = nPack;
            this.env.setPack(pack);
            NewKeeper2 kpr = Session.getPayEnv().getKeeper();
            kpr.setSumOut(FinUtils.createVoidSum());
        }
        PackUtility.cancelPack(pack);
        Session.getPaymentEndingState().setCancel(true);
        this.env.getPack().setPaymentType(2);
        this.env.getPack().setPaybackType(0);
        this.env.getModules().getBeforePayoutModule().startPayout(this.env);
    }

    private void saveAttributeInSession(ScreenDescription ssd, ScreenInit si) {
        if (!si.getModelEnvironment().getData().isEmpty()) {
            Map d = si.getModelEnvironment().getData();
            this.addInputIlement(d, "real_curs", "RealCurs");
            this.addInputIlement(d, "fake_curs", "FakeCurs");
            this.addInputIlement(d, "tax_info", "tax-info");
        }
        if (ssd != null && ssd.getType() != null && ssd.getType().endsWith("fake")) {
            Session.setItem("show_fake_comm", true);
        } else {
            Session.setItem("show_fake_comm", false);
        }
    }

    private void addInputIlement(Map<String, Object> d, String item, String key) {
        Object obj = d.get(key);
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            Session.setItem(item, ie);
        }
    }

    protected void mergeData(Map<String, Object> data) {
        this.log.info((Object)"This input module does not have implementation of mergeData method");
    }

    protected void showNextScreen() {
        this.log.info((Object)"This input module does not have implementation of showNextScreen method");
    }

    protected void showCurrentScreen() {
        this.log.info((Object)"This input module does not have implementation of showCurrentScreen method");
    }

    protected void unlockBarcodeScannerListener() {
        this.barcodeListener.unlock();
    }

    @Override
    public BarcodeListener getBarcodeScannerListener() {
        return this.barcodeListener;
    }

    public void onCardState(int cardState) {
        this.log.info((Object)("Card state is change: " + CRMsg.getCardState((int)cardState)));
        this._onCardState(cardState);
        if (cardState == 2) {
            if (this.current != null) {
                this.log.info((Object)"Notify screen");
                Platform.runLater(() -> this.current.onEvent(new Event(0)));
            } else {
                this.log.info((Object)"Screen is null, skip");
            }
        }
    }

    protected void _onCardState(int cardState) {
    }

    public void onError() {
        if (this.current.getWebcamListener() != null) {
            Platform.runLater(() -> this.current.getWebcamListener().onError());
        }
    }

    public void onPhoto(BufferedImage bi) {
        if (this.current != null && this.current.getWebcamListener() != null) {
            Platform.runLater(() -> this.current.getWebcamListener().onImage(SwingFXUtils.toFXImage((BufferedImage)bi, null)));
            if (this.barcodeScanner != null) {
                try {
                    List codes = BarcodeParser.parseBarcode((BufferedImage)bi, null, (boolean)false);
                    Platform.runLater(() -> this.barcodeListener.onBarcode((String)codes.iterator().next()));
                }
                catch (ru.softlogic.hdw.dev.printer.pos.img.BarcodeException barcodeException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean canRedirect() {
        LoggerId.PAY.info((Object)"Request for permission to redirect from InputModule");
        return Session.getPayEnv().getKeeper().isEmpty();
    }

    protected Sum createSum(int value) {
        return new Sum(value, Session.getInCurrency());
    }

    protected Sum createSum(double value) {
        return new Sum((int)Math.round(value * 100.0), Session.getInCurrency());
    }

    protected Sum getOperationSum(Map<String, Object> data) {
        return this.getSum(data, "#sum");
    }

    protected Sum getSum(Map<String, Object> data, String key) {
        Sum sum = null;
        if (key != null) {
            Object obj = data.get(key);
            if (obj instanceof TransactionSum) {
                TransactionSum ts = (TransactionSum)obj;
                sum = new Sum(ts.getSum(), Session.getInCurrency());
            } else if (obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    sum = this.createSum(Double.parseDouble(ie.getValue()));
                } else {
                    this.log.error((Object)("Wrong sum format: " + ie.getValue()));
                }
            } else if (obj instanceof Sum) {
                sum = (Sum)obj;
            }
        }
        return sum;
    }

    protected FeeSum getFeeSum(Map<String, Object> data, String key) {
        FeeSum fs = null;
        Object obj = data.get(key);
        if (obj instanceof ru.softlogic.input.model.FeeSum) {
            ru.softlogic.input.model.FeeSum fsi = (ru.softlogic.input.model.FeeSum)obj;
            fs = new FeeSum(fsi.getFee(), fsi.getFeeName(), fsi.getFeePercent());
            this.log.info((Object)("Set provider fee: " + fs));
        }
        return fs;
    }

    private class LocalBarcodeScannerListener
    implements BarcodeListener {
        private final Object obj = new Object();
        private volatile int lock;

        private LocalBarcodeScannerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBarcode(String barcode) {
            BaseInputModule.this.log.info((Object)("Received barcode: " + barcode));
            Object object = this.obj;
            synchronized (object) {
                block11: {
                    ++this.lock;
                    if (this.lock == 1) {
                        if (BaseInputModule.this.barcodeScanner != null) {
                            BaseInputModule.this.log.info((Object)"Try to parce:");
                            try {
                                BarcodeData bd = BaseInputModule.this.barcodeScanner.getParser().parse(barcode);
                                BaseInputModule.this.log.info((Object)("Result: " + bd));
                                BaseInputModule.this.mergeData(StoreHelper.convertObj((List)bd.getElements()));
                                if (BarcodeScanner.isRefresh((String)BaseInputModule.this.barcodeScanner.getOnSuccess())) {
                                    BaseInputModule.this.log.info((Object)"Refresh");
                                    BaseInputModule.this.showCurrentScreen();
                                    break block11;
                                }
                                BaseInputModule.this.log.info((Object)"Goto next");
                                BaseInputModule.this.showNextScreen();
                            }
                            catch (BarcodeException be) {
                                if (BaseInputModule.this.barcodeScanner.isShowError()) {
                                    Dialog.show((String)"module/input/barcode_failure", actionId -> this.unlock());
                                }
                                BaseInputModule.this.log.error((Object)"Error on process barcode", (Throwable)be);
                            }
                        } else {
                            BaseInputModule.this.log.info((Object)"Parser is missing");
                        }
                    } else {
                        BaseInputModule.this.log.warn((Object)("Lock count: " + this.lock + ". Last barcode is not process, skip parce"));
                    }
                }
            }
        }

        public void unlock() {
            this.lock = 0;
        }
    }

    private class VerifyTask
    extends Task {
        private final Service service;
        private final Commission commission;
        private final Map<String, Object> data;
        private final VerifyType verifyType;

        public VerifyTask(Service service, Commission commission, Map<String, Object> data, VerifyType verifyType) {
            this.service = service;
            this.commission = commission;
            this.data = data;
            this.verifyType = verifyType;
        }

        @Override
        protected String getWaitId() {
            return "network.request";
        }

        protected Object execute() throws Exception {
            BaseInputModule.this.log.info((Object)"Make online request");
            Map form = StoreHelper.convertDep(this.data);
            Sum operSum = BaseInputModule.this.getOperationSum(this.data);
            if (operSum != null) {
                Sum reqSum = BaseCommissionCalculator.calculate(operSum, this.commission);
                Sum comm = reqSum.sub(operSum);
                if (comm.getValue() < 0) {
                    comm = FinUtils.createVoidSum();
                }
                form.put("Sumpurchase", String.valueOf(operSum.getValue()));
                form.put("Commission", String.valueOf(comm.getValue()));
            }
            BaseInputModule.this.log.info((Object)("Data: " + this.data));
            BaseInputModule.this.log.info((Object)("Form: " + form));
            try {
                VerifyResult vr = FxEnv.getConnector().verify(Session.getService(), form);
                if (this.verifyType == VerifyType.HalfOnline && vr.getResultType() == VerifyResultType.ProviderAnswerError) {
                    return new VerifyResult(VerifyResultType.Ok);
                }
                return vr;
            }
            catch (ConnectorException ex) {
                if (this.verifyType == VerifyType.HalfOnline) {
                    return new VerifyResult(VerifyResultType.Ok);
                }
                throw ex;
            }
        }

        protected void onResult(Object object) {
            BaseInputModule.this.log.info((Object)("Result: " + object));
            HashMap<String, Object> resData = new HashMap<String, Object>();
            VerifyResult result = (VerifyResult)object;
            if (result.getResultType() == VerifyResultType.Ok) {
                if (result.getDataItems() != null && result.getDataItems().length > 0) {
                    for (VerifyDataItem vdi : result.getDataItems()) {
                        if (!ArgumentType.In.equals((Object)vdi.getType()) && !ArgumentType.InOut.equals((Object)vdi.getType())) continue;
                        int flags = vdi.getFlags() == null ? 0 : vdi.getFlags();
                        resData.put(vdi.getKey(), new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), flags));
                    }
                    if (result.getSumPurchase() != null) {
                        resData.put("#sum", result.getSumPurchase());
                    }
                    BaseInputModule.this.log.info((Object)("Result data: " + resData));
                }
                BaseInputModule.this.onVerifyResult(resData);
            } else {
                if (result.getDataItems() != null && result.getDataItems().length > 0) {
                    VerifyDataItem di = result.getDataItems()[0];
                    Session.setItem("ver_result", di.getValueTitle() != null ? di.getValueTitle() : di.getValue());
                }
                Dialog.show((String)("module/input/verify_result_" + result.getResultType().name().toLowerCase()), (DialogListener)new CancelDialogListener(BaseInputModule.this.cancelListener));
            }
        }

        @Override
        protected void onError(Exception ex) {
            BaseInputModule.this.log.info((Object)"Error on online request:", (Throwable)ex);
            Dialog.show((String)"module/input/verify_error", (DialogListener)new CancelDialogListener(BaseInputModule.this.cancelListener));
        }

        public String toString() {
            return "VerifyTask{}";
        }
    }
}

