/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu.rotator;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.module.entry.menu.GroupComparable;
import fxterm.module.entry.menu.KeyComparable;
import fxterm.module.entry.menu.rotator.RotationList;
import fxterm.module.entry.menu.rotator.RotatorHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import plfx.screen.menu.MenuTemplate;
import plfx.util.TerminalPlatform;
import ru.softlogic.reference.service.ServiceType;

public class ServiceRotator {
    private static final ServiceRotator instance = new ServiceRotator();
    private static final int MIN_PERIOD = 10;
    private static int rotationPeriod = 10;
    private MenuTemplate menuTemplate;
    private final Map<ServiceType, RotationList> groupMap;
    private volatile boolean needUpdate;
    private volatile long lastUpdate;
    private final Logger log = LoggerId.GUI;
    private boolean started;
    private Thread rotatorThread;

    private ServiceRotator() {
        this.groupMap = new ConcurrentHashMap<ServiceType, RotationList>();
    }

    public static ServiceRotator getInstance() {
        return instance;
    }

    public void start() {
        this.started = true;
        this.lastUpdate = System.currentTimeMillis() / 1000L;
        this.rotatorThread = new Thread((Runnable)new Rotator(), "ServiceRotatorThread");
        this.rotatorThread.setDaemon(true);
        this.rotatorThread.start();
    }

    public void stop() {
        this.started = false;
        if (this.rotatorThread != null) {
            this.rotatorThread.interrupt();
            this.rotatorThread = null;
        }
    }

    private void rotate() {
        this.lastUpdate = System.currentTimeMillis() / 1000L;
        if (this.menuTemplate != null) {
            FxEnv.getMenuEngine().showTop();
        }
    }

    public void setMenuTemplate(MenuTemplate mt) {
        boolean bl = this.needUpdate = !mt.equals(this.menuTemplate);
        if (this.needUpdate) {
            this.lastUpdate = System.currentTimeMillis() / 1000L;
            this.log.debug((Object)"ServiceRotator: clear groupMap");
            this.groupMap.clear();
        }
        this.log.debug((Object)("ServiceRotator: set menu template " + mt));
        this.menuTemplate = mt;
    }

    public List<KeyComparable> handleButtons(List<? extends KeyComparable> buttons) {
        this.log.debug((Object)("ServiceRotator: started = " + this.started));
        if (!this.started) {
            return buttons;
        }
        LinkedList<KeyComparable> result = new LinkedList<KeyComparable>();
        for (KeyComparable kc : buttons) {
            this.log.debug((Object)("ServiceRotator: handle " + kc.getClass()));
            if (kc instanceof GroupComparable) {
                GroupComparable gc = (GroupComparable)kc;
                if (gc.getServiceType().hasFlag((short)1)) {
                    RotationList rList = this.groupMap.get(gc.getServiceType());
                    this.log.debug((Object)("ServiceRotator: rlist = " + rList));
                    if (rList != null) {
                        this.log.debug((Object)("ServiceRotator: rlist size = " + rList.size()));
                        result.add(rList.nextElement());
                    }
                    if (rList != null) continue;
                    List<KeyComparable> mixed = RotatorHelper.getMixedItems(gc.getServiceType());
                    if (mixed != null && !mixed.isEmpty()) {
                        rList = new RotationList(mixed);
                        this.log.debug((Object)("ServiceRotator: created rlist size = " + rList.size()));
                        this.groupMap.put(gc.getServiceType(), rList);
                        result.add(rList.nextElement());
                        continue;
                    }
                    result.add(gc);
                    continue;
                }
                result.add(kc);
                continue;
            }
            result.add(kc);
        }
        return result;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setRotationInterval(int interval) {
        if (interval != rotationPeriod) {
            if (interval >= 10) {
                this.log.info((Object)("Service rotation interval changed to: " + interval));
                rotationPeriod = interval;
            } else {
                this.log.info((Object)"Service rotation interval must be greate then: 10");
            }
        }
    }

    private class Rotator
    implements Runnable {
        private Rotator() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    if (System.currentTimeMillis() / 1000L - ServiceRotator.this.lastUpdate >= (long)rotationPeriod) {
                        Module m = ModuleStore.getModule();
                        ServiceRotator.this.log.debug((Object)("ServiceRotator: current module: " + m));
                        if (m != null && m.getType() == 1) {
                            ServiceRotator.this.log.info((Object)"ServiceRotator: rotate");
                            TerminalPlatform.runLater(() -> ServiceRotator.this.rotate());
                        }
                    }
                    Thread.sleep((long)rotationPeriod * 500L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

