/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu.rotator;

import fxterm.app.FxEnv;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.ComplexMenuItem;
import fxterm.core.menu.MenuUtils;
import fxterm.module.entry.menu.GroupComparable;
import fxterm.module.entry.menu.KeyComparable;
import fxterm.module.entry.menu.MenuItemComparable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;

public class RotatorHelper {
    public static List<KeyComparable> getMixedItems(ServiceType serviceType) {
        if (serviceType == null) {
            return null;
        }
        LinkedList<KeyComparable> list = new LinkedList();
        if (serviceType.getMenuItems() != null) {
            for (MenuItem mi : serviceType.getMenuItems()) {
                Service service = mi.getService();
                if (!MenuUtils.currencySupport(service)) continue;
                list.add(new MenuItemComparable(new ComplexMenuItem(mi, MenuUtils.getState(mi)), menuItem -> Launcher.open(menuItem)));
            }
        }
        if (serviceType.getTypes() != null) {
            ArrayList<GroupComparable> grpCollect = new ArrayList<GroupComparable>();
            for (ServiceType st : serviceType.getTypes()) {
                if (st.getName().startsWith("#") || st.isHidden()) continue;
                grpCollect.add(new GroupComparable(st, 0, (serviceType1, level) -> FxEnv.getMenuEngine().onGroup(serviceType1, level)));
            }
            list.addAll(grpCollect);
        }
        list = list.stream().sorted((o1, o2) -> Integer.compare(o1.getSortOrder(), o2.getSortOrder())).collect(Collectors.toList());
        return list;
    }
}

