/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu.rotator;

import fxterm.app.FxEnv;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.module.entry.menu.KeyComparable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import plfx.screen.menu.MenuTemplate;
import plfx.util.TerminalPlatform;

public class HotKeyRotator {
    private static final HotKeyRotator instance = new HotKeyRotator();
    private static int rotationPeriod = 7;
    private MenuTemplate menuTemplate;
    private List<KeyComparable> save = new LinkedList<KeyComparable>();
    private volatile boolean rotate;
    private volatile long lastUpdate;
    private volatile boolean needUpdate;
    private boolean started;
    private boolean needRotate = true;
    private Thread rotatorThread;

    private HotKeyRotator() {
    }

    public static HotKeyRotator getInstance() {
        return instance;
    }

    public void fixRotate() {
        this.rotate = false;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public boolean isNeedRotate() {
        return this.needRotate;
    }

    public void start() {
        this.started = true;
        this.lastUpdate = System.currentTimeMillis() / 1000L;
        this.rotatorThread = new Thread((Runnable)new Rotator(), "HotKeyRotatorThread");
        this.rotatorThread.setDaemon(true);
        this.rotatorThread.start();
    }

    public void stop() {
        this.started = false;
        if (this.rotatorThread != null) {
            this.rotatorThread.interrupt();
            this.rotatorThread = null;
        }
    }

    private void rotate() {
        this.lastUpdate = System.currentTimeMillis() / 1000L;
        if (this.menuTemplate != null) {
            FxEnv.getMenuEngine().showTop();
        }
    }

    public void setMenuTemplate(MenuTemplate mt) {
        boolean bl = this.needUpdate = !mt.equals(this.menuTemplate);
        if (this.needUpdate) {
            this.lastUpdate = System.currentTimeMillis() / 1000L;
        }
        this.menuTemplate = mt;
    }

    public boolean isStarted() {
        return this.started;
    }

    public List<KeyComparable> handleButtons(List<KeyComparable> buttons, int size) {
        if (!this.started) {
            return buttons;
        }
        if (!this.rotate) {
            this.rotate = true;
            if (this.save.isEmpty()) {
                this.save = buttons;
                return buttons;
            }
            return this.save;
        }
        List<KeyComparable> result = this.save;
        int lenght = result.size() - size;
        if (lenght != 0 && lenght > 0) {
            this.needRotate = true;
            Collections.rotate(result, 1);
        } else {
            this.needRotate = false;
        }
        return result;
    }

    private class Rotator
    implements Runnable {
        private Rotator() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Module m;
                    if (System.currentTimeMillis() / 1000L - HotKeyRotator.this.lastUpdate >= (long)rotationPeriod && (m = ModuleStore.getModule()) != null && m.getType() == 1) {
                        TerminalPlatform.runLater(() -> HotKeyRotator.this.rotate());
                    }
                    Thread.sleep((long)rotationPeriod * 500L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

