/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.app.SystemProp;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.entry.menu.MenuEngine;
import fxterm.module.entry.menu.MenuTemplateListenerImpl;
import fxterm.session.Session;
import fxterm.session.TemplateProcessor;
import plfx.screen.offer.OfferScreen;
import plfx.screen.offer.OfferScreenListener;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.system.util.PathUtils;

class OfferScreenListenerImpl
extends MenuTemplateListenerImpl
implements OfferScreenListener {
    private final OfferScreen offerScreen;

    public OfferScreenListenerImpl(MenuEngine engine, OfferScreen offerScreen) {
        super(engine);
        this.offerScreen = offerScreen;
    }

    @Override
    public void onBack() {
        this.engine.showTop();
    }

    public void onSetContent(String file) {
        this.log.info((Object)("Set offer content from file: " + file));
        if (this.offerScreen != null) {
            this.engine.module.show(this.offerScreen.getTemplate());
            if (file != null) {
                this.offerScreen.setContent(() -> TemplateProcessor.processTextQuietly(PathUtils.getPath((String)("/res/module/menu/" + file))));
            } else {
                this.offerScreen.setContent(() -> "");
            }
        }
    }

    public void onComplaintService() {
        int srvId = SystemProp.getComplaintServiceId();
        this.log.info((Object)("Complaint service id = " + srvId));
        if (srvId != -1) {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor((short)srvId);
            MenuUtils.processMenu(mbsiv);
            if (mbsiv.getMenuItem() != null) {
                this.log.info((Object)("Found menu item = " + mbsiv.getMenuItem()));
                Session.setRedirectItem(mbsiv.getMenuItem());
                this.engine.onExit();
                return;
            }
            this.log.info((Object)"Not found complaint menu item");
        }
        Dialog.show((String)"module/input/redirect_not_found");
    }

    public void onFaultService() {
        int srvId = SystemProp.getFaultServiceId();
        this.log.info((Object)("Fault service id = " + srvId));
        if (srvId != -1) {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor((short)srvId);
            MenuUtils.processMenu(mbsiv);
            if (mbsiv.getMenuItem() != null) {
                this.log.info((Object)("Found menu item = " + mbsiv.getMenuItem()));
                Session.setRedirectItem(mbsiv.getMenuItem());
                this.engine.onExit();
                return;
            }
            this.log.info((Object)"Not found fault menu item");
        }
        Dialog.show((String)"module/input/redirect_not_found");
    }

    public void onAddService() {
        short srvId = SystemProp.getAddServiceId();
        this.log.info((Object)("AddService service id = " + srvId));
        if (srvId != -1) {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(srvId);
            MenuUtils.processMenu(mbsiv);
            if (mbsiv.getMenuItem() != null) {
                this.log.info((Object)("Found menu item = " + mbsiv.getMenuItem()));
                Session.setRedirectItem(mbsiv.getMenuItem());
                this.engine.onExit();
                return;
            }
            this.log.info((Object)"Not found addService menu item");
        }
        Dialog.show((String)"module/input/redirect_not_found");
    }
}

