/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.app.id.LoggerId;
import fxterm.module.entry.menu.MenuEngine;
import fxterm.module.entry.menu.OfferScreenListenerImpl;
import fxterm.module.entry.menu.SelectLangScreenListenerImpl;
import fxterm.module.entry.menu.rotator.HotKeyRotator;
import fxterm.module.entry.menu.rotator.ServiceRotator;
import fxterm.module.utility.UtilityModuleFactory;
import fxterm.session.Session;
import fxterm.session.TemplateProcessor;
import org.apache.log4j.Logger;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenStore;
import plfx.screen.help.HelpFactory;
import plfx.screen.lang.SelectLangListener;
import plfx.screen.lang.SelectLangScreen;
import plfx.screen.menu.MenuTemplateListener;
import plfx.screen.offer.OfferFactory;
import plfx.screen.offer.OfferScreen;
import plfx.screen.offer.OfferScreenListener;
import ru.softlogic.system.util.PathUtils;

class MenuTemplateListenerImpl
implements MenuTemplateListener {
    protected final MenuEngine engine;
    private OfferScreen offerScreen;
    private OfferScreen helpScreen;
    private SelectLangScreen selectLangScreen;
    protected final Logger log = LoggerId.GUI;

    public MenuTemplateListenerImpl(MenuEngine engine) {
        this.engine = engine;
    }

    public void onSearchService() {
        this.log.info((Object)"Run search service utility");
        UtilityModuleFactory.runQuietly(3);
    }

    public void onPaymentState() {
        this.log.info((Object)"Run payment state utility");
        UtilityModuleFactory.runQuietly(1);
    }

    public void onCheckCopy() {
        this.log.info((Object)"Run check copy utility");
        UtilityModuleFactory.runQuietly(0);
    }

    public void onOffer(String file) {
        this.stopRotation();
        this.log.info((Object)("Show offer: " + file));
        this.createOfferScreen();
        if (this.offerScreen != null) {
            this.engine.module.show(this.offerScreen.getTemplate());
            if (file != null) {
                this.offerScreen.setContent(() -> TemplateProcessor.processTextQuietly(PathUtils.getPath((String)("/res/module/menu/" + file))));
            } else {
                this.offerScreen.setContent(() -> TemplateProcessor.processTextQuietly(PathUtils.getPath((String)"/res/module/menu/offer{0}.html")));
            }
        }
    }

    public void onHelp() {
        this.stopRotation();
        this.log.info((Object)"Show help");
        this.createHelpScreen();
        if (this.helpScreen != null) {
            this.engine.module.show(this.helpScreen.getTemplate());
            this.helpScreen.setContent(() -> TemplateProcessor.processTextQuietly(PathUtils.getPath((String)"/res/module/menu/help{0}.html")));
        }
    }

    public void onBack() {
        this.log.info((Object)"Back action");
        this.engine.onBack();
    }

    public void onExit() {
        this.log.info((Object)"Exit action");
        this.engine.onExit();
    }

    public void onSelectLang(String lang) {
        this.log.info((Object)("Press select lang: " + lang));
        Session.setLanguage(lang);
    }

    public void onSelectLang() {
        this.stopRotation();
        this.log.info((Object)"Show selectlang screen");
        this.createSelectLangScreen();
        if (this.selectLangScreen != null) {
            this.selectLangScreen.init();
            this.engine.module.show(this.selectLangScreen.getTemplate());
        }
    }

    public void onNextLang() {
        this.log.info((Object)"Press select next lang");
        Session.setNextLanguage();
    }

    public void onAction(String action) {
        this.log.error((Object)("Unknown action: " + action));
    }

    private void createOfferScreen() {
        if (this.offerScreen == null) {
            try {
                this.offerScreen = OfferFactory.createOfferScreen();
                this.offerScreen.setListener((OfferScreenListener)new OfferScreenListenerImpl(this.engine, this.offerScreen));
            }
            catch (ScreenCreateException ex) {
                this.log.info((Object)"Can't create offer screen", (Throwable)ex);
            }
        }
    }

    private void createHelpScreen() {
        if (this.helpScreen == null) {
            try {
                this.helpScreen = HelpFactory.createHelpScreen();
                this.helpScreen.setListener((OfferScreenListener)new OfferScreenListenerImpl(this.engine, this.helpScreen));
            }
            catch (ScreenCreateException ex) {
                this.log.info((Object)"Can't create help screen", (Throwable)ex);
                this.createOfferScreen();
                this.helpScreen = this.offerScreen;
            }
        }
    }

    private void createSelectLangScreen() {
        try {
            this.selectLangScreen = ScreenStore.getSelectLangScreen();
            this.selectLangScreen.setLocales(Session.getLangs());
            this.selectLangScreen.setCurrentLocale(Session.getLocale());
            this.selectLangScreen.setListener((SelectLangListener)new SelectLangScreenListenerImpl(this.engine));
        }
        catch (ScreenCreateException ex) {
            this.log.info((Object)"Can't create selectlang screen", (Throwable)ex);
        }
    }

    private void stopRotation() {
        HotKeyRotator.getInstance().stop();
        ServiceRotator.getInstance().stop();
    }
}

