/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.core.menu.ComplexMenuItem;
import fxterm.core.menu.utils.ButtonInitFactory;
import fxterm.module.entry.menu.BaseActionListener;
import fxterm.module.entry.menu.KeyComparable;
import fxterm.module.entry.menu.MenuItemListener;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;

public class MenuItemComparable
implements KeyComparable {
    private final ComplexMenuItem item;
    private final MenuItemListener listener;

    public MenuItemComparable(ComplexMenuItem item, MenuItemListener listener) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (listener == null) {
            throw new NullPointerException();
        }
        this.item = item;
        this.listener = listener;
    }

    @Override
    public Short getHotPosition() {
        return this.item.getMenuItem().getHotkeyPosition();
    }

    @Override
    public short getSortOrder() {
        return this.item.getMenuItem().getSortOrder();
    }

    public ComplexMenuItem getItem() {
        return this.item;
    }

    @Override
    public MenuButtonInit createButtonInit(String id) {
        return ButtonInitFactory.createButtonInit(this.item.getMenuItem(), this.item.getState(), (ActionListener)new BaseActionListener(){

            @Override
            protected void onActionImpl() {
                MenuItemComparable.this.listener.onMenuItem(MenuItemComparable.this.item.getMenuItem());
            }
        });
    }

    public String toString() {
        return "MenuItemComparable{item=" + this.item + '}';
    }
}

