/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.menu.ComplexMenuItem;
import fxterm.core.menu.HotVisitorNg;
import fxterm.core.menu.MenuKeyVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.utils.Filters;
import fxterm.module.ModuleStore;
import fxterm.module.entry.BaseEntryModule;
import fxterm.module.entry.EntryBarcodeListener;
import fxterm.module.entry.menu.GroupComparable;
import fxterm.module.entry.menu.GroupListener;
import fxterm.module.entry.menu.HotkeyItemComparator;
import fxterm.module.entry.menu.KeyComparable;
import fxterm.module.entry.menu.LayerData;
import fxterm.module.entry.menu.MenuConfig;
import fxterm.module.entry.menu.MenuItemComparable;
import fxterm.module.entry.menu.MenuItemListener;
import fxterm.module.entry.menu.MenuListener;
import fxterm.module.entry.menu.MenuTemplateListenerImpl;
import fxterm.module.entry.menu.rotator.HotKeyRotator;
import fxterm.module.entry.menu.rotator.ServiceRotator;
import fxterm.session.Session;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenStore;
import plfx.screen.TemplateCreateException;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.MenuTemplateListener;
import plfx.screen.menu.area.ButtonArea;
import plfx.shell.ScreenModule;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuKey;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.ServiceTypeFilter;

public class MenuEngine
extends BaseEntryModule {
    ScreenModule module;
    private MenuListener listener;
    private Stack<LayerData> layers;
    private EntryBarcodeListener barcodeListener;
    private final Logger log = LoggerId.GUI;
    private boolean addHotToMax;
    private boolean rotateService;
    private MenuTemplateListener mtl;
    private final LocalMenuItemListener defaultItemListener = new LocalMenuItemListener();
    private final LocalGroupListener defaultGroupListener = new LocalGroupListener();

    public MenuEngine(ScreenModule module) {
        if (module == null) {
            throw new NullPointerException("ScreenModule");
        }
        this.module = module;
        this.layers = new Stack();
        this.mtl = new MenuTemplateListenerImpl(this);
        this.barcodeListener = new EntryBarcodeListener();
        this.addHotToMax = SystemProp.isAddButtonsToMax();
    }

    @Override
    public void start() {
        this.log.info((Object)"Reinit menu");
        ModuleStore.setModule(this);
        AudioPlayerFx.getInstance().setLocale(Session.getLocale());
        AudioPlayerFx.getInstance().play("hello.mp3");
        this.layers.clear();
        try {
            MenuKey[] mks = References.getMenu().getMenuKeys();
            List types = ServiceType.getServiceTypes((ServiceType[])References.getMenu().getTypes(), (ServiceTypeFilter)Filters.ACTIVE_GROUP_FILTER);
            if (mks != null && mks.length > 0) {
                MenuKeyVisitor visitor = new MenuKeyVisitor(mks, new ServiceType(types.toArray(new ServiceType[types.size()])));
                MenuUtils.processMenu(visitor);
                this.layers.add(this.createLayerData(null, visitor.getStartMenu(), 0));
                this.rotateService = true;
            } else if (types.size() == 1) {
                ServiceType st = (ServiceType)types.get(0);
                this.layers.add(this.createLayerData(null, new ServiceType(st.getTypes(), st.getMenuItems()), 0));
                this.rotateService = false;
            } else {
                ServiceType vroot = new ServiceType(types.toArray(new ServiceType[types.size()]));
                vroot.setName("vroot");
                this.layers.add(this.createLayerData(null, vroot, 0));
                this.rotateService = false;
            }
            ServiceRotator.getInstance().setRotationInterval(References.getMenu().getServiceRotationInterval());
            if (HotKeyRotator.getInstance().isRotate()) {
                HotKeyRotator.getInstance().fixRotate();
            }
            this.showTop();
        }
        catch (TemplateCreateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    public void showTop() {
        LayerData data = this.layers.peek();
        Session.setServiceType(data.getType());
        this.log.info((Object)("Show " + data + ", layer=" + data.getMenuTemplate()));
        if (this.layers.size() == 1 && this.rotateService) {
            if (!ServiceRotator.getInstance().isStarted()) {
                ServiceRotator.getInstance().start();
            }
        } else {
            ServiceRotator.getInstance().stop();
        }
        if (SystemProp.isHotKeyRotate()) {
            if (this.layers.size() == 1 && HotKeyRotator.getInstance().isNeedRotate()) {
                if (!HotKeyRotator.getInstance().isStarted()) {
                    HotKeyRotator.getInstance().start();
                }
            } else {
                HotKeyRotator.getInstance().stop();
            }
            HotKeyRotator.getInstance().setMenuTemplate(data.getMenuTemplate());
        }
        ServiceRotator.getInstance().setMenuTemplate(data.getMenuTemplate());
        data.reinitScreen();
        this.module.show((FxScreenTemplate)data.getMenuTemplate());
    }

    public void setListener(MenuListener listener) {
        this.listener = listener;
    }

    @Override
    public void restore() {
        ModuleStore.setModule(this);
        HotKeyRotator.getInstance().fixRotate();
        this.showTop();
    }

    private LayerData createLayerData(LayerData parent, ServiceType root, int deep) throws TemplateCreateException {
        this.log.info((Object)("Create layer for deep=" + deep));
        MenuTemplate mt = this.createMenuTemplate(root, deep);
        mt.setListener(this.mtl);
        List groups = root.getServiceTypes(Filters.ACTIVE_GROUP_FILTER);
        List items = root.getMenuItems(Filters.ACTIVE_ITEM_FILTER);
        LinkedList<KeyComparable> hb = new LinkedList<KeyComparable>();
        ButtonArea hba = mt.getHotArea();
        this.log.info((Object)("Hot area capacity: " + hba.getCapacity()));
        if (hba.getCapacity() > 0) {
            HotVisitorNg ng = new HotVisitorNg(hba.getCapacity(), this.addHotToMax);
            MenuUtils.processMenu(ng);
            for (ComplexMenuItem complexMenuItem : ng.getItems()) {
                hb.add(new MenuItemComparable(complexMenuItem, this.defaultItemListener));
            }
            for (ServiceType serviceType : ng.getTypes()) {
                hb.add(new GroupComparable(serviceType, deep, this.defaultGroupListener));
            }
            Collections.sort(hb, new HotkeyItemComparator());
            this.log.info((Object)("Found hot keys, count: " + hb.size()));
        }
        ButtonArea gba = mt.getGroupArea();
        LinkedList<GroupComparable> gb = new LinkedList<GroupComparable>();
        this.log.debug((Object)("Group area capacity: " + gba.getCapacity()));
        if (gba.getCapacity() > 0 && !groups.isEmpty()) {
            for (ServiceType st : groups) {
                gb.add(new GroupComparable(st, deep, this.defaultGroupListener));
            }
            Collections.sort(gb, new HotkeyItemComparator());
            this.log.info((Object)("Found group keys, count: " + gb.size()));
        }
        ButtonArea buttonArea = mt.getMixedArea();
        this.log.info((Object)("Mixed area capacity: " + buttonArea.getCapacity()));
        LinkedList<KeyComparable> mb = new LinkedList<KeyComparable>();
        if (buttonArea.getCapacity() > 0) {
            for (MenuItem mi : items) {
                mb.add(new MenuItemComparable(new ComplexMenuItem(mi, MenuUtils.getState(mi)), this.defaultItemListener));
            }
            for (ServiceType st : groups) {
                mb.add(new GroupComparable(st, deep, this.defaultGroupListener));
            }
            Collections.sort(mb, new KeyComparable.SortOrderComparable());
        }
        return new LayerData(parent, root, mt, hb, gb, mb);
    }

    private MenuTemplate createMenuTemplate(ServiceType st, int deep) throws TemplateCreateException {
        String code = MenuConfig.getLayerCode(st, deep);
        this.log.info((Object)("Menu layer code for deep=" + deep + ": " + code));
        try {
            return ScreenStore.getMenuTemplate((String)code);
        }
        catch (TemplateCreateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            return ScreenStore.getMenuTemplate((String)MenuConfig.getDefaultLayerCode(deep));
        }
    }

    public void onGroup(ServiceType serviceType, int level) {
        this.log.info((Object)"");
        this.log.info((Object)("Click group: " + serviceType));
        this.log.info((Object)("    from deep: " + level + ", current deep: " + this.layers.size()));
        while (this.layers.size() > level + 1) {
            this.layers.pop();
        }
        this.log.info((Object)("        after clean: " + this.layers.size()));
        LoggerId.PAY.info((Object)("Select group: " + serviceType));
        this.layers.peek().setSelectedGroup(serviceType);
        Session.setServiceType(serviceType);
        try {
            this.layers.add(this.createLayerData((LayerData)this.layers.get(0), serviceType, this.layers.size()));
            this.showTop();
        }
        catch (TemplateCreateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    @Override
    public final BarcodeListener getBarcodeScannerListener() {
        return this.barcodeListener;
    }

    @Override
    public boolean canRedirect() {
        LoggerId.PAY.info((Object)"Request for permission to redirect from EntryModule");
        return true;
    }

    void onBack() {
        if (!this.layers.isEmpty()) {
            this.layers.pop();
            HotKeyRotator.getInstance().fixRotate();
            this.showTop();
        }
    }

    void onExit() {
        if (this.listener != null) {
            this.listener.onExit();
        }
    }

    private class LocalMenuItemListener
    implements MenuItemListener {
        private LocalMenuItemListener() {
        }

        @Override
        public void onMenuItem(MenuItem menuItem) {
            if (MenuEngine.this.listener != null) {
                MenuEngine.this.listener.onMenuItem(menuItem);
            }
        }
    }

    private class LocalGroupListener
    implements GroupListener {
        private LocalGroupListener() {
        }

        @Override
        public void onGroup(ServiceType serviceType, int level) {
            MenuEngine.this.onGroup(serviceType, level);
        }
    }
}

