/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import ru.softlogic.reference.References;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.system.util.PathUtils;

class MenuConfig {
    private static final String GROUP = "group";
    private static final String SERVICE = "service";
    private static final int ROOT = 0;
    private static Properties properties;

    private MenuConfig() {
    }

    public static String getLayerCode(ServiceType st, int deep) {
        if (st.getScreenType() != null) {
            return st.getScreenType().getCode();
        }
        if (deep == 0 && References.getMenu() != null && References.getMenu().getScreenType() != null && References.getMenu().getScreenType().getCode() != null && !References.getMenu().getScreenType().getCode().isEmpty()) {
            return References.getMenu().getScreenType().getCode();
        }
        return MenuConfig.getConfuguredLayerCode(deep);
    }

    public static String getConfuguredLayerCode(int deep) {
        MenuConfig.loadProperties();
        switch (deep) {
            case 0: {
                return properties.getProperty("layer.face", GROUP);
            }
            case 1: {
                return properties.getProperty("layer.group", SERVICE);
            }
        }
        return properties.getProperty("layer.group2x", SERVICE);
    }

    public static String getDefaultLayerCode(int deep) {
        return deep == 0 ? GROUP : SERVICE;
    }

    private static synchronized void loadProperties() {
        if (properties == null) {
            properties = new Properties();
            try (FileInputStream is = new FileInputStream(PathUtils.getPath((String)"/res/module/menu/menu.properties"));){
                properties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

