/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.app.FxEnv;
import fxterm.core.menu.utils.ButtonInitFactory;
import fxterm.module.entry.menu.GroupComparable;
import fxterm.module.entry.menu.KeyComparable;
import fxterm.module.entry.menu.rotator.HotKeyRotator;
import fxterm.module.entry.menu.rotator.ServiceRotator;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import plfx.controller.page.PageListener;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.button.MenuButtonInit;
import ru.softlogic.reference.service.ServiceType;

public class LayerData
implements PageListener {
    private final LayerData parent;
    private final ServiceType type;
    private final MenuTemplate menuTemplate;
    private final List<KeyComparable> hotButtons;
    private final List<GroupComparable> groupButtons;
    private final List<KeyComparable> mixedButtons;
    private int pageNo = 0;
    private int pageCount = 0;
    private ServiceType selectedGroup;

    public LayerData(LayerData parent, ServiceType type, MenuTemplate menuTemplate, List<KeyComparable> hotButtons, List<GroupComparable> groupButtons, List<KeyComparable> mixedButtons) {
        this.parent = parent;
        this.type = type;
        this.menuTemplate = menuTemplate;
        this.hotButtons = hotButtons;
        this.groupButtons = groupButtons;
        this.mixedButtons = mixedButtons;
        int mac = menuTemplate.getMixedArea().getCapacity();
        if (mac > 0) {
            this.pageCount = mixedButtons.size() / mac + (mixedButtons.size() % mac > 0 ? 1 : 0);
        }
    }

    public ServiceType getType() {
        return this.type;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setSelectedGroup(ServiceType selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    public ServiceType getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public MenuTemplate getMenuTemplate() {
        return this.menuTemplate;
    }

    public List<KeyComparable> getHotButtons() {
        return this.hotButtons;
    }

    public List<GroupComparable> getGroupButtons() {
        return this.groupButtons;
    }

    public List<KeyComparable> getMixedButtons() {
        return this.mixedButtons;
    }

    public void reinitScreen() {
        if (this.menuTemplate.getMixedArea().getCapacity() > 0 && this.menuTemplate.getPageController() != null) {
            this.menuTemplate.getPageController().setListener((PageListener)this);
            this.menuTemplate.getPageController().init(this.pageCount, this.pageNo);
        }
        if (this.menuTemplate.getLangController() != null) {
            this.menuTemplate.getLangController().init(Session.getLang(), Session.getLangs());
        }
        this.menuTemplate.setGroupLogo(this.type.getImage());
        this.refreshButtons();
    }

    public void onPage(int id) {
        this.pageNo = id;
        this.refreshButtons();
        FxEnv.refreshScreen();
    }

    private void refreshButtons() {
        int mc;
        HashMap<String, Map<String, String>> messages = new HashMap<String, Map<String, String>>();
        messages.put("current_group", ButtonInitFactory.createI18nMap(this.type));
        if (this.menuTemplate.getHotArea().getCapacity() > 0) {
            List<KeyComparable> comparables = HotKeyRotator.getInstance().handleButtons(this.hotButtons, this.menuTemplate.getHotArea().getCapacity());
            this.fillButtonArea(this.menuTemplate.getHotArea(), ServiceRotator.getInstance().handleButtons(comparables), messages, "hot");
        }
        if (this.menuTemplate.getGroupArea().getCapacity() > 0) {
            this.fillButtonArea(this.menuTemplate.getGroupArea(), ServiceRotator.getInstance().handleButtons(this.groupButtons), messages, "group");
        }
        if (this.menuTemplate.getPrevGroupArea().getCapacity() > 0 && this.parent != null) {
            this.fillParentButtonArea(this.menuTemplate.getPrevGroupArea(), messages, "prevgroup");
        }
        if ((mc = this.menuTemplate.getMixedArea().getCapacity()) > 0) {
            this.fillButtonArea(this.menuTemplate.getMixedArea(), ServiceRotator.getInstance().handleButtons(this.mixedButtons.subList(this.pageNo * mc, Math.min((this.pageNo + 1) * mc, this.mixedButtons.size()))), messages, "mixed");
        }
        Session.setMenuTitles(messages);
    }

    private void fillButtonArea(ButtonArea buttonArea, List<? extends KeyComparable> buttons, Map<String, Map<String, String>> messages, String id) {
        if (buttons == null) {
            return;
        }
        LinkedList<MenuButtonInit> inits = new LinkedList<MenuButtonInit>();
        for (int i = 0; i < buttons.size() && i < buttonArea.getCapacity(); ++i) {
            MenuButtonInit mbi = buttons.get(i).createButtonInit(id + i);
            messages.put(id + i, mbi.getTexts());
            inits.add(mbi);
        }
        buttonArea.fill(inits);
    }

    private void fillParentButtonArea(ButtonArea buttonArea, Map<String, Map<String, String>> messages, String id) {
        List<GroupComparable> buttons = this.parent.getGroupButtons();
        ServiceType pst = this.parent.getSelectedGroup();
        LinkedList<MenuButtonInit> inits = new LinkedList<MenuButtonInit>();
        for (int i = 0; i < buttons.size() && i < buttonArea.getCapacity(); ++i) {
            GroupComparable gc = buttons.get(i);
            MenuButtonInit mbi = gc.getServiceType().equals((Object)pst) ? gc.createButtonInit(id + 1, "default-prevgroup-pressed") : gc.createButtonInit(id + 1, "default-prevgroup");
            messages.put(id + i, mbi.getTexts());
            inits.add(mbi);
        }
        buttonArea.fill(inits);
    }

    public String toString() {
        return "LayerData{type=" + this.type.getName() + ", hot-cnt=" + this.hotButtons.size() + ", group-cnt=" + this.groupButtons.size() + ", mixed-cnt=" + this.mixedButtons.size() + ", page-cnt=" + this.pageCount + ", page-no=" + this.pageNo + '}';
    }
}

