/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.menu;

import fxterm.core.menu.utils.ButtonInitFactory;
import fxterm.module.entry.menu.BaseActionListener;
import fxterm.module.entry.menu.GroupListener;
import fxterm.module.entry.menu.KeyComparable;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import ru.softlogic.reference.service.ServiceType;

public class GroupComparable
implements KeyComparable {
    private final ServiceType st;
    private final int level;
    private final GroupListener listener;

    public GroupComparable(ServiceType st, int level, GroupListener listener) {
        if (st == null) {
            throw new NullPointerException("ServiceType is null");
        }
        if (listener == null) {
            throw new NullPointerException("GroupListener is null");
        }
        this.st = st;
        this.level = level;
        this.listener = listener;
    }

    public ServiceType getServiceType() {
        return this.st;
    }

    @Override
    public Short getHotPosition() {
        return this.st.getHotkeyPosition();
    }

    @Override
    public short getSortOrder() {
        return this.st.getSortOrder();
    }

    public MenuButtonInit createButtonInit(String id, String style) {
        return ButtonInitFactory.createButtonInit(this.st, style, (ActionListener)new BaseActionListener(){

            @Override
            protected void onActionImpl() {
                GroupComparable.this.listener.onGroup(GroupComparable.this.st, GroupComparable.this.level);
            }
        });
    }

    @Override
    public MenuButtonInit createButtonInit(String id) {
        return ButtonInitFactory.createButtonInit(this.st, null, (ActionListener)new BaseActionListener(){

            @Override
            protected void onActionImpl() {
                GroupComparable.this.listener.onGroup(GroupComparable.this.st, GroupComparable.this.level);
            }
        });
    }

    public String toString() {
        return "GroupComparable{st=" + this.st + '}';
    }
}

