/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry.lock;

import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.state.StateFacade;
import fxterm.core.state.TerminalState;
import fxterm.core.timer.Timer;
import fxterm.module.Intent;
import fxterm.module.ModuleStore;
import fxterm.module.entry.EntryBarcodeListener;
import fxterm.module.entry.lock.LockModule;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.utility.UtilityModule;
import fxterm.module.utility.UtilityModuleFactory;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.input.keyboard.KeyboardListener;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.utility.lock.LockScreen;
import plfx.screen.utility.lock.LockScreenFactory;
import plfx.shell.ScreenModule;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;

public class DefaultLockModule
implements LockModule {
    private ScreenModule sm;
    private TerminalState lastState;
    private LockScreen screen;
    private long lastClick;
    private String pin;
    private final Logger log = LoggerId.UTILITY;
    private final BarcodeListener listener = new EntryBarcodeListener();

    public DefaultLockModule(ScreenModule sm) {
        if (sm == null) {
            throw new NullPointerException("Shell");
        }
        this.sm = sm;
    }

    @Override
    public void start() {
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)"Run lock module");
        this.pin = "";
        ModuleStore.setModule(this);
        try {
            if (this.screen == null) {
                this.screen = LockScreenFactory.createLockScreen();
            }
        }
        catch (ScreenCreateException ex) {
            this.log.info((Object)"Error on create lock screen", (Throwable)ex);
            return;
        }
        this.screen.setKeyboardListener((KeyboardListener)new LocalKeyboardListener());
        this.screen.setScreenListener((ScreenListener)new LocalScreenListener());
        this.sm.show(this.screen.getTemplate());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getInactivityTimeout() {
        return 1;
    }

    @Override
    public void cancel(Intent intent) {
        TerminalState state = StateFacade.getState();
        if (this.lastState == null || this.lastState.getErrorCode() != state.getErrorCode()) {
            this.log.info((Object)("State was changed: " + this.lastState + "->" + state + ", go to main menu"));
            this.lastState = state;
            intent.process();
        }
    }

    @Override
    public BarcodeListener getBarcodeScannerListener() {
        return this.listener;
    }

    private class LocalScreenListener
    extends BaseScreenListener {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        }
    }

    private class LocalKeyboardListener
    implements KeyboardListener {
        private LocalKeyboardListener() {
        }

        public void onKeyPress(char key) {
            DefaultLockModule.this.log.info((Object)("Press key: " + key));
            long current = Timer.currentSec();
            if (current - DefaultLockModule.this.lastClick > 5L) {
                DefaultLockModule.this.pin = "" + key;
            } else {
                DefaultLockModule.this.pin = DefaultLockModule.this.pin + "" + key;
            }
            DefaultLockModule.this.lastClick = current;
            DefaultLockModule.this.log.info((Object)("Current pin: " + DefaultLockModule.this.pin));
            if (DefaultLockModule.this.pin.length() == 4) {
                String value = "1643";
                Point p = References.getPoint();
                if (p != null && p.getSecretPhone() != null && p.getSecretPhone().length() >= 4) {
                    value = p.getSecretPhone().substring(0, 4);
                }
                DefaultLockModule.this.log.info((Object)("Etalon value: " + value));
                if (DefaultLockModule.this.pin.equals(value)) {
                    DefaultLockModule.this.log.info((Object)"Try to open service menu");
                    try {
                        UtilityModule um = UtilityModuleFactory.getModule(2);
                        um.start(null);
                    }
                    catch (ModuleCreateException ex) {
                        GuiNotifier.notifyError((Throwable)ex);
                    }
                } else {
                    DefaultLockModule.this.log.error((Object)"Pin-code is wrong");
                    DefaultLockModule.this.pin = "";
                }
            }
        }

        public void onClear() {
        }

        public void onClearLast() {
        }

        public void onCancel() {
        }

        public void onEnter() {
        }
    }
}

