/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.entry;

import fxterm.app.id.LoggerId;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.MenuByBarcodeVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.utility.UtilityModuleFactory;
import fxterm.session.Session;
import java.util.HashMap;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.menu.MenuItem;

public class EntryBarcodeListener
implements BarcodeListener {
    private final Logger log = LoggerId.PAY;

    public void onBarcode(String data) {
        this.log.info((Object)("Barcode obtained in entry module: " + data));
        if (data.matches("([a-zA-Z#]){3,}(\\d){2}") && this.checkCrc(data)) {
            this.log.info((Object)"Use system function");
            String[] fields = data.split("#");
            if ("con".equals(fields[0])) {
                HashMap<String, Object> crd = new HashMap<String, Object>();
                crd.put("login", new InputElement("login", "login", fields[1]));
                crd.put("password", new InputElement("password", "password", fields[2]));
                UtilityModuleFactory.runQuietly(2, crd);
            } else {
                this.log.error((Object)"Wrong barcode");
            }
        } else {
            data = data.trim();
            MenuByBarcodeVisitor bv = new MenuByBarcodeVisitor(data);
            this.log.info((Object)("OMenuByBarcodeVisitor :" + bv.getItems()));
            MenuUtils.processMenu(bv);
            if (!bv.getItems().isEmpty()) {
                this.log.info((Object)("Open menu item from EntryBarcodeListener:" + bv.getItems().get(0)));
                MenuItem menuItem = bv.getItems().get(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("barcode", data);
                Launcher.open(menuItem, map, Session.getPayEnv().getKeeper());
            } else {
                this.log.error((Object)"Wrong barcode");
            }
        }
    }

    private boolean checkCrc(String data) {
        return true;
    }
}

