/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.card;

import fxterm.core.activity.ActivityMonitor;
import fxterm.module.card.ProxyBankModuleResultListener;
import fxterm.module.card.ProxyCardModuleResultListener;
import fxterm.module.card.ProxyUserInterfaceEventListener;
import fxterm.module.card.ReverseTask;
import fxterm.session.FileControl;
import fxterm.session.Session;
import java.io.File;
import java.util.ResourceBundle;
import plfx.GuiNotifier;
import plfx.shell2.wait.WaitModule;
import ru.softlogic.cards.v2.connector.model.OperationDepositResult;
import ru.softlogic.cards.v2.module.BankModuleResultListener;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleManager;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cards.v2.module.UserInterfaceEventListener;
import ru.softlogic.system.util.PathUtils;

public class CardModuleHandler {
    private final CardModuleManager manager;
    private CardModule cm;
    private ActivityMonitor activityMonitor;
    private WaitModule waitModule;
    private static final File bundlePath = PathUtils.getFilePath((String)"/res/module/input/card/i18n/");
    private CashRequireListener cashRequireListener;
    private CashRequireListener bankCashRequireListener;
    private final ProxyUserInterfaceEventListener userInterfaceEventListener;
    private final ProxyCardModuleResultListener<OperationDepositResult> operationDepositResultListener;
    private final ProxyBankModuleResultListener<OperationDepositResult> bankModuleResultListener;

    public CardModuleHandler(CardModuleManager manager) {
        this.manager = manager;
        this.userInterfaceEventListener = new ProxyUserInterfaceEventListener();
        this.operationDepositResultListener = new ProxyCardModuleResultListener();
        this.bankModuleResultListener = new ProxyBankModuleResultListener();
    }

    public boolean isInit() {
        return this.manager != null;
    }

    public boolean isReady() {
        return this.manager.getCardModuleManagerState() == CardModuleManager.CardModuleManagerState.Ready;
    }

    public boolean isNeedReverse() {
        return this.manager.getCardModuleManagerState() == CardModuleManager.CardModuleManagerState.NeedReverse;
    }

    public CardModule openSession(UserInterfaceEventListener listener) {
        if (this.manager == null) {
            return null;
        }
        if (this.isNeedReverse()) {
            new Thread(new ReverseTask()).start();
        }
        this.userInterfaceEventListener.setListener(listener);
        this.cm = this.manager.openSession((UserInterfaceEventListener)this.userInterfaceEventListener);
        return this.cm;
    }

    public CardModule getCurrentSession() {
        return this.cm;
    }

    public void closeOperation() {
        this.cm.cancelOperation();
    }

    public void closeSession(boolean clean) {
        if (this.cm != null) {
            this.cm.closeSession(clean);
            this.cm = null;
        }
    }

    public boolean reverse() {
        if (this.manager != null) {
            return this.manager.reverseLast();
        }
        return true;
    }

    public void onAction() {
        if (this.activityMonitor != null) {
            this.activityMonitor.update();
        }
    }

    public CashRequireListener getCashRequireListener() {
        return this.cashRequireListener;
    }

    public void setCashRequireListener(CashRequireListener cashRequireListener) {
        this.cashRequireListener = cashRequireListener;
    }

    public CashRequireListener getBankCashRequireListener() {
        return this.bankCashRequireListener;
    }

    public void setBankCashRequireListener(CashRequireListener bankCashRequireListener) {
        this.bankCashRequireListener = bankCashRequireListener;
    }

    public UserInterfaceEventListener getUserInterfaceEventListener() {
        return this.userInterfaceEventListener;
    }

    public void setUserInterfaceEventListener(UserInterfaceEventListener userInterfaceEventListener) {
        this.userInterfaceEventListener.setListener(userInterfaceEventListener);
    }

    public CardModuleResultListener<OperationDepositResult> getOperationDepositResultListener() {
        return this.operationDepositResultListener;
    }

    public void setOperationDepositResultListener(CardModuleResultListener<OperationDepositResult> operationDepositResultListener) {
        this.operationDepositResultListener.setListener(operationDepositResultListener);
    }

    public BankModuleResultListener<OperationDepositResult> getBankModuleResultListener() {
        return this.bankModuleResultListener;
    }

    public void setBankModuleResultListener(BankModuleResultListener<OperationDepositResult> bankModuleResultListener) {
        this.bankModuleResultListener.setListener(bankModuleResultListener);
    }

    public void addActivityMonitor(ActivityMonitor activityMonitor) {
        this.activityMonitor = activityMonitor;
    }

    public ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    public void setActivityMonitor(ActivityMonitor activityMonitor) {
        this.activityMonitor = activityMonitor;
    }

    public WaitModule getWaitModule() {
        return this.waitModule;
    }

    public void setWaitModule(WaitModule waitModule) {
        this.waitModule = waitModule;
    }

    public static String getMessage(String id) {
        String msg = id;
        if (bundlePath.exists()) {
            try {
                msg = ResourceBundle.getBundle("message", Session.getLocale(), new FileControl(bundlePath)).getString(id);
            }
            catch (Exception ex) {
                GuiNotifier.notifyProblemOnce((String)("Wrong bundle in CardModuleHandler by key : " + id + ", " + ex.getMessage()));
            }
        }
        return msg;
    }

    public void closeDay() {
        if (this.cm != null) {
            this.cm.closeBusinessDay();
        }
    }
}

