/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.module.PaymentModules;
import fxterm.module.input.InputModuleFactory;
import fxterm.module.input.ModuleCreateException;
import fxterm.module.paytpl.LoadPayTplModule;
import fxterm.module.paytpl.LoadPayTplModuleStub;
import fxterm.module.paytpl.SavePayTplModule;
import fxterm.module.paytpl.SavePayTplModuleStub;
import fxterm.module.stage.ending.EndingModule;
import fxterm.module.stage.ending.SimpleEndingModule;
import fxterm.module.stage.payment.DispatchPaymentModule;
import fxterm.module.stage.payment.PaymentModule;
import fxterm.module.stage.payout.AfterPayoutModule;
import fxterm.module.stage.payout.BeforePayoutModule;
import fxterm.module.stage.payout.PayoutModule;
import fxterm.module.stage.present.PresentModule;
import fxterm.module.stage.present.VoidPresentModule;
import fxterm.module.stage.print.ObsoletePrintModule;
import fxterm.module.stage.print.PrintModule;
import fxterm.module.stage.processing.ObsoleteProcessingModule;
import fxterm.module.stage.processing.ProcessingModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import plfx.GuiNotifier;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceModules;

public class PaymentModulesFactory {
    private static final Map<String, PaymentModule> paymentModules = new HashMap<String, PaymentModule>();
    private static final Map<String, PayoutModule> beforePayoutModules = new HashMap<String, PayoutModule>();
    private static final Map<String, PayoutModule> afterPayoutModules = new HashMap<String, PayoutModule>();
    private static final Map<String, PrintModule> printModules = new HashMap<String, PrintModule>();
    private static final Map<String, ProcessingModule> processingModules = new HashMap<String, ProcessingModule>();
    private static final Map<String, PresentModule> presentModules = new HashMap<String, PresentModule>();
    private static final Map<String, EndingModule> endingModules = new HashMap<String, EndingModule>();
    private static final Map<String, LoadPayTplModule> loadPayTplModules = new HashMap<String, LoadPayTplModule>();
    private static final Map<String, SavePayTplModule> savePayTplModules = new HashMap<String, SavePayTplModule>();
    private static final PaymentModule defaultPaymentModule = new DispatchPaymentModule();
    private static final PayoutModule defaultBeforePayoutModule = new BeforePayoutModule();
    private static final PayoutModule defaultAfterPayoutModule = new AfterPayoutModule();
    private static final PrintModule defaultPrintModule = new ObsoletePrintModule();
    private static final ProcessingModule defaultProcessingModule = new ObsoleteProcessingModule();
    private static final PresentModule defaultPresentModule = new VoidPresentModule();
    private static final EndingModule defaultEndingModule = new SimpleEndingModule();
    private static final LoadPayTplModule loadPayTplModuleStub = new LoadPayTplModuleStub();
    private static final SavePayTplModule savePayTplModuleStub = new SavePayTplModuleStub();

    public static PaymentModules createModules(Service service) throws ModuleCreateException {
        PaymentModules modules = new PaymentModules();
        modules.setInputModule(InputModuleFactory.getModule(service.getProviderType()));
        modules.setPaymentModule(PaymentModulesFactory.createPaymentModule(service));
        modules.setBeforePayoutModule(PaymentModulesFactory.createBeforePayoutModules(service));
        modules.setAfterPayoutModule(PaymentModulesFactory.createAfterPayoutModules(service));
        modules.setPrintModule(PaymentModulesFactory.createPrintModule(service));
        modules.setProcessingModule(PaymentModulesFactory.createProcessingModule(service));
        modules.setPresentModule(PaymentModulesFactory.createPresentModule(service));
        modules.setEndingModule(PaymentModulesFactory.createEndingModule(service));
        modules.setLoadPaymentTemplateModule(PaymentModulesFactory.createLoadPaymentTemplateModule());
        modules.setSavePaymentTemplateModule(PaymentModulesFactory.createSavePaymentTemplateModule());
        return modules;
    }

    private static PaymentModule createPaymentModule(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getPayment).filter(Predicate.isEqual("").negate()).map(name -> {
            if (paymentModules.get(name) == null) {
                try {
                    paymentModules.put((String)name, (PaymentModule)Class.forName("fxterm.module.stage.payment." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return paymentModules.get(name);
        }).orElse(defaultPaymentModule);
    }

    private static PayoutModule createBeforePayoutModules(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getPrePayout).filter(Predicate.isEqual("").negate()).map(name -> {
            if (beforePayoutModules.get(name) == null) {
                try {
                    beforePayoutModules.put((String)name, (PayoutModule)Class.forName("fxterm.module.stage.payout." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return beforePayoutModules.get(name);
        }).orElse(defaultBeforePayoutModule);
    }

    private static PayoutModule createAfterPayoutModules(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getPostPayout).filter(Predicate.isEqual("").negate()).map(name -> {
            if (afterPayoutModules.get(name) == null) {
                try {
                    afterPayoutModules.put((String)name, (PayoutModule)Class.forName("fxterm.module.stage.payout." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return afterPayoutModules.get(name);
        }).orElse(defaultAfterPayoutModule);
    }

    private static PrintModule createPrintModule(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getPrint).filter(Predicate.isEqual("").negate()).map(name -> {
            if (printModules.get(name) == null) {
                try {
                    printModules.put((String)name, (PrintModule)Class.forName("fxterm.module.stage.print." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return printModules.get(name);
        }).orElse(defaultPrintModule);
    }

    private static ProcessingModule createProcessingModule(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getProcess).filter(Predicate.isEqual("").negate()).map(name -> {
            if (processingModules.get(name) == null) {
                try {
                    processingModules.put((String)name, (ProcessingModule)Class.forName("fxterm.module.stage.processing." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return processingModules.get(name);
        }).orElse(defaultProcessingModule);
    }

    private static PresentModule createPresentModule(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getPresent).filter(Predicate.isEqual("").negate()).map(name -> {
            if (presentModules.get(name) == null) {
                try {
                    presentModules.put((String)name, (PresentModule)Class.forName("fxterm.module.stage.present." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return presentModules.get(name);
        }).orElse(defaultPresentModule);
    }

    private static EndingModule createEndingModule(Service service) {
        return Optional.ofNullable(service.getModules()).map(ServiceModules::getEnding).filter(Predicate.isEqual("").negate()).map(name -> {
            if (endingModules.get(name) == null) {
                try {
                    endingModules.put((String)name, (EndingModule)Class.forName("fxterm.module.stage.ending." + name).newInstance());
                }
                catch (ReflectiveOperationException throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                }
            }
            return endingModules.get(name);
        }).orElse(defaultEndingModule);
    }

    private static LoadPayTplModule createLoadPaymentTemplateModule() {
        try {
            if (loadPayTplModules.get("LoadPayTplModuleImpl") == null) {
                loadPayTplModules.put("LoadPayTplModuleImpl", (LoadPayTplModule)Class.forName("fxterm.module.paytpl.LoadPayTplModuleImpl").newInstance());
            }
        }
        catch (ReflectiveOperationException ex) {
            return loadPayTplModuleStub;
        }
        return loadPayTplModules.get("LoadPayTplModuleImpl");
    }

    private static SavePayTplModule createSavePaymentTemplateModule() {
        try {
            if (savePayTplModules.get("SavePayTplModuleImpl") == null) {
                savePayTplModules.put("SavePayTplModuleImpl", (SavePayTplModule)Class.forName("fxterm.module.paytpl.SavePayTplModuleImpl").newInstance());
            }
        }
        catch (ReflectiveOperationException ex) {
            return savePayTplModuleStub;
        }
        return savePayTplModules.get("SavePayTplModuleImpl");
    }
}

