/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.module.Pack;
import fxterm.module.PayEnvListener;
import java.io.Serializable;
import java.util.Objects;

public class PayEnv
implements Serializable {
    private static final long serialVersionUID = -8213987581374893425L;
    private final NewKeeper2 keeper;
    private NewKeeper2 lastKeeper;
    private Pack packSnapshot;
    private transient PayEnvListener listener;

    public PayEnv(NewKeeper2 keeper, Pack packSnapshot) {
        this.keeper = Objects.requireNonNull(keeper, "Keeper is null");
        this.packSnapshot = packSnapshot;
    }

    public void setListener(PayEnvListener listener) {
        this.listener = Objects.requireNonNull(listener, "Listener is null");
        this.keeper.setListener(listener::onUpdate);
    }

    public NewKeeper2 getKeeper() {
        return this.keeper;
    }

    public Pack getPack() {
        return this.packSnapshot;
    }

    public void setPack(Pack packSnapshot) {
        if (Objects.equals(this.packSnapshot, packSnapshot)) {
            return;
        }
        this.packSnapshot = packSnapshot;
        if (this.listener != null) {
            this.listener.onUpdate();
        }
    }

    public NewKeeper2 getLastKeeper() {
        return this.lastKeeper;
    }

    public void setLastKeeper(NewKeeper2 lastKeeper) {
        if (Objects.equals(this.lastKeeper, lastKeeper)) {
            return;
        }
        this.lastKeeper = lastKeeper;
        if (this.listener != null) {
            this.listener.onUpdate();
        }
    }

    public void save() {
        if (this.listener != null) {
            this.listener.onUpdate();
        }
    }
}

