/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.AppSumFormatter;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.Sequence;
import fxterm.core.hdw.bvr.oper.ActivatedCashBackCard;
import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.timer.Timer;
import fxterm.module.Pack;
import fxterm.module.PayEnv;
import fxterm.module.Payment;
import fxterm.msg.Messages;
import fxterm.session.Change;
import fxterm.session.Session;
import fxterm.utils.CompatUtils;
import fxterm.utils.FinUtils;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.References;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.system.util.PinCodeGenerator;

public class PackUtility {
    private static final Random rnd = new Random();
    private static final Logger log = LoggerId.PAY;

    public static void printPack(String title, Pack pack) {
        Service s = pack.getService();
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Commission c = Session.getCommission();
        InputElement number = pack.getChangeNumber();
        log.info((Object)("----- " + title));
        log.info((Object)PackUtility.changeAsStr());
        log.info((Object)"    ----- ");
        log.info((Object)("    Pack date    : " + pack.getDate()));
        log.info((Object)("    Payment type : " + Messages.getPaymentType(pack.getPaymentType())));
        log.info((Object)("    Payback type : " + Messages.getPaybackType(pack.getPaybackType())));
        log.info((Object)("    Payment tool : " + PackUtility.getPaymentSource(pack.getPaymentTool())));
        log.info((Object)("    Service      : " + (s == null ? "-" : s.getName() + ", " + s.getId())));
        log.info((Object)("    Commission   : " + (c == null ? "-" : PackUtility.commissionAsShortStr(c))));
        log.info((Object)("    Sum result   : " + PackUtility.format(pack.getSumResult())));
        log.info((Object)("    Change number: " + (number != null ? number.getKey() + " -> " + number.getValue() : "-")));
        log.info((Object)("    Provider fee : " + (pack.getProviderFee() == null ? "-" : pack.getProviderFee())));
        pack.getPayments().forEach(PackUtility::printPayment);
        PackUtility.printKeeper(keeper);
        if (Session.getPaymentEndingState() != null) {
            log.info((Object)("    Is cancel: " + Session.getPaymentEndingState().isCancel()));
        }
        log.info((Object)"<---");
    }

    public static String getToken(Pack pack) {
        InputElement ie = StoreHelper.getElement((String)"id1", pack.getPayments().get(0).getData());
        return "sid: " + Session.getService().getId() + (ie != null ? ", " + ie.getValue() : "");
    }

    public static void printPayment(Payment payment) {
        if (payment == null) {
            return;
        }
        log.info((Object)("    Payment: id=" + payment.getId() + ", doc=" + payment.getDoc() + ", date=" + payment.getDate()));
        log.info((Object)("        Operation sum  : " + AppSumFormatter.asStr(payment.getOperationSum())));
        log.info((Object)("        Amount         : " + AppSumFormatter.asStr(payment.getSumOut())));
        log.info((Object)("        Commission     : " + AppSumFormatter.asStr(payment.getSumComm())));
        log.info((Object)"        Data:");
        if (payment.getData() != null) {
            payment.getData().values().stream().filter(Objects::nonNull).forEach(o -> {
                if (o instanceof InputElement) {
                    InputElement ie = (InputElement)o;
                    log.info((Object)("        " + ie.getKey() + ":" + ie.getKeyTitle() + " = " + ie.getValue() + ":" + ie.getValueTitle()));
                } else {
                    String line = o.toString();
                    if (line.length() > 100) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("        " + line));
                        } else {
                            log.info((Object)("        " + line.substring(0, 100) + "..."));
                        }
                    } else {
                        log.info((Object)("        " + line));
                    }
                }
            });
        }
        log.info((Object)"    *");
    }

    public static void printKeeper(NewKeeper2 keeper) {
        if (keeper == null) {
            log.info((Object)"    Keeper is not set");
            return;
        }
        if (keeper.isEmpty()) {
            log.info((Object)("    Keeper content(" + keeper.getCurrency() + "): empty"));
        } else {
            DenominationSet content;
            BoxId box;
            Map<BoxId, DenominationSet> v;
            log.info((Object)("    Keeper content(" + keeper.getCurrency() + "): "));
            if (!keeper.isInEmpty()) {
                log.info((Object)"        Input:");
                if (!keeper.getIncome().isEmpty()) {
                    log.info((Object)("            In sum: " + AppSumFormatter.asStr(keeper.getIncome())));
                }
                log.info((Object)"            Denominations: ");
                v = keeper.getInputCash();
                if (!v.isEmpty()) {
                    for (Map.Entry<BoxId, DenominationSet> e : v.entrySet()) {
                        box = e.getKey();
                        log.info((Object)("      " + box));
                        content = e.getValue();
                        for (Map.Entry counts : content.getCounts().entrySet()) {
                            log.info((Object)("               " + counts.getKey() + "->" + counts.getValue()));
                        }
                    }
                    log.info((Object)("                TOTAL: " + AppSumFormatter.asStr(keeper.getInCashSum())));
                } else {
                    log.info((Object)"            -");
                }
                if (!keeper.getInputCards().isEmpty()) {
                    log.info((Object)"        Cash back cards: ");
                    for (ActivatedCashBackCard acbc : keeper.getInputCards()) {
                        log.info((Object)("         " + acbc));
                    }
                    log.info((Object)("        Cash back cards total: " + keeper.getInCashlessSum()));
                }
                log.info((Object)("        Input total: " + AppSumFormatter.asStr(keeper.getInSumTotal())));
            }
            if (!keeper.isOutEmpty()) {
                log.info((Object)"    Output:");
                v = keeper.getOutputCash();
                if (!v.isEmpty()) {
                    for (Map.Entry<BoxId, DenominationSet> e : v.entrySet()) {
                        box = e.getKey();
                        log.info((Object)("      " + box));
                        content = e.getValue();
                        for (Map.Entry contentEntry : content.getCounts().entrySet()) {
                            log.info((Object)("         " + contentEntry.getKey() + "->" + contentEntry.getValue()));
                        }
                    }
                }
                log.info((Object)"        Issued cash back card: ");
                log.info((Object)("            " + (keeper.getIssuedCard() == null ? "-" : keeper.getIssuedCard())));
                log.info((Object)("        Output total: " + AppSumFormatter.asStr(keeper.getOutSumTotal())));
            }
            log.info((Object)("    KEEPER TOTAL: " + AppSumFormatter.asStr(keeper.getSum()) + "(the difference between in & out sums)"));
        }
    }

    public static String changeAsStr() {
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        Pack pack = Session.getPayEnv().getPack();
        if (keeper == null || pack == null || keeper.getInCashSum() == null) {
            return "    Change: -";
        }
        Date changeDate = pack.getChangeDate();
        return "    Change: sum=" + AppSumFormatter.asStr(keeper.getInCashSum()) + ", date=" + (changeDate != null ? changeDate : "-") + (changeDate != null ? "(" + changeDate.getTime() + ")" : "");
    }

    public static String format(SumResult sumResult) {
        if (sumResult == null) {
            return "-";
        }
        String inc = AppSumFormatter.asStr(sumResult.getCash());
        String inl = AppSumFormatter.asStr(sumResult.getCashLess());
        String out = AppSumFormatter.asStr(sumResult.getOut());
        String oup = AppSumFormatter.asStr(sumResult.getOutProv());
        String cha = AppSumFormatter.asStr(sumResult.getChange());
        String com = AppSumFormatter.asStr(sumResult.getCommission());
        return "out=" + out + ", out prov=" + oup + ", comm=" + com + ", change=" + cha + ", cash in=" + inc + ", cashless in=" + inl;
    }

    public static String commissionAsShortStr(Commission c) {
        return "    Commission{id=" + c.getId() + ", name=" + c.getName() + ", type=" + c.getType() + ", min=" + c.getMin() + ", max=" + c.getMax() + ", steps=" + (c.getSteps() == null || c.getSteps().isEmpty() ? "no steps" : "has steps") + ", units=" + (c.getUnits() == null || c.getUnits().isEmpty() ? "no units" : "has units") + ", nominals=" + (c.getNominals() == null || c.getNominals().isEmpty() ? "no nominals" : "has nominals") + ", percentValue=" + c.getPercentValue() + ", fixedValue=" + c.getFixedValue() + ", currencyCode=" + c.getCurrencyCode() + '}';
    }

    public static List<Sum> getPaymentSums(List<Payment> payments) {
        if (payments == null || payments.size() < 2) {
            return null;
        }
        List<Sum> sums = payments.stream().filter(p -> p.getOperationSum() != null && !p.getOperationSum().isEmpty()).map(Payment::getOperationSum).collect(Collectors.toList());
        return sums.isEmpty() ? null : sums;
    }

    public static List<Sum> getDivideSums(Sum opr, Sum div) {
        Sum total = new Sum(opr);
        LinkedList<Sum> sums = new LinkedList<Sum>();
        while (total.compareTo(div) > 0) {
            sums.add(div);
            total = total.sub(div);
        }
        sums.add(total);
        return sums;
    }

    public static List<Sum> getRandomDivideSums(Sum opr, Service srv) {
        Sum total = new Sum(opr);
        LinkedList<Sum> sums = new LinkedList<Sum>();
        Sum f = srv.getDivideSumFrom();
        Sum t = srv.getDivideSumTo();
        Sum r = srv.getDivideSumRound();
        while (total.compareTo(t) > 0) {
            Sum tmp = PackUtility.getRandom(f.getValue(), t.getValue(), r, opr.getCurrency());
            sums.add(tmp);
            total = total.sub(tmp);
        }
        sums.add(total);
        return sums;
    }

    public static Sum getRandom(int from, int to, Sum round, String currency) {
        int res = rnd.nextInt(to - from) + from;
        if (round != null && !round.isEmpty()) {
            if ((res = Math.round((float)res / (float)round.getValue()) * round.getValue()) < from) {
                res += round.getValue();
            } else if (res > to) {
                res -= round.getValue();
            }
        }
        return new Sum(res, currency);
    }

    public static void distributeSum(Pack pack, SumResult resultSum) {
        SumResult result = resultSum;
        Sum sum = resultSum.getOut();
        Sum s0 = FinUtils.createVoidSum();
        if ("uniform".equals(pack.getSumDistributionType())) {
            Sum lSum = sum.div((double)pack.getPayments().size());
            for (Payment p : pack.getPayments()) {
                p.setSumOut(lSum);
                sum = sum.sub(lSum);
            }
            if (!sum.isEmpty()) {
                pack.getPayments().get(0).setSumOut(pack.getPayments().get(0).getSumOut().add(sum));
            }
        } else {
            for (Payment p : pack.getPayments()) {
                if (p.getOperationSum() == null || p.getOperationSum().isEmpty()) continue;
                if (sum.isEmpty()) break;
                if (sum.compareTo(p.getOperationSum()) > 0) {
                    p.setSumOut(p.getOperationSum());
                    sum = sum.sub(p.getSumOut());
                    continue;
                }
                p.setSumOut(sum);
                sum = FinUtils.createVoidSum();
            }
            if (resultSum.getChange() == null) {
                result = new SumResult(resultSum.getCash(), resultSum.getCashLess(), resultSum.getOut(), resultSum.getOutProv(), resultSum.getCommission(), s0, resultSum.getProviderFee());
            }
            if (!sum.isEmpty()) {
                if ("default".equals(pack.getSumDistributionType())) {
                    result = new SumResult(resultSum.getCash(), resultSum.getCashLess(), resultSum.getOut(), resultSum.getOutProv(), resultSum.getCommission(), resultSum.getChange().add(sum), resultSum.getProviderFee());
                } else {
                    pack.getPayments().get(0).setSumOut(pack.getPayments().get(0).getSumOut().add(sum));
                }
            }
            LinkedList<Payment> newPayments = new LinkedList<Payment>();
            for (Payment p : pack.getPayments()) {
                if (p.getSumOut() == null || p.getSumOut().isEmpty()) continue;
                newPayments.add(p);
            }
            pack.setPayments(newPayments);
            pack.setSumResult(result);
        }
    }

    public static Operation convert(Pack pack) {
        return PackUtility.convert(pack, false);
    }

    private static Operation convert(Pack pack, boolean useLastKeeper) {
        Short paperRequire;
        Service service = pack.getService();
        Payment payment = pack.getPayments().get(0);
        Operation operation = new Operation();
        operation.setFeHash(FinUtils.getFeHash());
        operation.setService(service);
        operation.setCommission(pack.getCommission());
        operation.setIdOperation(payment.getId());
        operation.setCheckNumber(payment.getDoc());
        operation.setDate(pack.getDate());
        operation.setTime(Timer.currentSec());
        operation.setDealer(Session.getDealer());
        operation.setPoint(Session.getPoint());
        operation.setPaymentSystem(Session.getPaymentSystem());
        operation.setServiceType(pack.getServiceType());
        operation.setPaymentTool(pack.getPaymentTool());
        PackUtility.processKeeper(pack, operation, useLastKeeper);
        operation.setLocale(Session.getLocale());
        operation.setChangeDate(pack.getChangeDate());
        operation.setFraudControlRule(pack.getFraudControlRule());
        PackUtility.fillOperationFormsViewsTitlesIes(operation, StoreHelper.clear(payment.getData()).values());
        int flags = 0;
        if (Session.isPrinterError()) {
            flags |= 1;
            if (service.getPaperRequire() == 4) {
                flags |= 0x200;
            }
        }
        if ((paperRequire = service.getPaperRequire()) != null && paperRequire == 3) {
            flags |= 0x200;
        }
        if (service.isFlagExist(256L)) {
            flags |= 0x20;
        }
        if (service.getProcessingType() == ProcessingType.Online || service.getProcessingType() == ProcessingType.HalfOnline) {
            flags |= 0x10;
        }
        if (pack.isFraud()) {
            flags |= 0x40;
        }
        if (pack.isZeroAmount()) {
            flags |= 0x400;
        }
        if (pack.isFixedSum()) {
            flags |= 0x800;
        }
        operation.setFlags(flags);
        return operation;
    }

    public static Operation createMobileChange(Pack pack) {
        Operation operation = new Operation();
        operation.setFeHash(FinUtils.getFeHash());
        operation.setService(pack.getPaybackService());
        operation.setCommission(new Commission(1));
        operation.setPaymentTool(pack.getPaymentTool());
        operation.setIdOperation(Sequence.getOperationId());
        operation.setCheckNumber(rnd.nextInt(32000));
        operation.setDate(new Date());
        operation.setTime(Timer.currentSec());
        operation.setChangeDate(pack.getDate());
        operation.setDealer(Session.getDealer());
        operation.setPoint(Session.getPoint());
        operation.setPaymentSystem(Session.getPaymentSystem());
        Sum s0 = new Sum(0, Session.getPayEnv().getKeeper().getCurrency());
        Sum sch = pack.getSumResult().getChange().sub(pack.getSumResult().getDonate());
        SumResult sr = new SumResult(s0, sch, sch, sch, s0, s0, pack.getProviderFee());
        operation.setSumResult(sr);
        if (SystemProp.isChangeMobileUseMenuComm()) {
            Commission personal;
            Commission comm;
            SumResult srm;
            MenuByServiceIdVisitor v = new MenuByServiceIdVisitor(pack.getPaybackService().getId());
            MenuUtils.processMenu(v);
            if (v.getMenuItem() != null && !v.getMenuItem().getService().equals((Object)pack.getService()) && !(srm = BaseCommissionCalculator.calculate(s0, sch, null, comm = Optional.ofNullable(personal = PackUtility.getPersonalCommission(pack.getPaybackService(), pack.getPaybackData())).orElse(v.getMenuItem().getCommission()), v.getMenuItem().getService(), v.getMenuItem().isIgnoreMinMaxCommission(), null, v.getMenuItem().getService().getMaxSum(), pack.getProviderFee())).getOut().isEmpty() && srm.getChange().isEmpty()) {
                operation.setSumResult(srm);
                operation.setCommission(comm);
            }
        }
        InputElement pbd = pack.getPaybackData();
        String account = "id1";
        InputElement tmp = new InputElement(pbd);
        tmp.setKey(account);
        operation.getInputElements().put(tmp.getKey(), tmp);
        operation.getForm().put(account, pbd.getValue());
        operation.getViews().put(account, pbd.getValueTitle());
        operation.getTitles().put(account, pbd.getKeyTitle());
        operation.setLocale(Session.getLocale());
        Keeper chKeeper = new Keeper();
        chKeeper.addPayback(sch);
        operation.setKeeper(chKeeper);
        if (pack.isChangeToSafeService()) {
            operation.setFlags(256);
        }
        operation.setChange(new Keeper());
        operation.setFraudControlRule(pack.getFraudControlRule());
        return operation;
    }

    public static Commission getPersonalCommission(Service s, InputElement ie) {
        Short sid = s != null ? Short.valueOf(s.getId()) : null;
        PersonalNumber[] numbers = References.getPersonalNumbers();
        if (numbers != null) {
            for (PersonalNumber pn : numbers) {
                if (pn.getType() != PersonalNumberType.White || sid != null && sid.shortValue() != pn.getService() || !pn.getNumber().equals(ie.getValue())) continue;
                return pn.getCommission();
            }
        }
        return null;
    }

    public static Operation createDonateChange(Pack pack) {
        Operation operation = new Operation();
        operation.setFeHash(FinUtils.getFeHash());
        operation.setService(Session.getServiceDonate());
        operation.setCommission(new Commission(1));
        operation.setPaymentTool(pack.getPaymentTool());
        operation.setIdOperation(Sequence.getOperationId());
        operation.setCheckNumber(rnd.nextInt(32000));
        operation.setDate(new Date());
        operation.setTime(Timer.currentSec());
        operation.setChangeDate(pack.getDate());
        operation.setDealer(Session.getDealer());
        operation.setPoint(Session.getPoint());
        operation.setPaymentSystem(Session.getPaymentSystem());
        Sum s0 = new Sum(0, Session.getPayEnv().getKeeper().getCurrency());
        Sum sch = pack.getSumResult().getDonate();
        SumResult sr = new SumResult(s0, sch, sch, sch, s0, s0, pack.getProviderFee());
        operation.setSumResult(sr);
        PackUtility.fillOperationFormsViewsTitlesIes(operation, StoreHelper.clear(pack.getPayments().get(0).getData()).values());
        operation.setLocale(Session.getLocale());
        Keeper chKeeper = new Keeper();
        chKeeper.addPayback(pack.getSumResult().getDonate());
        operation.setKeeper(chKeeper);
        operation.setChange(new Keeper());
        operation.setFraudControlRule(pack.getFraudControlRule());
        return operation;
    }

    public static GroupOperation convertGroup(Pack pack) {
        GroupOperation go = new GroupOperation();
        go.setFeHash(FinUtils.getFeHash());
        go.setFraudControlRule(pack.getFraudControlRule());
        LinkedList<ChildOperation> opers = new LinkedList<ChildOperation>();
        boolean commInChild = false;
        Sum s0 = new Sum(0, Session.getPayEnv().getKeeper().getCurrency());
        for (Payment p : pack.getPayments()) {
            InputElement ie;
            Service service = new Service(Session.getService());
            if (p.getData().get("name") != null && p.getData().get("name") instanceof InputElement && (ie = (InputElement)p.getData().get("name")).getValueTitle() != null && !ie.getValueTitle().trim().isEmpty()) {
                service.setPrintName(ie.getValueTitle());
            }
            if (p.getSumComm() != null && !p.getSumComm().isEmpty()) {
                commInChild = true;
            }
            ChildOperation cho = new ChildOperation(service, p.getSumOut(), p.getSumComm(), Integer.valueOf(p.getId()), Integer.valueOf(p.getDoc()));
            PackUtility.fillOperationFormsViewsTitlesIes(cho, StoreHelper.clear(p.getData()).values());
            opers.add(cho);
        }
        go.setChildOperations(opers);
        go.setService(Session.getService());
        go.setCommission(Session.getActiveItem().getCommission());
        go.setIdOperation(pack.getPayments().get(0).getId());
        go.setCheckNumber(pack.getPayments().get(0).getDoc());
        go.setSingleCheck(pack.isPrintByOne());
        PackUtility.processKeeper(pack, (Operation)go);
        go.getInputElements().putAll(((ChildOperation)opers.get(0)).getInputElements());
        go.getForm().putAll(((ChildOperation)opers.get(0)).getForm());
        go.getViews().putAll(((ChildOperation)opers.get(0)).getViews());
        go.getTitles().putAll(((ChildOperation)opers.get(0)).getTitles());
        go.setDate(pack.getDate());
        go.setTime(Timer.currentSec());
        go.setDealer(Session.getDealer());
        go.setLocale(Session.getLocale());
        SumResult sr = go.getSumResult();
        SumResult srNew = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), commInChild ? s0 : sr.getCommission(), sr.getChange(), pack.getProviderFee());
        go.setSumResult(srNew);
        int flags = go.getFlags();
        if (pack.isFraud()) {
            flags |= 0x40;
        }
        if (pack.isZeroAmount()) {
            flags |= 0x400;
        }
        if (pack.isFixedSum()) {
            flags |= 0x800;
        }
        go.setFlags(flags);
        return go;
    }

    public static Pair<Operation, Operation> cancelOnlinePack(Pack pack) {
        FraudControlRule fcr = pack.getFraudControlRule() == null ? new FraudControlRule() : pack.getFraudControlRule();
        if (fcr.getSendTimeout() < 180) {
            fcr.setSendTimeout(180);
        }
        Sum s0 = FinUtils.createVoidSum();
        Operation changeOperation = null;
        pack.setService(Session.getService());
        pack.setServiceType(Session.getServiceType());
        pack.setCommission(Session.getCommission());
        Operation onlineOperation = PackUtility.convert(pack);
        SumResult oOSumResult = onlineOperation.getSumResult();
        Sum change = oOSumResult.getChange();
        SumResult sumResult = new SumResult(onlineOperation.getSumResult().getCash(), onlineOperation.getSumResult().getCashLess(), s0, s0, s0, onlineOperation.getKeeper().getSum(), pack.getProviderFee());
        onlineOperation.setSumResult(sumResult);
        onlineOperation.setPinCode(PinCodeGenerator.generate());
        onlineOperation.setPinCodeNominal(oOSumResult.getOut().add(oOSumResult.getCommission()));
        onlineOperation.setService(new Service(Session.getService()));
        onlineOperation.setFraudControlRule(fcr);
        Session.getPaymentEndingState().setCancel(true);
        if (!change.isEmpty()) {
            Payment payment = pack.getPayments().get(0);
            payment.setId(Sequence.getOperationId());
            payment.setDoc(rnd.nextInt(32000));
            payment.setSumOut(s0);
            pack.setSumResult(new SumResult(s0, s0, s0, s0, s0, change, pack.getProviderFee()));
            pack.setFixedSum(false);
            changeOperation = PackUtility.convert(pack);
            change = changeOperation.getSumResult().getChange();
            sumResult = new SumResult(s0, s0, s0, s0, s0, change, pack.getProviderFee());
            changeOperation.setSumResult(sumResult);
            changeOperation.setDate(new Date());
            changeOperation.setChangeDate(onlineOperation.getDate());
            changeOperation.setService(new Service(Session.getService()));
            changeOperation.setFraudControlRule(pack.getFraudControlRule());
            changeOperation.setKeeper(new Keeper());
        } else {
            pack.setPaybackType(1);
            IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(onlineOperation.getPinCode(), onlineOperation.getPinCodeNominal());
            Session.getPayEnv().getKeeper().setIssuedCard(issuedCashBackCard);
            pack.setIssuedCard(issuedCashBackCard);
        }
        return new Pair((Object)onlineOperation, changeOperation);
    }

    public static Pair<Operation, Operation> cancelOnlinePack2(Pack pack) {
        SumResult oOSumResult;
        FraudControlRule fcr = pack.getFraudControlRule() == null ? new FraudControlRule() : pack.getFraudControlRule();
        if (fcr.getSendTimeout() < 180) {
            fcr.setSendTimeout(180);
        }
        Sum s0 = new Sum(0, Session.getPayEnv().getKeeper().getCurrency());
        Operation changeOperation = null;
        Operation onlineOperation = PackUtility.convert(pack, true);
        if (onlineOperation.getTime() == 0L) {
            onlineOperation.setTime(1L);
        }
        if ((oOSumResult = onlineOperation.getSumResult()) == null) {
            return new Pair(null, null);
        }
        Sum change = oOSumResult.getChange();
        SumResult sumResult = new SumResult(onlineOperation.getSumResult().getCash(), onlineOperation.getSumResult().getCashLess(), s0, s0, s0, onlineOperation.getKeeper().getSum(), pack.getProviderFee());
        onlineOperation.setSumResult(sumResult);
        onlineOperation.setPinCode(PinCodeGenerator.generate());
        onlineOperation.setPinCodeNominal(oOSumResult.getOut().add(oOSumResult.getCommission()));
        onlineOperation.setService(new Service(pack.getService()));
        onlineOperation.setFraudControlRule(fcr);
        if (!change.isEmpty()) {
            Payment payment = pack.getPayments().get(0);
            payment.setId(Sequence.getOperationId());
            payment.setDoc(rnd.nextInt(32000));
            payment.setSumOut(s0);
            pack.setSumResult(new SumResult(s0, s0, s0, s0, s0, change, pack.getProviderFee()));
            changeOperation = PackUtility.convert(pack, true);
            change = changeOperation.getSumResult().getChange();
            sumResult = new SumResult(s0, s0, s0, s0, s0, change, pack.getProviderFee());
            changeOperation.setSumResult(sumResult);
            changeOperation.setDate(new Date());
            changeOperation.setChangeDate(onlineOperation.getDate());
            changeOperation.setService(new Service(pack.getService()));
            changeOperation.setFraudControlRule(fcr);
            changeOperation.setPinCode(PinCodeGenerator.generate());
            changeOperation.setPinCodeNominal(change);
            changeOperation.setKeeper(new Keeper());
        } else {
            pack.setPaybackType(1);
            IssuedCashBackCard issuedCashBackCard = new IssuedCashBackCard(onlineOperation.getPinCode(), onlineOperation.getPinCodeNominal());
            Session.getPayEnv().getKeeper().setIssuedCard(issuedCashBackCard);
            pack.setIssuedCard(issuedCashBackCard);
        }
        if (PackUtility.isEmptyOperation(onlineOperation)) {
            log.info((Object)"Main operation is empty");
            onlineOperation = null;
        }
        if (PackUtility.isEmptyOperation(changeOperation)) {
            log.info((Object)"Change operation is empty");
            changeOperation = null;
        }
        return new Pair((Object)onlineOperation, changeOperation);
    }

    private static boolean isEmptyOperation(Operation op) {
        if (op == null || op.getSumResult() == null) {
            return true;
        }
        SumResult sr = op.getSumResult();
        return !(sr.getChange() != null && !sr.getChange().isEmpty() || sr.getOut() != null && !sr.getOut().isEmpty() || sr.getOutProv() != null && !sr.getOutProv().isEmpty() || op.getPinCodeNominal() != null && !op.getPinCodeNominal().isEmpty());
    }

    public static boolean isNeedSMSCheck(Pack pack) {
        if (Session.getService().getPaperRequire() == 3) {
            return true;
        }
        return Session.getService().getPaperRequire() == 4 && Session.isPrinterError() && !Session.getPaymentEndingState().isTimeOut();
    }

    public static void setGroupIds(List<Payment> list) {
        list.forEach(p -> {
            p.setId(Sequence.getOperationId());
            p.setDoc(rnd.nextInt(32000));
        });
    }

    public static void processKeeper(Pack pack, Operation op) {
        PackUtility.processKeeper(pack, op, false);
    }

    private static void processKeeper(Pack pack, Operation op, boolean useLastKeeper) {
        NewKeeper2 k = null;
        if (useLastKeeper) {
            k = Session.getPayEnv().getLastKeeper();
        }
        if (k == null) {
            k = Session.getPayEnv().getKeeper();
        }
        SumResult sr = pack.getSumResult();
        IssuedCashBackCard issuedCard = pack.getIssuedCard();
        log.info((Object)("processKeeper: " + sr));
        op.setSumResult(sr);
        op.setKeeper(PackUtility.getInKeeper(k));
        if (issuedCard != null) {
            op.setPinCode(issuedCard.getPincode());
            op.setPinCodeNominal(issuedCard.getNominal());
        }
        PackUtility.setChange(op, k);
    }

    public static void setChange(Operation op, NewKeeper2 k) {
        Keeper out = new Keeper();
        if (k.getOut() != null) {
            out.addPayback(k.getOut());
        }
        for (Map.Entry<BoxId, DenominationSet> entry : k.getOutputCash().entrySet()) {
            BoxId key = entry.getKey();
            DenominationSet content = entry.getValue();
            for (Map.Entry e : content.getCounts().entrySet()) {
                out.addCash(CompatUtils.convertBoxId(key), CompatUtils.convert((Denomination)e.getKey()), ((Integer)e.getValue()).intValue());
            }
        }
        op.setChange(out);
    }

    public static void cancelPackToPin(Pack pack) {
        SumResult sr = pack.getSumResult();
        if (sr == null) {
            return;
        }
        Sum s0 = FinUtils.createVoidSum();
        pack.setSumResult(new SumResult(sr.getCash(), sr.getCashLess(), s0, s0, s0, sr.getIncome(), pack.getProviderFee()));
        pack.setPaybackType(1);
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        keeper.setIssuedCard(new IssuedCashBackCard(PinCodeGenerator.generate(), keeper.getSum()));
    }

    public static void cancelPack(Pack pack) {
        SumResult sr = pack.getSumResult();
        Sum s0 = FinUtils.createVoidSum();
        if (sr != null) {
            pack.setSumResult(new SumResult(sr.getCash(), sr.getCashLess(), s0, s0, s0, sr.getIncome(), pack.getProviderFee()));
        }
        Payment p = pack.getPayments().get(0);
        p.setSumOut(s0);
        if (pack.getPayments().size() > 1) {
            pack.getPayments().clear();
            pack.getPayments().add(p);
        }
    }

    public static SumResult cancel(SumResult sr) {
        Sum s0 = FinUtils.createVoidSum();
        return new SumResult(sr.getCash(), sr.getCashLess(), s0, s0, s0, sr.getIncome(), sr.getProviderFee());
    }

    public static Operation cancelChangeToPin(Change change) {
        Operation op = new Operation(change.getOperation());
        op.setChangeDate(change.getDate());
        op.setKeeper(op.getChange());
        op.setDate(new Date());
        op.setIdOperation(Sequence.getOperationId());
        op.setCheckNumber(rnd.nextInt(32000));
        SumResult sumResult = FinUtils.createFullChange(op.getKeeper().getSum());
        log.info((Object)(">>>>>>>>>>>>>>>>>>>>>  " + sumResult));
        op.setSumResult(sumResult);
        op.setPinCode(PinCodeGenerator.generate());
        op.setPinCodeNominal(sumResult.getChange());
        Keeper chKeeper = new Keeper();
        chKeeper.addPayback(sumResult.getChange());
        op.setChange(chKeeper);
        return op;
    }

    public static Operation cancelPayEnvToPin(PayEnv payEnv) {
        Sum cashLess;
        Sum cash;
        Sum in;
        Pack pack = payEnv.getPack();
        NewKeeper2 kpr = payEnv.getKeeper();
        Sum s0 = new Sum(0, kpr.getCurrency());
        Sum out = kpr.getOut() != null ? kpr.getOut() : s0;
        Sum sum = in = kpr.getIncome() != null ? kpr.getIncome() : s0;
        if (!out.isEmpty()) {
            kpr.setIncome(in.add(out));
        }
        kpr.setSumOut(s0);
        Sum keeperSum = kpr.getSum();
        Sum inCash = kpr.getInCashSum();
        Sum outCash = kpr.getOutCashSum();
        if (inCash.compareTo(outCash) >= 0) {
            cash = inCash.sub(outCash);
            cashLess = keeperSum.sub(cash);
        } else {
            cash = s0;
            cashLess = keeperSum;
        }
        pack.setSumResult(new SumResult(cash, cashLess, s0, s0, s0, keeperSum, pack.getProviderFee()));
        IssuedCashBackCard cashBackCard = new IssuedCashBackCard(PinCodeGenerator.generate(), keeperSum);
        pack.setPaybackType(1);
        Operation op = new Operation(PackUtility.convert(pack));
        op.setDate(new Date());
        op.setChangeDate(pack.getChangeDate());
        op.setCheckNumber(rnd.nextInt(32000));
        op.setSumResult(pack.getSumResult());
        op.setIdOperation(Sequence.getOperationId());
        op.setPinCode(cashBackCard.getPincode());
        op.setPinCodeNominal(cashBackCard.getNominal());
        return op;
    }

    private static void fillOperationFormsViewsTitlesIes(Operation o, Collection<InputElement> ies) {
        for (InputElement ie : ies) {
            InputElement ieTmp = new InputElement(ie);
            String keyTitle = ie.getKeyTitle();
            String valueTitle = ie.getValueTitle();
            if (ie.getKeyTitleId() != null && !ie.getKeyTitleId().isEmpty()) {
                keyTitle = Session.LocalizationUtils.get(ie.getKeyTitleId());
                ieTmp.setKeyTitle(keyTitle);
            }
            o.getInputElements().put(ieTmp.getKey(), ieTmp);
            o.getForm().put(ie.getKey(), ie.getValue());
            o.getViews().put(ie.getKey(), valueTitle);
            o.getTitles().put(ie.getKey(), keyTitle);
        }
    }

    private static void fillOperationFormsViewsTitlesIes(ChildOperation o, Collection<InputElement> ies) {
        for (InputElement ie : ies) {
            InputElement ieTmp = new InputElement(ie);
            String keyTitle = ie.getKeyTitle();
            String valueTitle = ie.getValueTitle();
            if (ie.getKeyTitleId() != null && !ie.getKeyTitleId().isEmpty()) {
                keyTitle = Session.LocalizationUtils.get(ie.getKeyTitleId());
                ieTmp.setKeyTitle(keyTitle);
            }
            o.getInputElements().put(ieTmp.getKey(), ieTmp);
            o.getForm().put(ie.getKey(), ie.getValue());
            o.getViews().put(ie.getKey(), valueTitle);
            o.getTitles().put(ie.getKey(), keyTitle);
        }
    }

    public static Keeper getInKeeper(NewKeeper2 keeper) {
        Map<CashUnit, Integer> inputMap;
        Keeper in = new Keeper();
        if (!keeper.getIncome().isEmpty()) {
            in.addPayback(keeper.getIncome());
        }
        if (!(inputMap = keeper.getInputMap()).isEmpty() && keeper.getInputCash().isEmpty()) {
            keeper.getInputMap().forEach((x, y) -> log.info((Object)(x + " -> " + y)));
            keeper.getInputMap().forEach((cu, count) -> in.addCash(null, cu, count.intValue()));
        } else {
            keeper.getInputCash().forEach((x, y) -> log.info((Object)(x + " -> " + y)));
            for (Map.Entry<BoxId, DenominationSet> entry : keeper.getInputCash().entrySet()) {
                BoxId box = entry.getKey();
                DenominationSet content = entry.getValue();
                for (Map.Entry e : content.getCounts().entrySet()) {
                    in.addCash(CompatUtils.convertBoxId(box), CompatUtils.convert((Denomination)e.getKey()), ((Integer)e.getValue()).intValue());
                }
            }
        }
        if (!keeper.getInputCards().isEmpty()) {
            keeper.getInputCards().stream().map(acbc -> new CashBackCard(0, acbc.getNominal(), acbc.getReference())).forEach(arg_0 -> ((Keeper)in).addCashBackCard(arg_0));
        }
        log.info((Object)("Keeper: -> " + in));
        return in;
    }

    public static String getPaymentSource(int pt) {
        if (pt == 0) {
            return "CASH";
        }
        if (pt == 1) {
            return "CBC";
        }
        if (pt == 2) {
            return "BANKCARD";
        }
        if (pt == 3) {
            return "BANKCARD_OTHER";
        }
        if (pt == 4) {
            return "KEEPER";
        }
        return "-";
    }
}

