/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.app.id.LoggerId;
import fxterm.module.Module;
import fxterm.module.ModuleTypeListener;
import fxterm.msg.Messages;
import fxterm.session.Session;
import java.util.HashSet;
import java.util.Set;

public class ModuleStore {
    private static Module module;
    private static final Set<ModuleTypeListener> listeners;

    public static Module getModule() {
        return module;
    }

    public static void setModule(Module module) {
        if (module == null) {
            throw new NullPointerException("Module is not set");
        }
        if (ModuleStore.module == null || ModuleStore.module.getType() != module.getType()) {
            LoggerId.PAY.info((Object)("***** Open module: " + Messages.getModuleType(module.getType())));
        }
        ModuleStore.module = module;
        Session.setCurrentModule(module.getType());
        for (ModuleTypeListener listener : listeners) {
            listener.onChange(module.getType());
        }
    }

    public static void addListener(ModuleTypeListener listener) {
        if (listener != null) {
            listeners.add(listener);
            if (module != null) {
                listener.onChange(module.getType());
            }
        }
    }

    static {
        listeners = new HashSet<ModuleTypeListener>();
    }
}

