/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.app.id.LoggerId;
import fxterm.module.input.adv.attribute.EnvAttributeProcessor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.PrefillItem;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.References;
import ru.softlogic.reference.fraud.FraudControlRule;

public final class ModuleHelper {
    private static final Logger log = LoggerId.PAY;

    private ModuleHelper() {
    }

    public static void prefillStore(Map<String, PrefillItem> items, Map<String, Object> store) {
        if (items == null || items.isEmpty() || store == null) {
            return;
        }
        for (Map.Entry<String, PrefillItem> entry : items.entrySet()) {
            PrefillItem prefillItem = entry.getValue();
            String valueKey = entry.getKey();
            InputElement value = EnvAttributeProcessor.getValue(valueKey);
            if (value == null) continue;
            String key = prefillItem.getKey() != null ? prefillItem.getKey() : valueKey;
            value.setKey(key);
            String title = prefillItem.getTitle();
            if (title != null) {
                value.setKeyTitle(title);
            }
            store.put(key, value);
            log.info((Object)("Add value: " + valueKey + "->" + prefillItem.getKey() + ", result: " + value));
        }
    }

    public static void fillStore(Map<String, Object> items, Map<String, Object> store) {
        if (items == null || items.isEmpty() || store == null) {
            return;
        }
        store.putAll(items);
    }

    public static Operation copyOperation(Operation printOperation) {
        if (printOperation instanceof GroupOperation) {
            GroupOperation go = new GroupOperation(printOperation);
            Map<String, InputElement> inputElements = ModuleHelper.clearNotPrinted(go.getInputElements());
            go.getInputElements().clear();
            go.getInputElements().putAll(inputElements);
            if (go.getChildOperations() != null) {
                for (ChildOperation co : go.getChildOperations()) {
                    inputElements = ModuleHelper.clearNotPrinted(co.getInputElements());
                    co.getInputElements().clear();
                    co.getInputElements().putAll(inputElements);
                }
            }
            return go;
        }
        if (printOperation != null) {
            Operation op = new Operation(printOperation);
            Map<String, InputElement> inputElements = ModuleHelper.clearNotPrinted(op.getInputElements());
            op.getInputElements().clear();
            op.getInputElements().putAll(inputElements);
            return op;
        }
        return null;
    }

    public static Map<String, InputElement> clearNotPrinted(Map<String, InputElement> data) {
        LinkedHashMap<String, InputElement> result = new LinkedHashMap<String, InputElement>();
        for (Map.Entry<String, InputElement> es : data.entrySet()) {
            if (es.getValue().hasFlag(2)) continue;
            result.put(es.getKey(), es.getValue());
        }
        return result;
    }

    public static FraudControlRule getFraudControlRule(int serviceId) {
        FraudControlRule pointFcr = null;
        List fcrs = References.getFraudControlRules();
        if (fcrs == null) {
            return null;
        }
        for (FraudControlRule fcr : fcrs) {
            if (fcr.getIdService() == null) {
                pointFcr = fcr;
                continue;
            }
            if (fcr.getIdService().intValue() != serviceId) continue;
            return fcr;
        }
        return pointFcr;
    }
}

