/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.GroupByLabelVisitor;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.Intent;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public interface Module {
    public static final int LOCK = 0;
    public static final int ENTRY = 1;
    public static final int INPUT = 2;
    public static final int PAYMENT = 3;
    public static final int PAYOUT_BEFORE_PROC = 4;
    public static final int PROCESSING = 5;
    public static final int PAYOUT_AFTER_PROC = 6;
    public static final int ENDING = 7;
    public static final int INFO_MODULE = 8;
    public static final int SEARCH = 9;
    public static final int REINIT = 10;
    public static final int PRESENT = 11;
    public static final int PRINT = 12;
    public static final int UTILITY = 13;
    public static final int PAYTPL_LOAD = 14;
    public static final int PAYTPL_SAVE = 15;

    public int getType();

    public int getInactivityTimeout();

    public void cancel(Intent var1);

    default public void onBannerClicked(Banner banner) {
        Logger log = LoggerId.PAY;
        if (banner != null && banner.getIdReferService() != null) {
            log.info((Object)("Requested redirect to service: " + banner.getIdReferService()));
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(banner.getIdReferService());
            MenuUtils.processMenu(mbsiv);
            MenuItem mi = mbsiv.getMenuItem();
            if (mi != null) {
                MenuItemState mis = MenuUtils.getState(mi);
                if (mis == null || mis.getButtonStatus() != ButtonStatus.Blocked && mis.getButtonStatus() != ButtonStatus.Hidden) {
                    log.info((Object)("Found service: " + mi.getService().getName()));
                    if (this.canRedirect()) {
                        log.info((Object)"Redirect allowed");
                        Platform.runLater(() -> Launcher.open(mi));
                    } else {
                        log.info((Object)"The module is not allowed to make a redirect");
                    }
                } else {
                    log.info((Object)("MenuItem with id " + banner.getIdReferService() + " is not available. Skip redirect"));
                }
            } else {
                log.info((Object)("MenuItem with id " + banner.getIdReferService() + " not founded. Skip redirect"));
            }
        } else if (banner != null && banner.getLabel() != null) {
            log.info((Object)("Requested redirect to label: " + banner.getLabel()));
            GroupByLabelVisitor gblv = new GroupByLabelVisitor(banner.getLabel());
            MenuUtils.processMenu(gblv);
            ServiceType st = gblv.getServiceType();
            if (st != null) {
                if (!(st.getName().startsWith("#") || st.isHidden() || st.getBlocked().booleanValue())) {
                    log.info((Object)("Found group: " + st.getName()));
                    if (this.canRedirect()) {
                        log.info((Object)"Redirect allowed");
                        Platform.runLater(() -> FxEnv.getMenuEngine().onGroup(st, 0));
                    } else {
                        log.info((Object)"The module is not allowed to make a redirect");
                    }
                } else {
                    log.info((Object)("Group with label " + banner.getLabel() + " is not available. Skip redirect"));
                }
            } else {
                log.info((Object)("Group with label " + banner.getLabel() + " not founded. Skip redirect"));
            }
        } else {
            log.info((Object)"Refer service or group is not set");
        }
    }

    default public boolean canRedirect() {
        LoggerId.PAY.info((Object)"Request for permission to redirect. The default implementation: return false");
        return false;
    }

    default public Optional<Map<String, Object>> getModuleData() {
        return Optional.empty();
    }

    public BarcodeListener getBarcodeScannerListener();
}

