/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.app.id.LoggerId;
import fxterm.core.update.AppFilter;
import fxterm.core.update.JreFilter;
import fxterm.core.update.ResourceFilter;
import fxterm.core.update.WrongReferencesException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import plfx.skin.Skin;
import ru.softlogic.reference.References;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.adv.Movie;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.FileUpdateStore;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.CreateStoreException;
import ru.softlogic.update.updater.filter.AndFilter;
import ru.softlogic.update.updater.filter.Filter;
import ru.softlogic.update.updater.filter.VoidFilter;

public class UpdateUtils {
    public static final String UPDATE_VERSION = "v7";

    private UpdateUtils() {
    }

    public static UpdateRequest createAppUpdateRequest(UpdateControl control, StateListener listener) throws CreateStoreException, WrongReferencesException {
        Point point = References.getPoint();
        UpdateOptions uo = References.getUpdateOptions();
        UpdateUtils.checkRefs(point, uo);
        UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(UpdateUtils.updateUrl(uo.getUpdateUrl()), uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), LoggerId.UPDATE), control, (Filter)new AndFilter(new Filter[]{UpdateUtils.createJreFilter(), new AppFilter()}), PathUtils.getFilePath((String)"/"), PathUtils.getFilePath((String)"/update/app/"), PathUtils.getFilePath((String)"/update/nlist.xml.gz"), listener, null);
        return ur;
    }

    public static UpdateRequest createResUpdateRequest(UpdateControl control, StateListener listener) throws CreateStoreException, WrongReferencesException {
        Point point = References.getPoint();
        UpdateOptions uo = References.getUpdateOptions();
        UpdateUtils.checkRefs(point, uo);
        UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(UpdateUtils.updateUrl(uo.getUpdateUrl()), uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), LoggerId.UPDATE), control, (Filter)new ResourceFilter(), PathUtils.getFilePath((String)"/"), PathUtils.getFilePath((String)"/update/res/"), PathUtils.getFilePath((String)"/update/nlist.xml.gz"), listener, null);
        return ur;
    }

    public static UpdateRequest createAppUpdateRequest(File updateFile, UpdateControl control, StateListener listener) throws WrongReferencesException {
        Point point = References.getPoint();
        UpdateOptions uo = References.getUpdateOptions();
        UpdateUtils.checkRefs(point, uo);
        UpdateRequest ur = new UpdateRequest((UpdateStore)new FileUpdateStore(updateFile), control, UpdateUtils.createJreFilter(), PathUtils.getFilePath((String)"/"), PathUtils.getFilePath((String)"/update/app/"), PathUtils.getFilePath((String)"/update/nlist.xml.gz"), listener, null);
        return ur;
    }

    public static UpdateRequest createBannerUpdateRequest(UpdateControl control, StateListener listener, List<UpdateItem> items) throws CreateStoreException, WrongReferencesException {
        Point point = References.getPoint();
        UpdateOptions uo = References.getUpdateOptions();
        UpdateUtils.checkRefs(point, uo);
        if (items == null || items.isEmpty()) {
            throw new WrongReferencesException("Items must be filled");
        }
        UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(uo.getUpdateUrl() + "/banners/", uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), LoggerId.UPDATE), control, (Filter)new VoidFilter(), PathUtils.getFilePath((String)"/content/banners/"), PathUtils.getFilePath((String)"/update/bnr/"), PathUtils.getFilePath((String)"/update/nlist.xml.gz"), listener, items);
        return ur;
    }

    public static UpdateRequest createMoviesUpdateRequest(UpdateControl control, StateListener listener, List<UpdateItem> items) throws CreateStoreException, WrongReferencesException {
        Point point = References.getPoint();
        UpdateOptions uo = References.getUpdateOptions();
        UpdateUtils.checkRefs(point, uo);
        if (items == null || items.isEmpty()) {
            throw new WrongReferencesException("Items must be filled");
        }
        UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(uo.getUpdateUrl() + "/ad/", uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), LoggerId.UPDATE), control, (Filter)new VoidFilter(), PathUtils.getFilePath((String)"/content/ad/"), PathUtils.getFilePath((String)"/update/ad/"), PathUtils.getFilePath((String)"/update/nlist.xml.gz"), listener, items);
        return ur;
    }

    private static void checkRefs(Point point, UpdateOptions uo) throws WrongReferencesException {
        if (point == null) {
            throw new WrongReferencesException("Point is null");
        }
        if (uo == null) {
            throw new WrongReferencesException("Update options is null");
        }
        if (uo.getUpdateUrl() == null) {
            throw new WrongReferencesException("Update url is null");
        }
        if (uo.getUpdateUrl().isEmpty()) {
            throw new WrongReferencesException("Update url is empty");
        }
    }

    public static List<UpdateItem> buildBannerItems() {
        Banner[] banners = References.getBanners();
        if (banners == null) {
            return null;
        }
        LinkedList<UpdateItem> res = new LinkedList<UpdateItem>();
        for (Banner b : banners) {
            if (b.getIface() == null || !b.getIface().matches(Skin.getWorkSkin())) continue;
            res.add(new UpdateItem(b.getUrl(), b.getCrc(), b.getSize(), 0L));
            if (b.getPopupUrl() == null) continue;
            res.add(new UpdateItem(b.getPopupUrl(), b.getPopupCrc(), b.getSize(), 0L));
        }
        return res;
    }

    public static List<UpdateItem> buildMoviesItems() {
        Movie[] movies = References.getMovies();
        if (movies == null) {
            return null;
        }
        LinkedList<UpdateItem> res = new LinkedList<UpdateItem>();
        for (Movie m : movies) {
            if (m.getUrl() == null || m.getCrc() == 0L) continue;
            res.add(new UpdateItem(m.getUrl(), m.getCrc(), 0, 0L));
        }
        return res;
    }

    private static String updateUrl(String url) {
        if (OsDetector.current() == 1) {
            return url + "/" + UPDATE_VERSION + "/linux/";
        }
        return url + "/" + UPDATE_VERSION + "/windows/";
    }

    public static String readJavaBuild() throws IOException {
        File f = PathUtils.getFilePath((String)"/jre/work//sl/version");
        return FileUtils.readFileToString((File)f).trim();
    }

    private static Filter createJreFilter() {
        try {
            return new JreFilter(UpdateUtils.readJavaBuild());
        }
        catch (IOException ex) {
            return new JreFilter(null);
        }
    }

    public static File[] getListLocalUpdates() {
        LinkedList<File> result = new LinkedList<File>();
        for (File drive : UpdateUtils.getListDrives()) {
            result.addAll(UpdateUtils._search(0, 2, drive, 20, pathname -> pathname.isFile() && "list.crc".equalsIgnoreCase(pathname.getName())));
        }
        return result.toArray(new File[result.size()]);
    }

    public static List<File> getListDrives() {
        if (OsDetector.current() == 1) {
            File mtab = new File("//etc//mtab");
            if (mtab.exists() && mtab.canRead()) {
                ArrayList<File> result = new ArrayList<File>();
                try {
                    List strings = FileUtils.readLines((File)mtab);
                    if (strings != null) {
                        for (String s : strings) {
                            File drive;
                            String[] drives = s.split(" ");
                            if (drives == null || drives.length < 2 || drives[1].equals("/") || !(drive = new File(drives[1].replace("\\040", " "))).exists()) continue;
                            result.add(drive);
                        }
                    }
                    return result;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new ArrayList<File>();
        }
        if (OsDetector.current() == 2) {
            ArrayList<File> result = new ArrayList<File>();
            File[] drives = File.listRoots();
            if (drives != null) {
                for (File f : drives) {
                    if (new File(PathUtils.getAppDrive() + "\\").equals(f)) continue;
                    result.add(f);
                }
            }
            return result;
        }
        return new ArrayList<File>();
    }

    private static List<File> _search(int currentlevel, int maxlevel, File dir, int maxsubdirs, FileFilter filter) {
        LinkedList<File> result = new LinkedList<File>();
        if (currentlevel <= maxlevel) {
            File[] dirs;
            File[] files = dir.listFiles(filter);
            if (files != null) {
                result.addAll(Arrays.asList(files));
            }
            if ((dirs = dir.listFiles(pathname -> pathname.isDirectory())) != null && dirs.length <= maxsubdirs) {
                for (File d : dirs) {
                    result.addAll(UpdateUtils._search(currentlevel + 1, maxlevel, d, maxsubdirs, filter));
                }
            }
        }
        return result;
    }
}

