/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.timer.Timer;
import fxterm.core.update.BaseUpdateStateListener;
import fxterm.core.update.LocalAppStateListener;
import fxterm.core.update.LocalBannerStateListener;
import fxterm.core.update.LocalMoviesStateListener;
import fxterm.core.update.LocalResStateListener;
import fxterm.core.update.UpdateUtils;
import fxterm.core.update.WrongReferencesException;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.RemoteStatusObserver;
import ru.softlogic.update.updater.AutoUpdateControl;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateHandler;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.exceptions.CreateStoreException;

public class UpdateChecker
implements Runnable,
RemoteStatusObserver {
    public static final int RESULT_OK = 0;
    public static final int RESULT_ERROR = 1;
    public static final int RESULT_GLOBAL_ERROR = 2;
    private UpdateHandler updateHandler;
    private boolean appEnabled;
    private boolean bnrEnable;
    private boolean datEnable;
    private long lastAppAwake = -1L;
    private long lastBnrAwake = -1L;
    private long lastDatAwake = -1L;
    private int lastAppResult;
    private int lastBnrResult;
    private int lastDatResult;
    private final Logger log = LoggerId.UPDATE;
    private BaseUpdateStateListener appListener;
    private BaseUpdateStateListener bnrListener;
    private BaseUpdateStateListener moviesListener;
    private BaseUpdateStateListener datListener;
    private int normalTimeout = -1;
    private static final int LOCAL_ERR_TIMEOUT = 30;
    private static final int GLOBAL_ERR_TIMEOUT = 360;

    public UpdateChecker(UpdateHandler updateHandler, ClientInterface client) {
        if (updateHandler == null) {
            throw new NullPointerException("UpdateHandler");
        }
        this.updateHandler = updateHandler;
        this.appListener = new LocalAppStateListenerImpl(client, LoggerId.UPDATE);
        this.bnrListener = new LocalBannerStateListenerImpl(client, LoggerId.UPDATE);
        this.moviesListener = new LocalMoviesStateListenerImpl(client, LoggerId.UPDATE);
        this.datListener = new LocalDatStateListenerImpl(client, this.log);
    }

    public void update(int remoteStatus) {
        boolean newDatEnabled;
        boolean newBnrEnabled;
        boolean newAppEnabled;
        boolean bl = newAppEnabled = (remoteStatus & 2) > 0;
        if (this.appEnabled != newAppEnabled) {
            this.log.info((Object)("Change app update flag: " + newAppEnabled));
            this.appEnabled = newAppEnabled;
            this.lastAppAwake = -1L;
        }
        boolean bl2 = newBnrEnabled = (remoteStatus & 0x80) > 0;
        if (this.bnrEnable != newBnrEnabled) {
            this.log.info((Object)("Change bnr update flag: " + newBnrEnabled));
            this.bnrEnable = newBnrEnabled;
            this.lastBnrAwake = -1L;
        }
        boolean bl3 = newDatEnabled = (remoteStatus & 0x20) > 0;
        if (this.datEnable != newDatEnabled) {
            this.log.info((Object)("Change data update flag: " + newDatEnabled));
            this.datEnable = newDatEnabled;
            this.lastDatAwake = -1L;
        }
        if (!this.appEnabled) {
            this.appListener.updateState((short)0);
        }
        if (!this.bnrEnable) {
            this.bnrListener.updateState((short)0);
        }
        if (!this.datEnable) {
            this.datListener.updateState((short)0);
        }
    }

    @Override
    public void run() {
        if (this.normalTimeout < 0) {
            this.normalTimeout = SystemProp.getUpdateFreq();
            this.log.info((Object)("Check timeout: " + this.normalTimeout));
        }
        this.log.debug((Object)("Checker awake: app=" + this.lastAppAwake + ", bnr=" + this.lastBnrAwake + ", dat=" + this.lastBnrAwake));
        this.runAppUpdate();
    }

    private void runAppUpdate() {
        block6: {
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Check app update");
            if (this.canUpdate("App", this.lastAppAwake, this.lastAppResult, this.appEnabled)) {
                try {
                    UpdateRequest ur = UpdateUtils.createAppUpdateRequest((UpdateControl)new AutoUpdateControl(5), this.appListener);
                    if (this.updateHandler.getQueueSize() == 0 && this.updateHandler.addUpdateRequest(ur)) {
                        this.log.info((Object)"AppRequest successfully added");
                        break block6;
                    }
                    this.log.info((Object)"Another request processed");
                }
                catch (WrongReferencesException ex) {
                    this.log.error((Object)("References are not available, it is impossible to request updates (" + ex.getMessage() + ")"));
                }
                catch (CreateStoreException ex) {
                    this.log.error((Object)"Error on process", (Throwable)ex);
                }
            } else {
                this.log.info((Object)"App update is disable, skip");
                this.runBanUpdate();
            }
        }
    }

    private void runBanUpdate() {
        block8: {
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Check banners");
            if (this.canUpdate("Bnr", this.lastBnrAwake, this.lastBnrResult, this.bnrEnable)) {
                List<UpdateItem> items = UpdateUtils.buildBannerItems();
                if (items != null && !items.isEmpty()) {
                    try {
                        UpdateRequest ur = UpdateUtils.createBannerUpdateRequest((UpdateControl)new AutoUpdateControl(5), this.bnrListener, items);
                        if (this.updateHandler.getQueueSize() == 0 && this.updateHandler.addUpdateRequest(ur)) {
                            this.log.info((Object)"BanRequest successfully added");
                            break block8;
                        }
                        this.log.info((Object)"Another request processed");
                    }
                    catch (WrongReferencesException ex) {
                        this.log.error((Object)("References are not available, it is impossible to request updates (" + ex.getMessage() + ")"));
                    }
                    catch (CreateStoreException ex) {
                        this.log.error((Object)"Error on process", (Throwable)ex);
                    }
                } else {
                    this.log.info((Object)"Nothing to do");
                    this.runMoviesUpdate();
                }
            } else {
                this.log.info((Object)"Banner update is disable, skip");
                this.runResUpdate();
            }
        }
    }

    private void runMoviesUpdate() {
        block6: {
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Check movies");
            List<UpdateItem> items = UpdateUtils.buildMoviesItems();
            if (items != null && !items.isEmpty()) {
                try {
                    UpdateRequest ur = UpdateUtils.createMoviesUpdateRequest((UpdateControl)new AutoUpdateControl(5), this.moviesListener, items);
                    if (this.updateHandler.getQueueSize() == 0 && this.updateHandler.addUpdateRequest(ur)) {
                        this.log.info((Object)"MovRequest successfully added");
                        break block6;
                    }
                    this.log.info((Object)"Another request processed");
                }
                catch (WrongReferencesException ex) {
                    this.log.error((Object)("References are not available, it is impossible to request updates (" + ex.getMessage() + ")"));
                }
                catch (CreateStoreException ex) {
                    this.log.error((Object)"Error on process", (Throwable)ex);
                }
            } else {
                this.log.info((Object)"Nothing to do");
                this.runResUpdate();
            }
        }
    }

    private void runResUpdate() {
        block6: {
            this.log.info((Object)"-------------------------------------------------------------------------------");
            this.log.info((Object)"Check resources update");
            if (this.canUpdate("Res", this.lastDatAwake, this.lastDatResult, this.datEnable)) {
                try {
                    UpdateRequest ur = UpdateUtils.createResUpdateRequest((UpdateControl)new AutoUpdateControl(5), this.datListener);
                    if (this.updateHandler.getQueueSize() == 0 && this.updateHandler.addUpdateRequest(ur)) {
                        this.log.info((Object)"DatRequest successfully added");
                        break block6;
                    }
                    this.log.info((Object)"Another request processed");
                }
                catch (WrongReferencesException ex) {
                    this.log.error((Object)("References are not available, it is impossible to request updates (" + ex.getMessage() + ")"));
                }
                catch (CreateStoreException ex) {
                    this.log.error((Object)"Error on process", (Throwable)ex);
                }
            } else {
                this.log.info((Object)"Resources update is disable, skip");
            }
        }
    }

    private boolean canUpdate(String id, long lastAwake, int lastResult, boolean enable) {
        if (enable) {
            if (lastAwake >= 0L) {
                long interval = Timer.currentMin() - lastAwake;
                this.log.info((Object)(id + " Interval: " + interval + " min, last result=" + lastResult));
                if (lastResult == 0 && interval < (long)this.normalTimeout) {
                    this.log.info((Object)(id + " Continue to sleep[OK]"));
                    return false;
                }
                if (lastResult == 1 && interval < 30L) {
                    this.log.info((Object)(id + " Continue to sleep[ERROR]"));
                    return false;
                }
                if (lastResult == 2 && interval < 360L) {
                    this.log.info((Object)(id + " Continue to sleep[GLOBAL]"));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private class LocalDatStateListenerImpl
    extends LocalResStateListener {
        public LocalDatStateListenerImpl(ClientInterface server, Logger log) {
            super(server, log);
        }

        @Override
        protected void onState(int state) {
            UpdateChecker.this.lastDatAwake = Timer.currentMin();
            UpdateChecker.this.lastDatResult = state;
        }
    }

    private class LocalMoviesStateListenerImpl
    extends LocalMoviesStateListener {
        public LocalMoviesStateListenerImpl(ClientInterface server, Logger log) {
            super(server, log);
        }

        @Override
        public void onState(int state) {
            UpdateChecker.this.lastBnrAwake = Timer.currentMin();
            UpdateChecker.this.lastBnrResult = state;
            if (state == 0) {
                UpdateChecker.this.runResUpdate();
            }
        }
    }

    private class LocalBannerStateListenerImpl
    extends LocalBannerStateListener {
        public LocalBannerStateListenerImpl(ClientInterface server, Logger log) {
            super(server, log);
        }

        @Override
        public void onState(int state) {
            UpdateChecker.this.lastBnrAwake = Timer.currentMin();
            UpdateChecker.this.lastBnrResult = state;
            if (state == 0) {
                UpdateChecker.this.runMoviesUpdate();
            }
        }
    }

    private class LocalAppStateListenerImpl
    extends LocalAppStateListener {
        public LocalAppStateListenerImpl(ClientInterface server, Logger log) {
            super(server, log);
        }

        @Override
        protected void onState(int state) {
            UpdateChecker.this.lastAppAwake = Timer.currentMin();
            UpdateChecker.this.lastAppResult = state;
        }

        @Override
        protected void onCheckBanners() {
            UpdateChecker.this.runBanUpdate();
        }
    }
}

