/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.core.cache.CacheManager;
import fxterm.core.update.BaseUpdateStateListener;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

abstract class LocalResStateListener
extends BaseUpdateStateListener {
    private final Logger log;

    public LocalResStateListener(ClientInterface server, Logger log) {
        super(server, (short)2, log);
        this.log = log;
    }

    @Override
    public void _onStart() {
        this.log.info((Object)"ResState: start update");
    }

    @Override
    public void _onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.log.info((Object)("ResState: local error, metrics=" + updateMetric));
        this.onState(1);
    }

    @Override
    public void _onGlobalError(Exception ex) {
        this.log.info((Object)"ResState: global error");
        this.onState(2);
    }

    @Override
    public void _onSkip() {
        this.log.info((Object)"ResState: skip update");
        File resDir = PathUtils.getFilePath((String)"/update/res/");
        File[] res = resDir.listFiles();
        if (res != null && res.length > 0) {
            GuiNotifier.notifyProblemOnce((String)("Directory " + resDir.getAbsolutePath() + " is not empty"));
        }
        this.onState(0);
    }

    @Override
    public boolean _onSuccess(UpdateMetric updateMetric) {
        this.log.info((Object)("ResState: success " + updateMetric));
        this.onState(0);
        try {
            this.log.info((Object)"Copy resources");
            FileUtils.copyDirectory((File)PathUtils.getFilePath((String)"/update/res/"), (File)PathUtils.getFilePath((String)"/"));
            this.log.info((Object)"Done, clean update");
            FileUtils.cleanDirectory((File)PathUtils.getFilePath((String)"/update/res/"));
            this.log.info((Object)"Done");
            this.log.info((Object)"Notify cache manager");
            CacheManager.reset();
            this.log.info((Object)"Reset software build");
            DaemonUtil.resetUpdateBuild();
            this.log.info((Object)"Reload mobile identifier");
            IdentifyService.update();
            this.log.info((Object)"Resources update successfully");
        }
        catch (IOException ex) {
            this.log.error((Object)"Error on move data", (Throwable)ex);
        }
        return false;
    }

    @Override
    public void _onCancel() {
        this.log.info((Object)"ResState: cancel");
        this.onState(0);
    }

    @Override
    public void _onConfirm(UpdateSize updateSize) {
        this.log.info((Object)("ResState: update confirm, update size=" + updateSize));
    }

    @Override
    public void _onProgress(String fileName, int total, int progress) {
    }

    protected abstract void onState(int var1);
}

