/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.core.update.BaseUpdateStateListener;
import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

abstract class LocalMoviesStateListener
extends BaseUpdateStateListener {
    private final Logger log;

    public LocalMoviesStateListener(ClientInterface server, Logger log) {
        super(server, (short)1, log);
        this.log = log;
    }

    @Override
    public void _onStart() {
        this.log.info((Object)"MovState: start update");
    }

    @Override
    public void _onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.log.info((Object)("MovState: local error, metrics=" + updateMetric));
        this.onState(1);
    }

    @Override
    public void _onGlobalError(Exception ex) {
        this.log.info((Object)"MovState: global error");
        this.onState(2);
    }

    @Override
    public void _onSkip() {
        this.log.info((Object)"MovState: skip update");
        this.checkDirectory();
        this.onState(0);
    }

    @Override
    public boolean _onSuccess(UpdateMetric updateMetric) {
        this.log.info((Object)("MovState: success " + updateMetric));
        this.onState(0);
        try {
            File[] newBanners = PathUtils.getFilePath((String)"/update/ad/").listFiles((dir, name) -> name.toLowerCase().endsWith(".zip"));
            if (newBanners != null && newBanners.length > 0) {
                this.log.info((Object)("Count of zip movies: " + newBanners.length));
                ((Stream)Stream.of(newBanners).parallel()).forEach(banner -> {
                    try {
                        this.log.info((Object)("Unpack movies: " + banner.getAbsolutePath()));
                        FileUtil.unZip((File)banner, (File)new File(FilenameUtils.removeExtension((String)banner.getAbsolutePath())));
                        FileUtils.deleteDirectory((File)new File(PathUtils.getFilePath((String)"/content/ad/") + FilenameUtils.removeExtension((String)banner.getName())));
                    }
                    catch (IOException | FileUtilException throwable) {
                        // empty catch block
                    }
                });
            }
            this.moveFiles();
        }
        catch (Exception ex) {
            this.log.error((Object)"Erron on move movies: ", (Throwable)ex);
        }
        return false;
    }

    @Override
    public void _onCancel() {
        this.log.info((Object)"MovState: cancel");
        this.onState(0);
    }

    @Override
    public void _onConfirm(UpdateSize updateSize) {
        this.log.info((Object)("MovState: update confirm, update size=" + updateSize));
    }

    @Override
    public void _onProgress(String fileName, int total, int progress) {
    }

    private void moveFiles() throws IOException {
        this.log.info((Object)"Move movies");
        FileUtils.copyDirectory((File)PathUtils.getFilePath((String)"/update/ad/"), (File)PathUtils.getFilePath((String)"/content/ad/"), (boolean)true);
        this.log.info((Object)"Done, clean update");
        FileUtils.cleanDirectory((File)PathUtils.getFilePath((String)"/update/ad/"));
        this.log.info((Object)"Done");
    }

    private void checkDirectory() {
        File resDir = PathUtils.getFilePath((String)"/update/ad/");
        File[] res = resDir.listFiles();
        if (res != null && res.length > 0) {
            this.log.info((Object)("Directory " + resDir.getAbsolutePath() + " is not empty"));
            try {
                this.moveFiles();
            }
            catch (Exception ex) {
                this.log.error((Object)"Erron on move movies: ", (Throwable)ex);
            }
        }
    }

    protected abstract void onState(int var1);
}

