/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.core.update.BaseUpdateStateListener;
import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

abstract class LocalBannerStateListener
extends BaseUpdateStateListener {
    private final Logger log;

    public LocalBannerStateListener(ClientInterface server, Logger log) {
        super(server, (short)1, log);
        this.log = log;
    }

    @Override
    public void _onStart() {
        this.log.info((Object)"BanState: start update");
    }

    @Override
    public void _onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.log.info((Object)("BanState: local error, metrics=" + updateMetric));
        this.onState(1);
    }

    @Override
    public void _onGlobalError(Exception ex) {
        this.log.info((Object)"BanState: global error");
        this.onState(2);
    }

    @Override
    public void _onSkip() {
        this.log.info((Object)"BanState: skip update");
        this.checkDirectory();
        this.onState(0);
    }

    @Override
    public boolean _onSuccess(UpdateMetric updateMetric) {
        this.log.info((Object)("BanState: success " + updateMetric));
        try {
            File[] newBanners = PathUtils.getFilePath((String)"/update/bnr/").listFiles((dir, name) -> name.toLowerCase().endsWith(".zip"));
            if (newBanners != null && newBanners.length > 0) {
                this.log.info((Object)("Count of zip banners: " + newBanners.length));
                ((Stream)Stream.of(newBanners).parallel()).forEach(banner -> {
                    try {
                        this.log.info((Object)("Unpack banner: " + banner.getAbsolutePath()));
                        FileUtil.unZip((File)banner, (File)new File(FilenameUtils.removeExtension((String)banner.getAbsolutePath())));
                        FileUtils.deleteDirectory((File)new File(PathUtils.getFilePath((String)"/content/banners/") + FilenameUtils.removeExtension((String)banner.getName())));
                    }
                    catch (IOException | FileUtilException ex) {
                        this.log.error((Object)"Error on process banners", ex);
                    }
                });
            }
            this.moveFiles();
        }
        catch (Exception ex) {
            this.log.error((Object)"Erron on move banners: ", (Throwable)ex);
        }
        this.onState(0);
        return false;
    }

    @Override
    public void _onCancel() {
        this.log.info((Object)"BanState: cancel");
        this.onState(0);
    }

    @Override
    public void _onConfirm(UpdateSize updateSize) {
        this.log.info((Object)("BanState: update confirm, update size=" + updateSize));
    }

    @Override
    public void _onProgress(String fileName, int total, int progress) {
    }

    private void moveFiles() throws IOException {
        this.log.info((Object)"Move banners");
        FileUtils.copyDirectory((File)PathUtils.getFilePath((String)"/update/bnr/"), (File)PathUtils.getFilePath((String)"/content/banners/"), (boolean)true);
        this.log.info((Object)"Done, clean update");
        FileUtils.cleanDirectory((File)PathUtils.getFilePath((String)"/update/bnr/"));
        this.log.info((Object)"Done");
    }

    private void checkDirectory() {
        File resDir = PathUtils.getFilePath((String)"/update/bnr/");
        File[] res = resDir.listFiles();
        if (res != null && res.length > 0) {
            this.log.info((Object)("Directory " + resDir.getAbsolutePath() + " is not empty"));
            try {
                this.moveFiles();
            }
            catch (Exception ex) {
                this.log.error((Object)"Erron on move banners: ", (Throwable)ex);
            }
        }
    }

    protected abstract void onState(int var1);
}

