/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.core.reboot.SafeReboot;
import fxterm.core.update.BaseUpdateStateListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

abstract class LocalAppStateListener
extends BaseUpdateStateListener {
    private final Logger log;
    private Set<String> names;

    public LocalAppStateListener(ClientInterface server, Logger log) {
        super(server, (short)0, log);
        this.log = log;
    }

    @Override
    public void _onStart() {
        this.log.info((Object)"AppState: start update");
        this.names = new HashSet<String>();
    }

    @Override
    public void _onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.log.info((Object)("AppState: local error, metrics=" + updateMetric));
        this.onState(1);
    }

    @Override
    public void _onGlobalError(Exception ex) {
        this.log.info((Object)"AppState: global error");
        this.onState(2);
    }

    @Override
    public void _onSkip() {
        this.log.info((Object)"AppState: skip update");
        File appDir = PathUtils.getFilePath((String)"/update/app/");
        File[] res = appDir.listFiles();
        if (res != null && res.length > 0) {
            this.log.info((Object)("Directory " + appDir.getAbsolutePath() + " is not empty:"));
            for (File f : res) {
                this.log.info((Object)("    " + f.getName()));
            }
            this.log.info((Object)"Restart software");
            SafeReboot.exit(17, 3);
        } else {
            this.onState(0);
            this.onCheckBanners();
        }
    }

    @Override
    public boolean _onSuccess(UpdateMetric updateMetric) {
        this.log.info((Object)("AppState: success " + updateMetric));
        this.onState(0);
        if (this.names.size() == 1 && this.names.contains("update.build")) {
            try {
                this.log.info((Object)"Copy resources");
                FileUtils.copyDirectory((File)PathUtils.getFilePath((String)"/update/app/"), (File)PathUtils.getFilePath((String)"/"));
                this.log.info((Object)"Done, clean update");
                FileUtils.cleanDirectory((File)PathUtils.getFilePath((String)"/update/app/"));
                this.log.info((Object)"Done, Reset software build");
                DaemonUtil.resetUpdateBuild();
            }
            catch (IOException ex) {
                this.log.error((Object)"Error on move update.build", (Throwable)ex);
            }
            return false;
        }
        this.log.info((Object)"Restart software");
        SafeReboot.exit(17, 3);
        return true;
    }

    @Override
    public void _onCancel() {
        this.log.info((Object)"AppState: cancel");
        this.onState(0);
    }

    @Override
    public void _onConfirm(UpdateSize updateSize) {
        this.log.info((Object)("AppState: update confirm, update size=" + updateSize));
    }

    @Override
    public void _onProgress(String fileName, int total, int progress) {
        this.names.add(fileName);
    }

    protected abstract void onState(int var1);

    protected abstract void onCheckBanners();
}

